/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.model.UserTrackerPath;
import com.liferay.portal.model.impl.UserTrackerModelImpl;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserTrackerImpl
extends UserTrackerModelImpl
implements UserTracker {
    private static Log _log = LogFactoryUtil.getLog(UserTrackerImpl.class);
    private User _user;
    private String _fullName;
    private String _emailAddress;
    private List<UserTrackerPath> _paths = new ArrayList<UserTrackerPath>();

    public String getFullName() {
        if (this._fullName == null) {
            try {
                if (this._user == null) {
                    this._user = UserLocalServiceUtil.getUserById((long)this.getUserId());
                }
                this._fullName = this._user.getFullName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._fullName == null) {
            this._fullName = "";
        }
        return this._fullName;
    }

    public String getEmailAddress() {
        if (this._emailAddress == null) {
            try {
                if (this._user == null) {
                    this._user = UserLocalServiceUtil.getUserById((long)this.getUserId());
                }
                this._emailAddress = this._user.getEmailAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._emailAddress == null) {
            this._emailAddress = "";
        }
        return this._emailAddress;
    }

    public List<UserTrackerPath> getPaths() {
        return this._paths;
    }

    public void addPath(UserTrackerPath path) {
        block2: {
            try {
                this._paths.add(path);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)aioobe);
            }
        }
        this.setModifiedDate(path.getPathDate());
    }

    public int getHits() {
        return this._paths.size();
    }

    @Override
    public int compareTo(UserTracker userTracker) {
        String userName2;
        String userName1 = this.getFullName().toLowerCase();
        int value = userName1.compareTo(userName2 = userTracker.getFullName().toLowerCase());
        if (value == 0) {
            value = this.getModifiedDate().compareTo(userTracker.getModifiedDate());
        }
        return value;
    }
}

