/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring;

import com.liferay.portal.monitoring.Level;
import com.liferay.portal.monitoring.MonitoringException;
import com.liferay.portal.monitoring.MonitoringService;
import com.liferay.portal.monitoring.statistics.DataSample;
import com.liferay.portal.monitoring.statistics.DataSampleProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMonitoringService
implements DataSampleProcessor<DataSample>,
MonitoringService {
    private Map<String, List<DataSampleProcessor<DataSample>>> _dataSampleProcessors = new ConcurrentHashMap<String, List<DataSampleProcessor<DataSample>>>();
    private Map<String, Level> _levels = new ConcurrentHashMap<String, Level>();

    @Override
    public Level getLevel(String namespace) {
        Level level = this._levels.get(namespace);
        if (level == null) {
            return Level.OFF;
        }
        return level;
    }

    @Override
    public Set<String> getNamespaces() {
        return this._levels.keySet();
    }

    @Override
    public void processDataSample(DataSample dataSample) throws MonitoringException {
        String namespace = dataSample.getNamespace();
        Level level = this._levels.get(namespace);
        if (level != null && level.equals((Object)Level.OFF)) {
            return;
        }
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (dataSampleProcessors == null || dataSampleProcessors.isEmpty()) {
            return;
        }
        for (DataSampleProcessor<DataSample> dataSampleProcessor : dataSampleProcessors) {
            dataSampleProcessor.processDataSample(dataSample);
        }
    }

    public void registerDataSampleProcessor(String namespace, DataSampleProcessor<DataSample> dataSampleProcessor) {
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (dataSampleProcessors == null) {
            dataSampleProcessors = new ArrayList<DataSampleProcessor<DataSample>>();
            this._dataSampleProcessors.put(namespace, dataSampleProcessors);
        }
        dataSampleProcessors.add(dataSampleProcessor);
    }

    public void setDataSampleProcessors(Map<String, List<DataSampleProcessor<DataSample>>> dataSampleProcessors) {
        this._dataSampleProcessors.putAll(dataSampleProcessors);
    }

    @Override
    public void setLevel(String namespace, Level level) {
        this._levels.put(namespace, level);
    }

    public void setLevels(Map<String, String> levels) {
        for (Map.Entry<String, String> entry : levels.entrySet()) {
            String namespace = entry.getKey();
            String levelName = entry.getValue();
            Level level = Level.valueOf(levelName);
            this._levels.put(namespace, level);
        }
    }

    public void unregisterDataSampleProcessor(String namespace, DataSampleProcessor<DataSample> dataSampleProcessor) {
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (dataSampleProcessors != null) {
            dataSampleProcessors.remove(dataSampleProcessor);
        }
    }
}

