/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.monitoring.statistics.DataSample;
import com.liferay.portal.monitoring.statistics.DataSampleProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MonitoringMessageListener.class);
    private DataSampleProcessor<DataSample> _dataSampleProcessor;

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    public void setDataSampleProcessor(DataSampleProcessor<DataSample> dataSampleProcessor) {
        this._dataSampleProcessor = dataSampleProcessor;
    }

    protected void doReceive(Message message) throws Exception {
        DataSample dataSample = (DataSample)message.getPayload();
        if (dataSample != null) {
            this._dataSampleProcessor.processDataSample(dataSample);
        }
    }
}

