/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics;

import com.liferay.portal.monitoring.statistics.BaseStatistics;
import com.liferay.portal.monitoring.statistics.CountStatistics;

public class AverageStatistics
extends BaseStatistics {
    private long _averageTime;
    private CountStatistics _countStatistics;

    public AverageStatistics(String name) {
        super(name);
        this._countStatistics = new CountStatistics(name);
    }

    public void addDuration(long duration) {
        this._countStatistics.incrementCount();
        this.setLastTime(duration);
        if (this.getMaxTime() < duration) {
            this.setMaxTime(duration);
        } else if (this.getMinTime() == 0L || this.getMinTime() > duration) {
            this.setMinTime(duration);
        }
        if (this._averageTime == 0L) {
            this._averageTime = duration;
        } else {
            long span = 0L;
            span = this._countStatistics.getCount() < this.getLowerBound() ? this.getLowerBound() : (this._countStatistics.getCount() > this.getUpperBound() ? this.getUpperBound() : this._countStatistics.getCount());
            this._averageTime = (this._averageTime * span + duration) / (span + 1L);
        }
        this.setLastSampleTime(System.currentTimeMillis());
    }

    public long getAverageTime() {
        return this._averageTime;
    }

    public long getCount() {
        return this._countStatistics.getCount();
    }

    public void reset() {
        super.reset();
        this._averageTime = 0L;
    }
}

