/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.plugin.ModuleId;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPackageIndexer
implements Indexer {
    public static final String PORTLET_ID = "PluginPackageIndexer";
    private static final String[] _CLASS_NAMES = new String[0];

    public static void addPluginPackage(String moduleId, String name, String version, Date modifiedDate, String author, List<String> types, List<String> tags, List<License> licenses, List<String> liferayVersions, String shortDescription, String longDescription, String changeLog, String pageURL, String repositoryURL, String status, String installedVersion) throws SearchException {
        Document doc = PluginPackageIndexer.getPluginPackageDocument(moduleId, name, version, modifiedDate, author, types, tags, licenses, liferayVersions, shortDescription, longDescription, changeLog, pageURL, repositoryURL, status, installedVersion);
        SearchEngineUtil.addDocument((long)0L, (Document)doc);
    }

    public static void cleanIndex() throws SearchException {
        SearchEngineUtil.deletePortletDocuments((long)0L, (String)PORTLET_ID);
    }

    public static Document getPluginPackageDocument(String moduleId, String name, String version, Date modifiedDate, String author, List<String> types, List<String> tags, List<License> licenses, List<String> liferayVersions, String shortDescription, String longDescription, String changeLog, String pageURL, String repositoryURL, String status, String installedVersion) {
        ModuleId moduleIdObj = ModuleId.getInstance(moduleId);
        shortDescription = HtmlUtil.extractText((String)shortDescription);
        longDescription = HtmlUtil.extractText((String)longDescription);
        String content = name + " " + author + " " + shortDescription + " " + longDescription;
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, moduleId);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", moduleIdObj.getGroupId());
        doc.addText("title", name);
        doc.addText("content", content);
        doc.addKeyword("moduleId", moduleId);
        doc.addKeyword("artifactId", moduleIdObj.getArtifactId());
        doc.addKeyword("version", version);
        doc.addText("author", author);
        doc.addKeyword("type", types.toArray(new String[0]));
        doc.addKeyword("tag", tags.toArray(new String[0]));
        String[] licenseNames = new String[licenses.size()];
        boolean osiLicense = false;
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            licenseNames[i] = license.getName();
            if (!license.isOsiApproved()) continue;
            osiLicense = true;
        }
        doc.addKeyword("license", licenseNames);
        doc.addKeyword("osi-approved-license", String.valueOf(osiLicense));
        doc.addText("shortDescription", shortDescription);
        doc.addText("longDescription", longDescription);
        doc.addText("changeLog", changeLog);
        doc.addText("pageURL", pageURL);
        doc.addKeyword("repositoryURL", repositoryURL);
        doc.addKeyword("status", status);
        doc.addKeyword("installedVersion", installedVersion);
        return doc;
    }

    public static String getPluginPackagerUID(String moduleId) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, moduleId);
        return doc.get("uid");
    }

    public static void removePluginPackage(String moduleId) throws SearchException {
        SearchEngineUtil.deleteDocument((long)0L, (String)PluginPackageIndexer.getPluginPackagerUID(moduleId));
    }

    public static void updatePluginPackage(String moduleId, String name, String version, Date modifiedDate, String author, List<String> types, List<String> tags, List<License> licenses, List<String> liferayVersions, String shortDescription, String longDescription, String changeLog, String pageURL, String repositoryURL, String status, String installedVersion) throws SearchException {
        Document doc = PluginPackageIndexer.getPluginPackageDocument(moduleId, name, version, modifiedDate, author, types, tags, licenses, liferayVersions, shortDescription, longDescription, changeLog, pageURL, repositoryURL, status, installedVersion);
        SearchEngineUtil.updateDocument((long)0L, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String moduleId = doc.get("moduleId");
        String repositoryURL = doc.get("repositoryURL");
        portletURL.setParameter("struts_action", "/admin/view");
        portletURL.setParameter("tabs2", "repositories");
        portletURL.setParameter("moduleId", moduleId);
        portletURL.setParameter("repositoryURL", repositoryURL);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) {
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            PluginPackageUtil.reIndex();
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

