/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.plugin;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.RemotePluginPackageRepository;
import com.liferay.portal.kernel.plugin.Screenshot;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.plugin.LocalPluginPackageRepository;
import com.liferay.portal.plugin.PluginPackageException;
import com.liferay.portal.plugin.PluginPackageImpl;
import com.liferay.portal.plugin.PluginPackageIndexer;
import com.liferay.portal.plugin.RepositoryReport;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginPackageUtil {
    public static final String REPOSITORY_XML_FILENAME_EXTENSION = "xml";
    public static final String REPOSITORY_XML_FILENAME_PREFIX = "liferay-plugin-repository";
    private static Log _log = LogFactoryUtil.getLog(PluginPackageUtil.class);
    private static PluginPackageUtil _instance = new PluginPackageUtil();
    private Set<String> _availableTagsCache;
    private LocalPluginPackageRepository _installedPluginPackages = new LocalPluginPackageRepository();
    private Date _lastUpdateDate;
    private Map<String, RemotePluginPackageRepository> _repositoryCache = new HashMap<String, RemotePluginPackageRepository>();
    private boolean _settingUpdateAvailable;
    private Boolean _updateAvailable;

    public static void endPluginPackageInstallation(String preliminaryContext) {
        _instance._endPluginPackageInstallation(preliminaryContext);
    }

    public static List<PluginPackage> getAllAvailablePluginPackages() throws PluginPackageException {
        return _instance._getAllAvailablePluginPackages();
    }

    public static Collection<String> getAvailableTags() {
        return _instance._getAvailableTags();
    }

    public static List<PluginPackage> getInstalledPluginPackages() {
        return _instance._getInstalledPluginPackages();
    }

    public static Date getLastUpdateDate() {
        return _instance._getLastUpdateDate();
    }

    public static PluginPackage getLatestAvailablePluginPackage(String groupId, String artifactId) throws SystemException {
        return _instance._getLatestAvailablePluginPackage(groupId, artifactId);
    }

    public static PluginPackage getLatestInstalledPluginPackage(String groupId, String artifactId) {
        return _instance._getLatestInstalledPluginPackage(groupId, artifactId);
    }

    public static PluginPackage getPluginPackageByModuleId(String moduleId, String repositoryURL) throws PluginPackageException {
        return _instance._getPluginPackageByModuleId(moduleId, repositoryURL);
    }

    public static PluginPackage getPluginPackageByURL(String url) throws PluginPackageException {
        return _instance._getPluginPackageByURL(url);
    }

    public static RemotePluginPackageRepository getRepository(String repositoryURL) throws PluginPackageException {
        return _instance._getRepository(repositoryURL);
    }

    public static String[] getRepositoryURLs() throws PluginPackageException {
        return _instance._getRepositoryURLs();
    }

    public static String[] getSupportedTypes() {
        return _instance._getSupportedTypes();
    }

    public static boolean isCurrentVersionSupported(List<String> versions) {
        return _instance._isCurrentVersionSupported(versions);
    }

    public static boolean isIgnored(PluginPackage pluginPackage) throws SystemException {
        return _instance._isIgnored(pluginPackage);
    }

    public static boolean isInstallationInProcess(String context) {
        return _instance._isInstallationInProcess(context);
    }

    public static boolean isTrusted(String repositoryURL) throws PluginPackageException {
        return _instance._isTrusted(repositoryURL);
    }

    public static boolean isUpdateAvailable() throws SystemException {
        return _instance._isUpdateAvailable();
    }

    public static PluginPackage readPluginPackageProperties(String displayName, Properties props) {
        return _instance._readPluginPackageProperties(displayName, props);
    }

    public static PluginPackage readPluginPackageXml(Element pluginPackageEl) {
        return _instance._readPluginPackageXml(pluginPackageEl);
    }

    public static PluginPackage readPluginPackageXml(String xml) throws DocumentException {
        return _instance._readPluginPackageXml(xml);
    }

    public static void refreshUpdatesAvailableCache() {
        _instance._refreshUpdatesAvailableCache();
    }

    public static void registerInstalledPluginPackage(PluginPackage pluginPackage) {
        _instance._registerInstalledPluginPackage(pluginPackage);
    }

    public static void registerPluginPackageInstallation(String preliminaryContext) {
        _instance._registerPluginPackageInstallation(preliminaryContext);
    }

    public static void reIndex() throws SystemException {
        _instance._reIndex();
    }

    public static RepositoryReport reloadRepositories() throws SystemException {
        return _instance._reloadRepositories();
    }

    public static Hits search(String keywords, String type, String tag, String license, String repositoryURL, String status, int start, int end) throws SystemException {
        return _instance._search(keywords, type, tag, license, repositoryURL, status, start, end);
    }

    public static void unregisterInstalledPluginPackage(PluginPackage pluginPackage) {
        _instance._unregisterInstalledPluginPackage(pluginPackage);
    }

    public static void updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        _instance._updateInstallingPluginPackage(preliminaryContext, pluginPackage);
    }

    private PluginPackageUtil() {
        this._availableTagsCache = new TreeSet<String>();
    }

    private void _checkRepositories(String repositoryURL) throws PluginPackageException {
        String[] repositoryURLs = null;
        repositoryURLs = Validator.isNotNull((String)repositoryURL) ? new String[]{repositoryURL} : this._getRepositoryURLs();
        for (int i = 0; i < repositoryURLs.length; ++i) {
            this._getRepository(repositoryURLs[i]);
        }
    }

    private void _endPluginPackageInstallation(String preliminaryContext) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
    }

    private PluginPackage _findLatestVersion(List<PluginPackage> pluginPackages) {
        PluginPackage latestPluginPackage = null;
        for (PluginPackage pluginPackage : pluginPackages) {
            if (latestPluginPackage != null && !pluginPackage.isLaterVersionThan(latestPluginPackage)) continue;
            latestPluginPackage = pluginPackage;
        }
        return latestPluginPackage;
    }

    private List<PluginPackage> _getAllAvailablePluginPackages() throws PluginPackageException {
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        String[] repositoryURLs = this._getRepositoryURLs();
        for (int i = 0; i < repositoryURLs.length; ++i) {
            try {
                RemotePluginPackageRepository repository = this._getRepository(repositoryURLs[i]);
                pluginPackages.addAll(repository.getPluginPackages());
                continue;
            }
            catch (PluginPackageException ppe) {
                String message = ppe.getMessage();
                if (message.startsWith("Unable to communicate")) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)message);
                    continue;
                }
                _log.error((Object)message);
            }
        }
        return pluginPackages;
    }

    private List<PluginPackage> _getAvailablePluginPackages(String groupId, String artifactId) throws PluginPackageException {
        ArrayList<PluginPackage> pluginPackages = new ArrayList<PluginPackage>();
        String[] repositoryURLs = this._getRepositoryURLs();
        for (int i = 0; i < repositoryURLs.length; ++i) {
            RemotePluginPackageRepository repository = this._getRepository(repositoryURLs[i]);
            List curPluginPackages = repository.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
            if (curPluginPackages == null) continue;
            pluginPackages.addAll(curPluginPackages);
        }
        return pluginPackages;
    }

    private Collection<String> _getAvailableTags() {
        return this._availableTagsCache;
    }

    private List<PluginPackage> _getInstalledPluginPackages() {
        return this._installedPluginPackages.getSortedPluginPackages();
    }

    private Date _getLastUpdateDate() {
        return this._lastUpdateDate;
    }

    private PluginPackage _getLatestAvailablePluginPackage(String groupId, String artifactId) throws SystemException {
        List<PluginPackage> pluginPackages = this._getAvailablePluginPackages(groupId, artifactId);
        return this._findLatestVersion(pluginPackages);
    }

    private PluginPackage _getLatestInstalledPluginPackage(String groupId, String artifactId) {
        return this._installedPluginPackages.getLatestPluginPackage(groupId, artifactId);
    }

    private PluginPackage _getPluginPackageByModuleId(String moduleId, String repositoryURL) throws PluginPackageException {
        RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
        return repository.findPluginPackageByModuleId(moduleId);
    }

    private PluginPackage _getPluginPackageByURL(String url) throws PluginPackageException {
        String[] repositoryURLs = this._getRepositoryURLs();
        for (int i = 0; i < repositoryURLs.length; ++i) {
            String repositoryURL = repositoryURLs[i];
            try {
                RemotePluginPackageRepository repository = this._getRepository(repositoryURL);
                return repository.findPluginByArtifactURL(url);
            }
            catch (PluginPackageException pe) {
                _log.error((Object)("Unable to load repository " + repositoryURL), (Throwable)((Object)pe));
                continue;
            }
        }
        return null;
    }

    private RemotePluginPackageRepository _getRepository(String repositoryURL) throws PluginPackageException {
        RemotePluginPackageRepository repository = this._repositoryCache.get(repositoryURL);
        if (repository != null) {
            return repository;
        }
        return this._loadRepository(repositoryURL);
    }

    private String[] _getRepositoryURLs() throws PluginPackageException {
        try {
            String[] trusted = PrefsPropsUtil.getStringArray("plugin.repositories.trusted", "\n", PropsValues.PLUGIN_REPOSITORIES_TRUSTED);
            String[] untrusted = PrefsPropsUtil.getStringArray("plugin.repositories.untrusted", "\n", PropsValues.PLUGIN_REPOSITORIES_UNTRUSTED);
            return ArrayUtil.append((String[])trusted, (String[])untrusted);
        }
        catch (Exception e) {
            throw new PluginPackageException("Unable to read repository list", e);
        }
    }

    private String[] _getStatusAndInstalledVersion(PluginPackage pluginPackage) {
        PluginPackage installedPluginPackage = this._installedPluginPackages.getLatestPluginPackage(pluginPackage.getGroupId(), pluginPackage.getArtifactId());
        String status = null;
        String installedVersion = null;
        if (installedPluginPackage == null) {
            status = "notInstalled";
        } else {
            installedVersion = installedPluginPackage.getVersion();
            status = installedPluginPackage.isLaterVersionThan(pluginPackage) ? "newerVersionInstalled" : (installedPluginPackage.isPreviousVersionThan(pluginPackage) ? "olderVersionInstalled" : "sameVersionInstalled");
        }
        return new String[]{status, installedVersion};
    }

    private String[] _getSupportedTypes() {
        return PropsValues.PLUGIN_TYPES;
    }

    private void _indexPluginPackage(PluginPackage pluginPackage) {
        String[] statusAndInstalledVersion = this._getStatusAndInstalledVersion(pluginPackage);
        String status = statusAndInstalledVersion[0];
        String installedVersion = statusAndInstalledVersion[1];
        try {
            PluginPackageIndexer.updatePluginPackage(pluginPackage.getModuleId(), pluginPackage.getName(), pluginPackage.getVersion(), pluginPackage.getModifiedDate(), pluginPackage.getAuthor(), pluginPackage.getTypes(), pluginPackage.getTags(), pluginPackage.getLicenses(), pluginPackage.getLiferayVersions(), pluginPackage.getShortDescription(), pluginPackage.getLongDescription(), pluginPackage.getChangeLog(), pluginPackage.getPageURL(), pluginPackage.getRepositoryURL(), status, installedVersion);
        }
        catch (Exception e) {
            _log.error((Object)("Error reindexing " + pluginPackage.getModuleId()), (Throwable)e);
        }
    }

    private boolean _isCurrentVersionSupported(List<String> versions) {
        Version currentVersion = Version.getInstance((String)ReleaseInfo.getVersion());
        for (String version : versions) {
            Version supportedVersion = Version.getInstance((String)version);
            if (!supportedVersion.includes(currentVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean _isIgnored(PluginPackage pluginPackage) throws SystemException {
        String packageId = pluginPackage.getPackageId();
        String[] pluginPackagesIgnored = PrefsPropsUtil.getStringArray("plugin.notifications.packages.ignored", "\n", PropsValues.PLUGIN_NOTIFICATIONS_PACKAGES_IGNORED);
        for (int i = 0; i < pluginPackagesIgnored.length; ++i) {
            String prefix;
            String curPluginPackagesIgnored = pluginPackagesIgnored[i];
            if (!(curPluginPackagesIgnored.endsWith("*") ? packageId.startsWith(prefix = curPluginPackagesIgnored.substring(0, curPluginPackagesIgnored.length() - 2)) : packageId.equals(curPluginPackagesIgnored))) continue;
            return true;
        }
        return false;
    }

    private boolean _isInstallationInProcess(String context) {
        return this._installedPluginPackages.getInstallingPluginPackage(context) != null;
    }

    private boolean _isTrusted(String repositoryURL) throws PluginPackageException {
        try {
            Object[] trusted = PrefsPropsUtil.getStringArray("plugin.repositories.trusted", "\n", PropsValues.PLUGIN_REPOSITORIES_TRUSTED);
            return ArrayUtil.contains((Object[])trusted, (Object)repositoryURL);
        }
        catch (Exception e) {
            throw new PluginPackageException("Unable to read repository list", e);
        }
    }

    private boolean _isUpdateAvailable() throws SystemException {
        if (!PrefsPropsUtil.getBoolean("plugin.notifications.enabled", PropsValues.PLUGIN_NOTIFICATIONS_ENABLED)) {
            return false;
        }
        if (this._updateAvailable != null) {
            return this._updateAvailable;
        }
        if (!this._settingUpdateAvailable) {
            this._settingUpdateAvailable = true;
            Thread indexerThread = new Thread((Runnable)new UpdateAvailableRunner(), PluginPackageUtil.class.getName());
            indexerThread.setPriority(1);
            indexerThread.start();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemotePluginPackageRepository _loadRepository(String repositoryURL) throws PluginPackageException {
        RemotePluginPackageRepository repository = null;
        StringBuilder sb = new StringBuilder();
        if (!repositoryURL.startsWith("http://") && !repositoryURL.startsWith("https://")) {
            sb.append("http://");
        }
        sb.append(repositoryURL);
        sb.append("/");
        sb.append(REPOSITORY_XML_FILENAME_PREFIX);
        sb.append("-");
        sb.append(ReleaseInfo.getVersion());
        sb.append(".");
        sb.append(REPOSITORY_XML_FILENAME_EXTENSION);
        String pluginsXmlURL = sb.toString();
        try {
            HttpImpl httpImpl = (HttpImpl)HttpUtil.getHttp();
            HostConfiguration hostConfig = httpImpl.getHostConfig(pluginsXmlURL);
            HttpClient client = httpImpl.getClient(hostConfig);
            GetMethod getFileMethod = new GetMethod(pluginsXmlURL);
            byte[] bytes = null;
            try {
                int responseCode = client.executeMethod(hostConfig, (HttpMethod)getFileMethod);
                if (responseCode != 200) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("A repository for version " + ReleaseInfo.getVersion() + " was not found. " + "Checking general repository"));
                    }
                    sb = new StringBuilder();
                    sb.append(repositoryURL);
                    sb.append("/");
                    sb.append(REPOSITORY_XML_FILENAME_PREFIX);
                    sb.append(".");
                    sb.append(REPOSITORY_XML_FILENAME_EXTENSION);
                    pluginsXmlURL = sb.toString();
                    getFileMethod.releaseConnection();
                    getFileMethod = new GetMethod(pluginsXmlURL);
                    responseCode = client.executeMethod(hostConfig, (HttpMethod)getFileMethod);
                    if (responseCode != 200) {
                        throw new PluginPackageException("Unable to download file " + pluginsXmlURL + " because of response code " + responseCode);
                    }
                }
                bytes = getFileMethod.getResponseBody();
            }
            finally {
                getFileMethod.releaseConnection();
            }
            if (bytes != null && bytes.length > 0) {
                repository = this._parseRepositoryXml(new String(bytes), repositoryURL);
                this._repositoryCache.put(repositoryURL, repository);
                this._availableTagsCache.addAll(repository.getTags());
                this._lastUpdateDate = new Date();
                this._updateAvailable = null;
                return repository;
            }
            this._lastUpdateDate = new Date();
            throw new PluginPackageException("Download returned 0 bytes");
        }
        catch (MalformedURLException mue) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Invalid URL " + pluginsXmlURL, mue);
        }
        catch (IOException ioe) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Unable to communicate with repository " + repositoryURL, ioe);
        }
        catch (DocumentException de) {
            this._repositoryCache.remove(repositoryURL);
            throw new PluginPackageException("Unable to parse plugin list for repository " + repositoryURL, de);
        }
    }

    private RemotePluginPackageRepository _parseRepositoryXml(String xml, String repositoryURL) throws DocumentException {
        List<String> supportedPluginTypes = Arrays.asList(PluginPackageUtil.getSupportedTypes());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading plugin repository " + repositoryURL + ":\n" + xml));
        }
        RemotePluginPackageRepository pluginPackageRepository = new RemotePluginPackageRepository(repositoryURL);
        if (xml == null) {
            return pluginPackageRepository;
        }
        com.liferay.portal.kernel.xml.Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        Properties settings = this._readProperties(root.element("settings"), "setting");
        pluginPackageRepository.setSettings(settings);
        for (Element pluginPackageEl : root.elements("plugin-package")) {
            PluginPackage pluginPackage = this._readPluginPackageXml(pluginPackageEl);
            if (!this._isCurrentVersionSupported(pluginPackage.getLiferayVersions())) continue;
            Iterator itr2 = pluginPackage.getTypes().iterator();
            boolean containsSupportedTypes = false;
            while (itr2.hasNext()) {
                String type = (String)itr2.next();
                if (!supportedPluginTypes.contains(type)) continue;
                containsSupportedTypes = true;
                break;
            }
            if (!containsSupportedTypes) continue;
            pluginPackage.setRepository(pluginPackageRepository);
            pluginPackageRepository.addPluginPackage(pluginPackage);
            this._indexPluginPackage(pluginPackage);
        }
        return pluginPackageRepository;
    }

    private Date _readDate(String text) {
        block3: {
            if (Validator.isNotNull((String)text)) {
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"EEE, dd MMM yyyy HH:mm:ss Z", (Locale)Locale.US);
                try {
                    return dateFormat.parse(text);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to parse date " + text));
                }
            }
        }
        return new Date();
    }

    private String _readHtml(String text) {
        return GetterUtil.getString((String)text);
    }

    private List<License> _readLicenseList(Element parentEL, String name) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (Element licenseEl : parentEL.elements(name)) {
            Attribute url;
            License license = new License();
            license.setName(licenseEl.getText());
            Attribute osiApproved = licenseEl.attribute("osi-approved");
            if (osiApproved != null) {
                license.setOsiApproved(GetterUtil.getBoolean((String)osiApproved.getText()));
            }
            if ((url = licenseEl.attribute("url")) != null) {
                license.setUrl(url.getText());
            }
            licenses.add(license);
        }
        return licenses;
    }

    private List<String> _readList(Element parentEl, String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (parentEl != null) {
            for (Element el : parentEl.elements(name)) {
                String text = el.getText().trim().toLowerCase();
                result.add(text);
            }
        }
        return result;
    }

    private PluginPackage _readPluginPackageProperties(String displayName, Properties properties) {
        String[] tagsArray;
        String[] liferayVersionsArray;
        int pos = displayName.indexOf("-portlet");
        String pluginType = "portlet";
        if (pos == -1) {
            pos = displayName.indexOf("-ext");
            pluginType = "ext";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-hook");
            pluginType = "hook";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-layouttpl");
            pluginType = "layout-template";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-theme");
            pluginType = "theme";
        }
        if (pos == -1) {
            pos = displayName.indexOf("-web");
            pluginType = "web";
        }
        if (pos == -1) {
            return null;
        }
        String displayPrefix = displayName.substring(0, pos);
        String moduleGroupId = GetterUtil.getString((String)properties.getProperty("module-group-id"));
        String moduleArtifactId = displayPrefix + "-" + pluginType;
        String moduleVersion = null;
        int moduleVersionPos = pos + pluginType.length() + 2;
        moduleVersion = displayName.length() > moduleVersionPos ? displayName.substring(moduleVersionPos) : ReleaseInfo.getVersion();
        String moduleId = moduleGroupId + "/" + moduleArtifactId + "/" + moduleVersion + "/war";
        String pluginName = GetterUtil.getString((String)properties.getProperty("name"));
        String deploymentContext = GetterUtil.getString((String)properties.getProperty("recommended-deployment-context"), (String)moduleArtifactId);
        String author = GetterUtil.getString((String)properties.getProperty("author"));
        ArrayList<String> types = new ArrayList<String>();
        types.add(pluginType);
        ArrayList<License> licenses = new ArrayList<License>();
        String[] licensesArray = StringUtil.split((String)properties.getProperty("licenses"));
        for (int i = 0; i < licensesArray.length; ++i) {
            License license = new License();
            license.setName(licensesArray[i].trim());
            license.setOsiApproved(true);
            licenses.add(license);
        }
        ArrayList<String> liferayVersions = new ArrayList<String>();
        for (String liferayVersion : liferayVersionsArray = StringUtil.split((String)properties.getProperty("liferay-versions"))) {
            liferayVersions.add(liferayVersion.trim());
        }
        if (liferayVersions.size() == 0) {
            liferayVersions.add(ReleaseInfo.getVersion() + "+");
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : tagsArray = StringUtil.split((String)properties.getProperty("tags"))) {
            tags.add(tag.trim());
        }
        String shortDescription = GetterUtil.getString((String)properties.getProperty("short-description"));
        String longDescription = GetterUtil.getString((String)properties.getProperty("long-description"));
        String changeLog = GetterUtil.getString((String)properties.getProperty("change-log"));
        String pageURL = GetterUtil.getString((String)properties.getProperty("page-url"));
        String downloadURL = GetterUtil.getString((String)properties.getProperty("download-url"));
        PluginPackageImpl pluginPackage = new PluginPackageImpl(moduleId);
        pluginPackage.setName(pluginName);
        pluginPackage.setRecommendedDeploymentContext(deploymentContext);
        pluginPackage.setAuthor(author);
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(licenses);
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(tags);
        pluginPackage.setShortDescription(shortDescription);
        pluginPackage.setLongDescription(longDescription);
        pluginPackage.setChangeLog(changeLog);
        pluginPackage.setPageURL(pageURL);
        pluginPackage.setDownloadURL(downloadURL);
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(Element pluginPackageEl) {
        String name = pluginPackageEl.elementText("name");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading pluginPackage definition " + name));
        }
        PluginPackageImpl pluginPackage = new PluginPackageImpl(GetterUtil.getString((String)pluginPackageEl.elementText("module-id")));
        List<String> liferayVersions = this._readList(pluginPackageEl.element("liferay-versions"), "liferay-version");
        List<String> types = this._readList(pluginPackageEl.element("types"), "type");
        pluginPackage.setName(this._readText(name));
        pluginPackage.setRecommendedDeploymentContext(this._readText(pluginPackageEl.elementText("recommended-deployment-context")));
        pluginPackage.setModifiedDate(this._readDate(pluginPackageEl.elementText("modified-date")));
        pluginPackage.setAuthor(this._readText(pluginPackageEl.elementText("author")));
        pluginPackage.setTypes(types);
        pluginPackage.setLicenses(this._readLicenseList(pluginPackageEl.element("licenses"), "license"));
        pluginPackage.setLiferayVersions(liferayVersions);
        pluginPackage.setTags(this._readList(pluginPackageEl.element("tags"), "tag"));
        pluginPackage.setShortDescription(this._readText(pluginPackageEl.elementText("short-description")));
        pluginPackage.setLongDescription(this._readHtml(pluginPackageEl.elementText("long-description")));
        pluginPackage.setChangeLog(this._readHtml(pluginPackageEl.elementText("change-log")));
        pluginPackage.setScreenshots(this._readScreenshots(pluginPackageEl.element("screenshots")));
        pluginPackage.setPageURL(this._readText(pluginPackageEl.elementText("page-url")));
        pluginPackage.setDownloadURL(this._readText(pluginPackageEl.elementText("download-url")));
        pluginPackage.setDeploymentSettings(this._readProperties(pluginPackageEl.element("deployment-settings"), "setting"));
        return pluginPackage;
    }

    private PluginPackage _readPluginPackageXml(String xml) throws DocumentException {
        com.liferay.portal.kernel.xml.Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        return this._readPluginPackageXml(root);
    }

    private Properties _readProperties(Element parentEl, String name) {
        Properties result = new Properties();
        if (parentEl != null) {
            for (Element el : parentEl.elements(name)) {
                result.setProperty(el.attribute("name").getValue(), el.attribute("value").getValue());
            }
        }
        return result;
    }

    private List<Screenshot> _readScreenshots(Element parentEl) {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        if (parentEl != null) {
            for (Element screenshotEl : parentEl.elements("screenshot")) {
                Screenshot screenshot = new Screenshot();
                screenshot.setThumbnailURL(screenshotEl.element("thumbnail-url").getText());
                screenshot.setLargeImageURL(screenshotEl.element("large-image-url").getText());
                screenshots.add(screenshot);
            }
        }
        return screenshots;
    }

    private String _readText(String text) {
        return HtmlUtil.extractText((String)GetterUtil.getString((String)text));
    }

    private void _refreshUpdatesAvailableCache() {
        this._updateAvailable = null;
    }

    private void _registerInstalledPluginPackage(PluginPackage pluginPackage) {
        this._installedPluginPackages.addPluginPackage(pluginPackage);
        this._updateAvailable = null;
        this._indexPluginPackage(pluginPackage);
    }

    private void _registerPluginPackageInstallation(String preliminaryContext) {
        this._installedPluginPackages.registerPluginPackageInstallation(preliminaryContext);
    }

    private void _reIndex() throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            PluginPackageIndexer.cleanIndex();
            for (PluginPackage pluginPackage : this._getAllAvailablePluginPackages()) {
                String[] statusAndInstalledVersion = this._getStatusAndInstalledVersion(pluginPackage);
                String status = statusAndInstalledVersion[0];
                String installedVersion = statusAndInstalledVersion[1];
                Document doc = PluginPackageIndexer.getPluginPackageDocument(pluginPackage.getModuleId(), pluginPackage.getName(), pluginPackage.getVersion(), pluginPackage.getModifiedDate(), pluginPackage.getAuthor(), pluginPackage.getTypes(), pluginPackage.getTags(), pluginPackage.getLicenses(), pluginPackage.getLiferayVersions(), pluginPackage.getShortDescription(), pluginPackage.getLongDescription(), pluginPackage.getChangeLog(), pluginPackage.getPageURL(), pluginPackage.getRepositoryURL(), status, installedVersion);
                SearchEngineUtil.addDocument((long)0L, (Document)doc);
            }
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private RepositoryReport _reloadRepositories() throws SystemException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Reloading repositories");
        }
        RepositoryReport repositoryReport = new RepositoryReport();
        String[] repositoryURLs = this._getRepositoryURLs();
        for (int i = 0; i < repositoryURLs.length; ++i) {
            String repositoryURL = repositoryURLs[i];
            try {
                this._loadRepository(repositoryURL);
                repositoryReport.addSuccess(repositoryURL);
                continue;
            }
            catch (PluginPackageException pe) {
                repositoryReport.addError(repositoryURL, pe);
                _log.error((Object)("Unable to load repository " + repositoryURL + " " + pe.toString()));
            }
        }
        this._reIndex();
        return repositoryReport;
    }

    private Hits _search(String keywords, String type, String tag, String license, String repositoryURL, String status, int start, int end) throws SystemException {
        this._checkRepositories(repositoryURL);
        try {
            BooleanQuery searchQuery;
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "PluginPackageIndexer");
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (Validator.isNotNull((String)keywords)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)type)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addExactTerm("type", type);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)tag)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addExactTerm("tag", tag);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)repositoryURL)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                TermQuery query = TermQueryFactoryUtil.create((String)"repositoryURL", (String)repositoryURL);
                searchQuery.add((Query)query, BooleanClauseOccur.SHOULD);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)license)) {
                searchQuery = BooleanQueryFactoryUtil.create();
                searchQuery.addExactTerm("license", license);
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)status) && !status.equals("all")) {
                searchQuery = BooleanQueryFactoryUtil.create();
                if (status.equals("notInstalledOrOlderVersionInstalled")) {
                    searchQuery.addExactTerm("status", "notInstalled");
                    searchQuery.addExactTerm("status", "olderVersionInstalled");
                } else {
                    searchQuery.addExactTerm("status", status);
                }
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)0L, (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    private void _unregisterInstalledPluginPackage(PluginPackage pluginPackage) {
        block3: {
            this._installedPluginPackages.removePluginPackage(pluginPackage);
            try {
                List<PluginPackage> pluginPackages = this._getAvailablePluginPackages(pluginPackage.getGroupId(), pluginPackage.getArtifactId());
                for (PluginPackage availablePackage : pluginPackages) {
                    this._indexPluginPackage(availablePackage);
                }
            }
            catch (PluginPackageException ppe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to reindex unistalled package " + pluginPackage.getContext() + ": " + ppe.getMessage()));
            }
        }
    }

    private void _updateInstallingPluginPackage(String preliminaryContext, PluginPackage pluginPackage) {
        this._installedPluginPackages.unregisterPluginPackageInstallation(preliminaryContext);
        this._installedPluginPackages.registerPluginPackageInstallation(pluginPackage);
    }

    private class UpdateAvailableRunner
    implements Runnable {
        private UpdateAvailableRunner() {
        }

        public void run() {
            block2: {
                try {
                    this.setUpdateAvailable();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)e.getMessage());
                }
            }
        }

        protected void setUpdateAvailable() throws Exception {
            StopWatch stopWatch = null;
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Checking for available updates");
                stopWatch = new StopWatch();
                stopWatch.start();
            }
            for (PluginPackage pluginPackage : PluginPackageUtil.this._installedPluginPackages.getPluginPackages()) {
                Version availablePluginPackageVersion;
                PluginPackage availablePluginPackage = null;
                if (PluginPackageUtil.this._isIgnored(pluginPackage) || (availablePluginPackage = PluginPackageUtil.getLatestAvailablePluginPackage(pluginPackage.getGroupId(), pluginPackage.getArtifactId())) == null || !(availablePluginPackageVersion = Version.getInstance((String)availablePluginPackage.getVersion())).isLaterVersionThan(pluginPackage.getVersion())) continue;
                PluginPackageUtil.this._updateAvailable = Boolean.TRUE;
                break;
            }
            if (PluginPackageUtil.this._updateAvailable == null) {
                PluginPackageUtil.this._updateAvailable = Boolean.FALSE;
            }
            PluginPackageUtil.this._settingUpdateAvailable = false;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished checking for available updates in " + stopWatch.getTime() + " ms"));
            }
        }
    }
}

