/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.poller.PollerException;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.poller.PollerRequest;
import com.liferay.portal.kernel.poller.PollerResponse;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.poller.PollerProcessorUtil;

public class PollerMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(PollerMessageListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        PollerResponse pollerResponse;
        block9: {
            pollerResponse = null;
            try {
                PollerRequest pollerRequest = (PollerRequest)message.getPayload();
                String portletId = pollerRequest.getPortletId();
                PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
                if (pollerRequest.isReceiveRequest()) {
                    pollerResponse = new PollerResponse(portletId, pollerRequest.getChunkId());
                    try {
                        pollerProcessor.receive(pollerRequest, pollerResponse);
                    }
                    catch (PollerException pe) {
                        _log.error((Object)("Unable to receive poller request " + pollerRequest), (Throwable)pe);
                        pollerResponse.setParameter("pollerException", pe.getMessage());
                    }
                    break block9;
                }
                try {
                    pollerProcessor.send(pollerRequest);
                }
                catch (PollerException pe) {
                    _log.error((Object)("Unable to send poller request " + pollerRequest), (Throwable)pe);
                }
            }
            catch (Throwable throwable) {
                String responseDestinationName = message.getResponseDestinationName();
                if (Validator.isNotNull((String)responseDestinationName)) {
                    Message responseMessage = MessageBusUtil.createResponseMessage((Message)message);
                    responseMessage.setPayload(pollerResponse);
                    MessageBusUtil.sendMessage((String)responseDestinationName, (Message)responseMessage);
                }
                throw throwable;
            }
        }
        String responseDestinationName = message.getResponseDestinationName();
        if (Validator.isNotNull((String)responseDestinationName)) {
            Message responseMessage = MessageBusUtil.createResponseMessage((Message)message);
            responseMessage.setPayload((Object)pollerResponse);
            MessageBusUtil.sendMessage((String)responseDestinationName, (Message)responseMessage);
        }
    }
}

