/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop;

import com.liferay.portal.kernel.job.IntervalJob;
import com.liferay.portal.kernel.job.JobExecutionContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.pop.POPServerUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.mail.MailEngine;
import java.util.List;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPNotificationsJob
implements IntervalJob {
    public static final long INTERVAL = GetterUtil.getLong((String)PropsUtil.get("pop.server.notifications.interval")) * 60000L;
    private static Log _log = LogFactoryUtil.getLog(POPNotificationsJob.class);
    private Store _store;
    private Folder _inboxFolder;

    public void execute(JobExecutionContext context) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Executing");
            }
            this.pollPopServer();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this._store = null;
            this._inboxFolder = null;
        }
    }

    public long getInterval() {
        return INTERVAL;
    }

    protected String getEmailAddress(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        InternetAddress internetAddress = (InternetAddress)addresses[0];
        return internetAddress.getAddress();
    }

    protected void initInboxFolder() throws Exception {
        if (this._inboxFolder == null || !this._inboxFolder.isOpen()) {
            this.initStore();
            Folder defaultFolder = this._store.getDefaultFolder();
            Folder[] folders = defaultFolder.list();
            if (folders.length == 0) {
                throw new MessagingException("Inbox not found");
            }
            this._inboxFolder = folders[0];
            this._inboxFolder.open(2);
        }
    }

    protected void initStore() throws Exception {
        if (this._store == null || !this._store.isConnected()) {
            String password;
            Session session = MailEngine.getSession();
            String storeProtocol = GetterUtil.getString((String)session.getProperty("mail.store.protocol"));
            if (!storeProtocol.equals("pop3s")) {
                storeProtocol = "pop3";
            }
            this._store = session.getStore(storeProtocol);
            String prefix = "mail." + storeProtocol + ".";
            String host = session.getProperty(prefix + "host");
            String user = session.getProperty(prefix + "user");
            if (Validator.isNull((String)user)) {
                user = session.getProperty("mail.smtp.user");
            }
            if (Validator.isNull((String)(password = session.getProperty(prefix + "password")))) {
                password = session.getProperty("mail.smtp.password");
            }
            this._store.connect(host, user, password);
        }
    }

    protected void nostifyListeners(List<MessageListener> listeners, Message message) throws Exception {
        String from = this.getEmailAddress(message.getFrom());
        String recipient = this.getEmailAddress(message.getRecipients(Message.RecipientType.TO));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipient " + recipient));
        }
        for (MessageListener messageListener : listeners) {
            try {
                if (!messageListener.accept(from, recipient, message)) continue;
                messageListener.deliver(from, recipient, message);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected void nostifyListeners(Message[] messages) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Messages " + messages.length));
        }
        List<MessageListener> listeners = POPServerUtil.getListeners();
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message " + message));
            }
            this.nostifyListeners(listeners, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollPopServer() throws Exception {
        this.initInboxFolder();
        Message[] messages = this._inboxFolder.getMessages();
        try {
            this.nostifyListeners(messages);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Deleting messages");
            }
            this._inboxFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
            this._inboxFolder.close(true);
        }
    }
}

