/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler;

import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulerEngineProxy
implements SchedulerEngine {
    public List<SchedulerRequest> getScheduledJobs(String groupName) throws SchedulerException {
        try {
            SchedulerRequest schedulerRequest = SchedulerRequest.createRetrieveRequest((String)groupName);
            List schedulerRequests = (List)MessageBusUtil.sendSynchronousMessage((String)"liferay/scheduler", (Object)schedulerRequest, (String)"liferay/scheduler/response");
            return schedulerRequests;
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void schedule(String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) {
        SchedulerRequest schedulerRequest = SchedulerRequest.createRegisterRequest((String)groupName, (long)interval, (Date)startDate, (Date)endDate, (String)description, (String)destinationName, (String)messageBody);
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)schedulerRequest);
    }

    public void schedule(String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) {
        SchedulerRequest schedulerRequest = SchedulerRequest.createRegisterRequest((String)groupName, (String)cronText, (Date)startDate, (Date)endDate, (String)description, (String)destinationName, (String)messageBody);
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)schedulerRequest);
    }

    public void schedule(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) {
        SchedulerRequest schedulerRequest = SchedulerRequest.createRegisterRequest((String)jobName, (String)groupName, (long)interval, (Date)startDate, (Date)endDate, (String)description, (String)destinationName, (String)messageBody);
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)schedulerRequest);
    }

    public void schedule(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) {
        SchedulerRequest schedulerRequest = SchedulerRequest.createRegisterRequest((String)jobName, (String)groupName, (String)cronText, (Date)startDate, (Date)endDate, (String)description, (String)destinationName, (String)messageBody);
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)schedulerRequest);
    }

    public void shutdown() {
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)SchedulerRequest.createShutdownRequest());
    }

    public void start() {
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)SchedulerRequest.createStartupRequest());
    }

    public void unschedule(String jobName, String groupName) {
        SchedulerRequest schedulerRequest = SchedulerRequest.createUnregisterRequest((String)jobName, (String)groupName);
        MessageBusUtil.sendMessage((String)"liferay/scheduler", (Object)schedulerRequest);
    }
}

