/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.job;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

public class MessageSenderJob
implements Job {
    private static Log _log = LogFactoryUtil.getLog(MessageSenderJob.class);

    public void execute(JobExecutionContext jobExecutionContext) {
        try {
            JobDetail jobDetail = jobExecutionContext.getJobDetail();
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            String destination = jobDataMap.getString("destination");
            String messageBody = jobDataMap.getString("messageBody");
            Date scheduledFireTime = jobExecutionContext.getScheduledFireTime();
            JSONObject jsonObj = JSONFactoryUtil.createJSONObject((String)messageBody);
            jsonObj.put("scheduledFireTime", JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.serialize((Object)scheduledFireTime)));
            MessageBusUtil.sendMessage((String)destination, (Object)jsonObj.toString());
        }
        catch (Exception e) {
            _log.error((Object)"Unable to execute job", (Throwable)e);
        }
    }
}

