/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.quartz;

import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerRequest;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.scheduler.job.MessageSenderJob;
import com.liferay.portal.service.QuartzLocalService;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzSchedulerEngineImpl
implements SchedulerEngine {
    @BeanReference(name="com.liferay.portal.service.QuartzLocalService")
    protected QuartzLocalService quartzLocalService;
    private Log _log = LogFactoryUtil.getLog(QuartzSchedulerEngineImpl.class);
    private Scheduler _scheduler;

    public void afterPropertiesSet() {
        try {
            if (!PropsValues.SCHEDULER_ENABLED) {
                return;
            }
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            schedulerFactory.initialize(PropsUtil.getProperties("org.quartz.", false));
            this.quartzLocalService.checkQuartzTables();
            this._scheduler = schedulerFactory.getScheduler();
        }
        catch (Exception e) {
            this._log.error((Object)"Unable to initialize engine", (Throwable)e);
        }
    }

    public List<SchedulerRequest> getScheduledJobs(String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return new ArrayList<SchedulerRequest>();
        }
        try {
            String[] jobNames = this._scheduler.getJobNames(groupName);
            ArrayList<SchedulerRequest> requests = new ArrayList<SchedulerRequest>();
            for (String jobName : jobNames) {
                JobDetail jobDetail = this._scheduler.getJobDetail(jobName, groupName);
                if (jobDetail == null) continue;
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                String description = jobDataMap.getString("description");
                String messageBody = jobDataMap.getString("messageBody");
                SchedulerRequest schedulerRequest = null;
                Trigger trigger = this._scheduler.getTrigger(jobName, groupName);
                if (CronTrigger.class.isAssignableFrom(trigger.getClass())) {
                    CronTrigger cronTrigger = (CronTrigger)CronTrigger.class.cast(trigger);
                    schedulerRequest = SchedulerRequest.createRetrieveResponseRequest((String)jobName, (String)groupName, (String)cronTrigger.getCronExpression(), (Date)cronTrigger.getStartTime(), (Date)cronTrigger.getEndTime(), (String)description, (String)messageBody);
                } else if (SimpleTrigger.class.isAssignableFrom(trigger.getClass())) {
                    SimpleTrigger simpleTrigger = (SimpleTrigger)SimpleTrigger.class.cast(trigger);
                    schedulerRequest = SchedulerRequest.createRetrieveResponseRequest((String)jobName, (String)groupName, (long)simpleTrigger.getRepeatInterval(), (Date)simpleTrigger.getStartTime(), (Date)simpleTrigger.getEndTime(), (String)description, (String)messageBody);
                }
                if (schedulerRequest == null) continue;
                requests.add(schedulerRequest);
            }
            return requests;
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to retrieve job", (Throwable)se);
        }
    }

    public void schedule(String groupName, long interval, Date startDate, Date endDate, String description, String destination, String messageBody) throws SchedulerException {
        this.schedule(null, groupName, interval, startDate, endDate, description, destination, messageBody);
    }

    public void schedule(String groupName, String cronText, Date startDate, Date endDate, String description, String destination, String messageBody) throws SchedulerException {
        this.schedule(null, groupName, cronText, startDate, endDate, description, destination, messageBody);
    }

    public void schedule(String jobName, String groupName, long interval, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        if (Validator.isNull((String)jobName)) {
            jobName = PortalUUIDUtil.generate();
        }
        try {
            SimpleTrigger simpleTrigger = new SimpleTrigger(jobName, groupName, -1, interval);
            simpleTrigger.setJobName(jobName);
            simpleTrigger.setJobGroup(groupName);
            if (startDate == null) {
                if (ServerDetector.getServerId().equals("tomcat")) {
                    simpleTrigger.setStartTime(new Date(System.currentTimeMillis() + 60000L));
                } else {
                    simpleTrigger.setStartTime(new Date(System.currentTimeMillis() + 180000L));
                }
            } else {
                simpleTrigger.setStartTime(startDate);
            }
            if (endDate != null) {
                simpleTrigger.setEndTime(endDate);
            }
            this.schedule(groupName, (Trigger)simpleTrigger, description, destinationName, messageBody);
        }
        catch (RuntimeException re) {
            // empty catch block
        }
    }

    public void schedule(String jobName, String groupName, String cronText, Date startDate, Date endDate, String description, String destinationName, String messageBody) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        if (Validator.isNull((String)jobName)) {
            jobName = PortalUUIDUtil.generate();
        }
        try {
            CronTrigger cronTrigger = new CronTrigger(jobName, groupName, jobName, groupName, cronText);
            if (startDate == null) {
                if (ServerDetector.getServerId().equals("tomcat")) {
                    cronTrigger.setStartTime(new Date(System.currentTimeMillis() + 60000L));
                } else {
                    cronTrigger.setStartTime(new Date(System.currentTimeMillis() + 180000L));
                }
            } else {
                cronTrigger.setStartTime(startDate);
            }
            if (endDate != null) {
                cronTrigger.setEndTime(endDate);
            }
            this.schedule(groupName, (Trigger)cronTrigger, description, destinationName, messageBody);
        }
        catch (ParseException pe) {
            throw new SchedulerException("Unable to parse cron text", (Throwable)pe);
        }
        catch (RuntimeException re) {
            // empty catch block
        }
    }

    public void shutdown() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._scheduler.shutdown(false);
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to shutdown scheduler", (Throwable)se);
        }
    }

    public void start() throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._scheduler.start();
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to start scheduler", (Throwable)se);
        }
    }

    public void unschedule(String jobName, String groupName) throws SchedulerException {
        if (!PropsValues.SCHEDULER_ENABLED) {
            return;
        }
        try {
            this._scheduler.unscheduleJob(jobName, groupName);
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to unschedule job {jobName=" + jobName + ", groupName=" + groupName + "}", (Throwable)se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(String groupName, Trigger trigger, String description, String destination, String messageBody) throws SchedulerException {
        try {
            JobDetail jobDetail = new JobDetail(trigger.getJobName(), groupName, MessageSenderJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put("description", description);
            jobDataMap.put("destination", destination);
            jobDataMap.put("messageBody", messageBody);
            QuartzSchedulerEngineImpl quartzSchedulerEngineImpl = this;
            synchronized (quartzSchedulerEngineImpl) {
                this._scheduler.unscheduleJob(trigger.getJobName(), groupName);
                this._scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (ObjectAlreadyExistsException oare) {
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)"Message is already scheduled");
            }
        }
        catch (org.quartz.SchedulerException se) {
            throw new SchedulerException("Unable to scheduled job", (Throwable)se);
        }
    }
}

