/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.search.BaseOpenSearchImpl;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.ratings.model.RatingsStats;
import com.liferay.portlet.ratings.service.RatingsStatsLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public abstract class HitsOpenSearchImpl
extends BaseOpenSearchImpl {
    private static Log _log = LogFactoryUtil.getLog(HitsOpenSearchImpl.class);

    public abstract Hits getHits(long var1, long var3, long var5, String var7, int var8, int var9) throws Exception;

    public abstract String getSearchPath();

    public abstract String getTitle(String var1);

    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            int start = startPage * itemsPerPage - itemsPerPage;
            int end = startPage * itemsPerPage;
            Hits results = this.getHits(themeDisplay.getCompanyId(), groupId, userId, keywords, start, end);
            String[] queryTerms = results.getQueryTerms();
            int total = results.getLength();
            Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, this.getTitle(keywords), this.getSearchPath(), format, themeDisplay);
            com.liferay.portal.kernel.xml.Document doc = (com.liferay.portal.kernel.xml.Document)values[0];
            Element root = (Element)values[1];
            for (int i = 0; i < results.getDocs().length; ++i) {
                Document result = results.doc(i);
                String portletId = result.get("portletId");
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                String snippet = results.snippet(i);
                long resultGroupId = GetterUtil.getLong((String)result.get("groupId"));
                PortletURL portletURL = this.getPortletURL(request, portletId, resultGroupId);
                Indexer indexer = (Indexer)InstancePool.get((String)portlet.getIndexerClass());
                DocumentSummary docSummary = indexer.getDocumentSummary(result, snippet, portletURL);
                String title = docSummary.getTitle();
                String url = this.getURL(themeDisplay, resultGroupId, result, portletURL);
                Date modifedDate = result.getDate("modified");
                String content = docSummary.getContent();
                String[] tags = new String[]{};
                Field tagsEntriesField = (Field)result.getFields().get("tagsEntries");
                if (tagsEntriesField != null) {
                    tags = tagsEntriesField.getValues();
                }
                double ratings = 0.0;
                String entryClassName = result.get("entryClassName");
                long entryClassPK = GetterUtil.getLong((String)result.get("entryClassPK"));
                if (Validator.isNotNull((String)entryClassName) && entryClassPK > 0L) {
                    RatingsStats stats = RatingsStatsLocalServiceUtil.getStats((String)entryClassName, (long)entryClassPK);
                    ratings = stats.getTotalScore();
                }
                double score = results.score(i);
                this.addSearchResult(root, title, url, modifedDate, content, tags, ratings, score, format);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Return\n" + doc.asXML()));
            }
            return doc.asXML();
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected String getURL(ThemeDisplay themeDisplay, long groupId, Document result, PortletURL portletURL) throws Exception {
        return portletURL.toString();
    }
}

