/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.text.Format;
import java.util.Date;

public class OpenSearchUtil {
    public static final int DEFAULT_NAMESPACE = 0;
    public static final int OS_NAMESPACE = 1;
    public static final int RELEVANCE_NAMESPACE = 2;
    public static final int NO_NAMESPACE = 3;
    private static Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:sszzz");

    public static Element addElement(Element el, String name, int namespaceType) {
        return el.addElement(OpenSearchUtil.getQName(name, namespaceType));
    }

    public static Element addElement(Element el, String name, int namespaceType, Date value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, _dateFormat.format(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, double value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, String.valueOf(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, int value) {
        return OpenSearchUtil.addElement(el, name, namespaceType, String.valueOf(value));
    }

    public static Element addElement(Element el, String name, int namespaceType, String value) {
        Element returnElement = el.addElement(OpenSearchUtil.getQName(name, namespaceType));
        returnElement.addCDATA(value);
        return returnElement;
    }

    public static void addLink(Element root, String searchURL, String rel, String keywords, int page, int itemsPerPage) {
        Element link = OpenSearchUtil.addElement(root, "link", 0);
        link.addAttribute("rel", rel);
        link.addAttribute("href", searchURL + "?keywords=" + HttpUtil.encodeURL((String)keywords) + "&p=" + page + "&c=" + itemsPerPage + "&format=atom");
        link.addAttribute("type", "application/atom+xml");
    }

    public static Namespace getNamespace(int namespaceType) {
        Namespace namespace = null;
        if (namespaceType == 0) {
            namespace = SAXReaderUtil.createNamespace((String)"", (String)"http://www.w3.org/2005/Atom");
        } else if (namespaceType == 1) {
            namespace = SAXReaderUtil.createNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/");
        } else if (namespaceType == 2) {
            namespace = SAXReaderUtil.createNamespace((String)"relevance", (String)"http://a9.com/-/opensearch/extensions/relevance/1.0/");
        }
        return namespace;
    }

    public static QName getQName(String name, int namespaceType) {
        if (3 == namespaceType) {
            return SAXReaderUtil.createQName((String)name);
        }
        return SAXReaderUtil.createQName((String)name, (Namespace)OpenSearchUtil.getNamespace(namespaceType));
    }
}

