/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.NoSuchResourceException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchPermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;

public class SearchPermissionCheckerImpl
implements SearchPermissionChecker {
    private static Log _log = LogFactoryUtil.getLog(SearchPermissionCheckerImpl.class);

    public void addPermissionFields(long companyId, Document doc) {
        try {
            long groupId = GetterUtil.getLong((String)doc.get("groupId"));
            String className = doc.get("entryClassName");
            String classPK = doc.get("rootEntryClassPK");
            if (Validator.isNull((String)classPK)) {
                classPK = doc.get("entryClassPK");
            }
            if (Validator.isNotNull((String)className) && Validator.isNotNull((String)classPK)) {
                if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                    this.doAddPermissionFields_5(companyId, groupId, className, classPK, doc);
                } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                    this.doAddPermissionFields_6(companyId, groupId, className, classPK, doc);
                }
            }
        }
        catch (NoSuchResourceException nsre) {
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public Query getPermissionQuery(long companyId, long groupId, long userId, String className, Query query) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                return this.doGetPermissionQuery_5(companyId, groupId, userId, className, query);
            }
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                return this.doGetPermissionQuery_6(companyId, groupId, userId, className, query);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return query;
    }

    public void updatePermissionFields(long resourceId) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
                this.doUpdatePermissionFields_5(resourceId);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public void updatePermissionFields(String resourceName, String resourceClassPK) {
        try {
            if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
                this.doUpdatePermissionFields_6(resourceName, resourceClassPK);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doAddPermissionFields_5(long companyId, long groupId, String className, String classPK, Document doc) throws Exception {
        Resource resource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)4, (String)classPK);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        List<Role> roles = ResourceActionsUtil.getRoles(group, className);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            long roleId = role.getRoleId();
            if (!this.hasPermission(roleId, resource.getResourceId())) continue;
            if (role.getType() == 2 || role.getType() == 3) {
                groupRoleIds.add(groupId + "-" + roleId);
                continue;
            }
            roleIds.add(roleId);
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected void doAddPermissionFields_6(long companyId, long groupId, String className, String classPK, Document doc) throws Exception {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        List<Role> roles = ResourceActionsUtil.getRoles(group, className);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<String> groupRoleIds = new ArrayList<String>();
        for (Role role : roles) {
            long roleId = role.getRoleId();
            if (!ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)4, (String)classPK, (long)roleId, (String)"VIEW")) continue;
            if (role.getType() == 2 || role.getType() == 3) {
                groupRoleIds.add(groupId + "-" + roleId);
                continue;
            }
            roleIds.add(roleId);
        }
        doc.addKeyword("roleId", roleIds.toArray(new Long[roleIds.size()]));
        doc.addKeyword("groupRoleId", groupRoleIds.toArray(new String[groupRoleIds.size()]));
    }

    protected Query doGetPermissionQuery_5(long companyId, long groupId, long userId, String className, Query query) throws Exception {
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
        BooleanQuery permissionQuery = BooleanQueryFactoryUtil.create();
        List roles = RoleLocalServiceUtil.getUserRoles((long)userId);
        roles = ListUtil.copy((List)roles);
        List userGroupRoles = null;
        if (groupId == 0L) {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId);
        } else {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
            userGroupRoles = ListUtil.copy((List)userGroupRoles);
            userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRolesByUserUserGroupAndGroup((long)userId, (long)groupId));
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (defaultUserId != userId) {
            roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest"));
        }
        long companyResourceId = 0L;
        try {
            Resource companyResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId));
            companyResourceId = companyResource.getResourceId();
        }
        catch (NoSuchResourceException nsre) {
            // empty catch block
        }
        long groupResourceId = 0L;
        try {
            Resource groupResource = ResourceLocalServiceUtil.getResource((long)companyId, (String)className, (int)2, (String)String.valueOf(groupId));
            groupResourceId = groupResource.getResourceId();
        }
        catch (NoSuchResourceException nsre) {
            // empty catch block
        }
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) {
                return query;
            }
            long roleId = role.getRoleId();
            if (this.hasPermission(roleId, companyResourceId) || this.hasPermission(roleId, groupResourceId)) {
                return query;
            }
            permissionQuery.addTerm("roleId", role.getRoleId());
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            permissionQuery.addTerm("groupRoleId", userGroupRole.getGroupId() + "-" + userGroupRole.getRoleId());
        }
        fullQuery.add(query, BooleanClauseOccur.MUST);
        fullQuery.add((Query)permissionQuery, BooleanClauseOccur.MUST);
        return fullQuery;
    }

    protected Query doGetPermissionQuery_6(long companyId, long groupId, long userId, String className, Query query) throws Exception {
        BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
        BooleanQuery permissionQuery = BooleanQueryFactoryUtil.create();
        List roles = RoleLocalServiceUtil.getUserRoles((long)userId);
        roles = ListUtil.copy((List)roles);
        List userGroupRoles = null;
        if (groupId == 0L) {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId);
        } else {
            userGroupRoles = UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
            userGroupRoles = ListUtil.copy((List)userGroupRoles);
            userGroupRoles.addAll(UserGroupRoleLocalServiceUtil.getUserGroupRolesByUserUserGroupAndGroup((long)userId, (long)groupId));
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        if (defaultUserId != userId) {
            roles.add(RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest"));
        }
        for (Role role : roles) {
            if (role.getName().equals("Administrator")) {
                return query;
            }
            long roleId = role.getRoleId();
            if (ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)1, (String)String.valueOf(companyId), (long)roleId, (String)"VIEW") || ResourcePermissionLocalServiceUtil.hasResourcePermission((long)companyId, (String)className, (int)2, (String)String.valueOf(groupId), (long)roleId, (String)"VIEW")) {
                return query;
            }
            permissionQuery.addTerm("roleId", roleId);
        }
        for (UserGroupRole userGroupRole : userGroupRoles) {
            permissionQuery.addTerm("groupRoleId", userGroupRole.getGroupId() + "-" + userGroupRole.getRoleId());
        }
        fullQuery.add(query, BooleanClauseOccur.MUST);
        fullQuery.add((Query)permissionQuery, BooleanClauseOccur.MUST);
        return fullQuery;
    }

    protected void doUpdatePermissionFields_5(long resourceId) throws Exception {
        Resource resource = ResourceLocalServiceUtil.getResource((long)resourceId);
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)resource.getName());
        if (indexer != null) {
            indexer.reIndex(resource.getName(), GetterUtil.getLong((String)resource.getPrimKey()));
        }
    }

    protected void doUpdatePermissionFields_6(String resourceName, String resourceClassPK) throws Exception {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)resourceName);
        if (indexer != null) {
            indexer.reIndex(resourceName, GetterUtil.getLong((String)resourceClassPK));
        }
    }

    protected boolean hasPermission(long roleId, long resourceId) throws SystemException {
        if (resourceId == 0L) {
            return false;
        }
        List permissions = PermissionLocalServiceUtil.getRolePermissions((long)roleId, (long)resourceId);
        List<String> actions = ResourceActionsUtil.getActions(permissions);
        return actions.contains("VIEW");
    }
}

