/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.search.lucene.LuceneFileExtractor;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;

public class LuceneFields {
    private static final String _UID_PORTLET = "_PORTLET_";
    private static final String _UID_FIELD = "_FIELD_";

    public static String getUID(String portletId, long field1) {
        return LuceneFields.getUID(portletId, String.valueOf(field1));
    }

    public static String getUID(String portletId, Long field1) {
        return LuceneFields.getUID(portletId, (long)field1);
    }

    public static String getUID(String portletId, String field1) {
        return LuceneFields.getUID(portletId, field1, null);
    }

    public static String getUID(String portletId, long field1, String field2) {
        return LuceneFields.getUID(portletId, String.valueOf(field1), field2);
    }

    public static String getUID(String portletId, Long field1, String field2) {
        return LuceneFields.getUID(portletId, (long)field1, field2);
    }

    public static String getUID(String portletId, String field1, String field2) {
        return LuceneFields.getUID(portletId, field1, field2, null);
    }

    public static String getUID(String portletId, String field1, String field2, String field3) {
        String uid = portletId + _UID_PORTLET + field1;
        if (field2 != null) {
            uid = uid + _UID_FIELD + field2;
        }
        if (field3 != null) {
            uid = uid + _UID_FIELD + field3;
        }
        return uid;
    }

    public static Field getDate(String field) {
        return LuceneFields.getDate(field, new Date());
    }

    public static Field getDate(String field, Date date) {
        if (date == null) {
            return LuceneFields.getDate(field);
        }
        return new Field(field, DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED);
    }

    public static Field getFile(String field, InputStream is, String fileExt) {
        LuceneFileExtractor fileExtractor = (LuceneFileExtractor)InstancePool.get((String)PropsValues.LUCENE_FILE_EXTRACTOR);
        return fileExtractor.getFile(field, is, fileExt);
    }

    public static Field getFile(String field, byte[] bytes, String fileExt) {
        LuceneFileExtractor fileExtractor = (LuceneFileExtractor)InstancePool.get((String)PropsValues.LUCENE_FILE_EXTRACTOR);
        return fileExtractor.getFile(field, bytes, fileExt);
    }

    public static Field getFile(String field, File file, String fileExt) throws IOException {
        LuceneFileExtractor fileExtractor = (LuceneFileExtractor)InstancePool.get((String)PropsValues.LUCENE_FILE_EXTRACTOR);
        return fileExtractor.getFile(field, file, fileExt);
    }

    public static Field getKeyword(String field, double keyword) {
        return LuceneFields.getKeyword(field, String.valueOf(keyword));
    }

    public static Field getKeyword(String field, long keyword) {
        return LuceneFields.getKeyword(field, String.valueOf(keyword));
    }

    public static Field getKeyword(String field, Long keyword) {
        return LuceneFields.getKeyword(field, (long)keyword);
    }

    public static Field getKeyword(String field, String keyword) {
        Field fieldObj = new Field(field, keyword, Field.Store.YES, Field.Index.NOT_ANALYZED);
        return fieldObj;
    }

    public static Field getText(String field, String text) {
        return new Field(field, text, Field.Store.YES, Field.Index.ANALYZED);
    }

    public static Field getText(String field, StringBuilder sb) {
        return LuceneFields.getText(field, sb.toString());
    }
}

