/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.search.lucene.LuceneFields;
import com.liferay.portal.search.lucene.LuceneHelper;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneHelperUtil {
    private static LuceneHelper _luceneHelper;

    public static void addDate(Document doc, String field, Date value) {
        doc.add((Fieldable)LuceneFields.getDate(field, value));
    }

    public static void addDocument(long companyId, Document document) throws IOException {
        LuceneHelperUtil.getLuceneHelper().addDocument(companyId, document);
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, boolean value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, double value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, int value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, long value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, short value) {
        LuceneHelperUtil.addExactTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        LuceneHelperUtil.getLuceneHelper().addExactTerm(booleanQuery, field, value);
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, boolean value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, double value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, int value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, long value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, short value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, String value) {
        LuceneHelperUtil.addRequiredTerm(booleanQuery, field, value, false);
    }

    public static void addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        LuceneHelperUtil.getLuceneHelper().addRequiredTerm(booleanQuery, field, value, like);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, long value) throws ParseException {
        LuceneHelperUtil.addTerm(booleanQuery, field, String.valueOf(value));
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String value) throws ParseException {
        LuceneHelperUtil.addTerm(booleanQuery, field, value, false);
    }

    public static void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) throws ParseException {
        LuceneHelperUtil.getLuceneHelper().addTerm(booleanQuery, field, value, like);
    }

    public static void delete(long companyId) {
        LuceneHelperUtil.getLuceneHelper().delete(companyId);
    }

    public static void deleteDocuments(long companyId, Term term) throws IOException {
        LuceneHelperUtil.getLuceneHelper().deleteDocuments(companyId, term);
    }

    public static Analyzer getAnalyzer() {
        return LuceneHelperUtil.getLuceneHelper().getAnalyzer();
    }

    public static LuceneHelper getLuceneHelper() {
        return _luceneHelper;
    }

    public static String[] getQueryTerms(Query query) {
        return LuceneHelperUtil.getLuceneHelper().getQueryTerms(query);
    }

    public static IndexSearcher getSearcher(long companyId, boolean readOnly) throws IOException {
        return LuceneHelperUtil.getLuceneHelper().getSearcher(companyId, readOnly);
    }

    public static String getSnippet(Query query, String field, String s) throws IOException {
        return LuceneHelperUtil.getSnippet(query, field, s, 3, 80, "...", "", "");
    }

    public static String getSnippet(Query query, String field, String s, int maxNumFragments, int fragmentLength, String fragmentSuffix, String preTag, String postTag) throws IOException {
        return LuceneHelperUtil.getLuceneHelper().getSnippet(query, field, s, maxNumFragments, fragmentLength, fragmentSuffix, preTag, postTag);
    }

    public static void updateDocument(long companyId, Term term, Document document) throws IOException {
        LuceneHelperUtil.getLuceneHelper().updateDocument(companyId, term, document);
    }

    public static void shutdown() {
        LuceneHelperUtil.getLuceneHelper().shutdown();
    }

    public void setLuceneHelper(LuceneHelper luceneHelper) {
        _luceneHelper = luceneHelper;
    }
}

