/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.QueryTranslator;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class LuceneIndexSearcherImpl
implements IndexSearcher {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexSearcherImpl.class);

    public Hits search(long companyId, Query query, com.liferay.portal.kernel.search.Sort[] sorts, int start, int end) throws SearchException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Query " + query));
        }
        Hits hits = null;
        org.apache.lucene.search.IndexSearcher searcher = null;
        Sort luceneSort = null;
        try {
            searcher = LuceneHelperUtil.getSearcher(companyId, true);
            if (sorts != null) {
                SortField[] sortFields = new SortField[sorts.length];
                for (int i = 0; i < sorts.length; ++i) {
                    com.liferay.portal.kernel.search.Sort sort = sorts[i];
                    sortFields[i] = new SortField(sort.getFieldName(), sort.getType(), sort.isReverse());
                }
                luceneSort = new Sort(sortFields);
            }
            long startTime = System.currentTimeMillis();
            org.apache.lucene.search.Hits luceneHits = searcher.search(QueryTranslator.translate(query), luceneSort);
            long endTime = System.currentTimeMillis();
            float searchTime = (float)(endTime - startTime) / 1000.0f;
            hits = this.subset(luceneHits, query, startTime, searchTime, start, end);
        }
        catch (BooleanQuery.TooManyClauses tmc) {
            int maxClauseCount = BooleanQuery.getMaxClauseCount();
            BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
            try {
                long startTime = System.currentTimeMillis();
                org.apache.lucene.search.Hits luceneHits = searcher.search(QueryTranslator.translate(query), luceneSort);
                long endTime = System.currentTimeMillis();
                float searchTime = (float)(endTime - startTime) / 1000.0f;
                hits = this.subset(luceneHits, query, startTime, searchTime, start, end);
            }
            catch (Exception e) {
                throw new SearchException((Throwable)e);
            }
            finally {
                BooleanQuery.setMaxClauseCount((int)maxClauseCount);
            }
        }
        catch (ParseException pe) {
            _log.error((Object)("Query: " + query), (Throwable)pe);
            HitsImpl hitsImpl = new HitsImpl();
            return hitsImpl;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        finally {
            try {
                if (searcher != null) {
                    searcher.close();
                }
            }
            catch (IOException ioe) {
                throw new SearchException((Throwable)ioe);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search found " + hits.getLength() + " results in " + hits.getSearchTime() + "ms"));
        }
        return hits;
    }

    protected DocumentImpl getDocument(org.apache.lucene.document.Document oldDoc) {
        DocumentImpl newDoc = new DocumentImpl();
        List oldFields = oldDoc.getFields();
        for (org.apache.lucene.document.Field oldField : oldFields) {
            Field newField;
            String[] values = oldDoc.getValues(oldField.name());
            if (values != null && values.length > 1) {
                newField = new Field(oldField.name(), values, oldField.isTokenized());
                newDoc.add(newField);
                continue;
            }
            newField = new Field(oldField.name(), oldField.stringValue(), oldField.isTokenized());
            newDoc.add(newField);
        }
        return newDoc;
    }

    protected String[] getQueryTerms(Query query) {
        String[] queryTerms = new String[]{};
        try {
            queryTerms = LuceneHelperUtil.getQueryTerms(QueryTranslator.translate(query));
        }
        catch (ParseException pe) {
            _log.error((Object)("Query: " + query), (Throwable)pe);
        }
        return queryTerms;
    }

    protected String getSnippet(org.apache.lucene.document.Document doc, Query query, String field) throws IOException {
        Object[] values = doc.getValues(field);
        String snippet = null;
        if (Validator.isNull((Object[])values)) {
            return snippet;
        }
        String s = StringUtil.merge((Object[])values);
        try {
            snippet = LuceneHelperUtil.getSnippet(QueryTranslator.translate(query), field, s);
        }
        catch (ParseException pe) {
            _log.error((Object)("Query: " + query), (Throwable)pe);
        }
        return snippet;
    }

    protected Hits subset(org.apache.lucene.search.Hits luceneHits, Query query, long startTime, float searchTime, int start, int end) throws IOException {
        int length = luceneHits.length();
        if (start == -1 && end == -1) {
            start = 0;
            end = length;
        }
        String[] queryTerms = this.getQueryTerms(query);
        HitsImpl subset = new HitsImpl();
        if (start > -1 && start <= end) {
            if (end > length) {
                end = length;
            }
            int subsetTotal = end - start;
            DocumentImpl[] subsetDocs = new DocumentImpl[subsetTotal];
            String[] subsetSnippets = new String[subsetTotal];
            float[] subsetScores = new float[subsetTotal];
            int j = 0;
            int i = start;
            while (i < end) {
                org.apache.lucene.document.Document doc = luceneHits.doc(i);
                subsetDocs[j] = this.getDocument(doc);
                subsetSnippets[j] = this.getSnippet(doc, query, "content");
                subsetScores[j] = luceneHits.score(i);
                ++i;
                ++j;
            }
            subset.setStart(startTime);
            subset.setSearchTime(searchTime);
            subset.setQueryTerms(queryTerms);
            subset.setDocs((Document[])subsetDocs);
            subset.setLength(length);
            subset.setSnippets(subsetSnippets);
            subset.setScores(subsetScores);
        }
        return subset;
    }
}

