/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneFields;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;

public class LuceneIndexWriterImpl
implements IndexWriter {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexWriterImpl.class);

    public void addDocument(long companyId, Document document) throws SearchException {
        try {
            LuceneHelperUtil.addDocument(companyId, this._getLuceneDocument(document));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added document " + document.get("uid")));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void deleteDocument(long companyId, String uid) throws SearchException {
        try {
            LuceneHelperUtil.deleteDocuments(companyId, new Term("uid", uid));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Deleted document " + uid));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void deletePortletDocuments(long companyId, String portletId) throws SearchException {
        try {
            LuceneHelperUtil.deleteDocuments(companyId, new Term("portletId", portletId));
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    public void updateDocument(long companyId, String uid, Document document) throws SearchException {
        try {
            LuceneHelperUtil.updateDocument(companyId, new Term("uid", uid), this._getLuceneDocument(document));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Updated document " + document.get("uid")));
            }
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
    }

    private org.apache.lucene.document.Document _getLuceneDocument(Document document) {
        org.apache.lucene.document.Document luceneDocument = new org.apache.lucene.document.Document();
        Collection fields = document.getFields().values();
        for (Field field : fields) {
            String name = field.getName();
            boolean tokenized = field.isTokenized();
            float boost = field.getBoost();
            for (String value : field.getValues()) {
                if (Validator.isNull((String)value)) continue;
                org.apache.lucene.document.Field luceneField = null;
                luceneField = tokenized ? LuceneFields.getText(name, value) : LuceneFields.getKeyword(name, value);
                luceneField.setBoost(boost);
                luceneDocument.add((Fieldable)luceneField);
            }
        }
        return luceneDocument;
    }
}

