/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.messaging;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.messaging.BaseDestinationEventListener;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.BooleanQueryFactory;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.TermQueryFactory;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchReaderMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchWriterMessageListener;
import com.liferay.portal.search.lucene.BooleanQueryFactoryImpl;
import com.liferay.portal.search.lucene.TermQueryFactoryImpl;

public class SearchEngineDestinationEventListener
extends BaseDestinationEventListener {
    private SearchReaderMessageListener _searchReaderMessageListener;
    private SearchWriterMessageListener _searchWriterMessageListener;

    public SearchEngineDestinationEventListener() {
    }

    public SearchEngineDestinationEventListener(SearchReaderMessageListener searchReaderMessageListener, SearchWriterMessageListener searchWriterMessageListener) {
        this._searchReaderMessageListener = searchReaderMessageListener;
        this._searchWriterMessageListener = searchWriterMessageListener;
    }

    public void messageListenerRegistered(String destinationName, MessageListener messageListener) {
        if (!this.isProceed(destinationName, messageListener)) {
            return;
        }
        MessageBusUtil.unregisterMessageListener((String)"liferay/search_reader", (MessageListener)this._searchReaderMessageListener);
        MessageBusUtil.unregisterMessageListener((String)"liferay/search_writer", (MessageListener)this._searchWriterMessageListener);
        BaseSearchEngineMessageListener baseSearchEngineMessageListener = (BaseSearchEngineMessageListener)messageListener;
        if (!baseSearchEngineMessageListener.getSearchEngineName().contains("LUCENE")) {
            this.setBooleanQueryFactory(new com.liferay.portal.search.generic.BooleanQueryFactoryImpl());
            this.setTermQueryFactory(new com.liferay.portal.search.generic.TermQueryFactoryImpl());
        }
    }

    public void messageListenerUnregistered(String destinationName, MessageListener messageListener) {
        if (!this.isProceed(destinationName, messageListener)) {
            return;
        }
        MessageBusUtil.registerMessageListener((String)"liferay/search_reader", (MessageListener)this._searchReaderMessageListener);
        MessageBusUtil.registerMessageListener((String)"liferay/search_writer", (MessageListener)this._searchWriterMessageListener);
        BaseSearchEngineMessageListener baseSearchEngineMessageListener = (BaseSearchEngineMessageListener)messageListener;
        if (!baseSearchEngineMessageListener.getSearchEngineName().contains("LUCENE")) {
            this.setBooleanQueryFactory(new BooleanQueryFactoryImpl());
            this.setTermQueryFactory(new TermQueryFactoryImpl());
        }
    }

    public void setSearchReaderMessageListener(SearchReaderMessageListener searchReaderMessageListener) {
        this._searchReaderMessageListener = searchReaderMessageListener;
    }

    public void setSearchWriterMessageListener(SearchWriterMessageListener searchWriterMessageListener) {
        this._searchWriterMessageListener = searchWriterMessageListener;
    }

    protected boolean isProceed(String destinationName, MessageListener messageListener) {
        return destinationName.equals("liferay/search_reader") && messageListener != this._searchReaderMessageListener && messageListener instanceof SearchReaderMessageListener;
    }

    protected void setBooleanQueryFactory(BooleanQueryFactory booleanQueryFactory) {
        BooleanQueryFactoryUtil booleanQueryFactoryUtil = (BooleanQueryFactoryUtil)PortalBeanLocatorUtil.locate((String)BooleanQueryFactoryUtil.class.getName());
        booleanQueryFactoryUtil.setBooleanQueryFactory(booleanQueryFactory);
    }

    protected void setTermQueryFactory(TermQueryFactory termQueryFactory) {
        TermQueryFactoryUtil termQueryFactoryUtil = (TermQueryFactoryUtil)PortalBeanLocatorUtil.locate((String)TermQueryFactoryUtil.class.getName());
        termQueryFactoryUtil.setTermQueryFactory(termQueryFactory);
    }
}

