/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthFailure;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthPipeline {
    private static AuthPipeline _instance = new AuthPipeline();
    private Map<String, Authenticator[]> _authenticators = new HashMap<String, Authenticator[]>();
    private Map<String, AuthFailure[]> _authFailures = new HashMap<String, AuthFailure[]>();

    public static int authenticateByEmailAddress(String key, long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    public static int authenticateByScreenName(String key, long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    public static int authenticateByUserId(String key, long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    public static void onFailureByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, emailAddress, "emailAddress", headerMap, parameterMap);
    }

    public static void onFailureByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, screenName, "screenName", headerMap, parameterMap);
    }

    public static void onFailureByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, String.valueOf(userId), "userId", headerMap, parameterMap);
    }

    public static void onMaxFailuresByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByEmailAddress(key, companyId, emailAddress, headerMap, parameterMap);
    }

    public static void onMaxFailuresByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByScreenName(key, companyId, screenName, headerMap, parameterMap);
    }

    public static void onMaxFailuresByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByUserId(key, companyId, userId, headerMap, parameterMap);
    }

    public static void registerAuthenticator(String key, Authenticator authenticator) {
        _instance._registerAuthenticator(key, authenticator);
    }

    public static void registerAuthFailure(String key, AuthFailure authFailure) {
        _instance._registerAuthFailure(key, authFailure);
    }

    public static void unregisterAuthenticator(String key, Authenticator authenticator) {
        _instance._unregisterAuthenticator(key, authenticator);
    }

    public static void unregisterAuthFailure(String key, AuthFailure authFailure) {
        _instance._unregisterAuthFailure(key, authFailure);
    }

    private AuthPipeline() {
        AuthFailure authFailure;
        Authenticator authenticator;
        ArrayList<Authenticator> authenticators = new ArrayList<Authenticator>();
        for (String authenticatorClassName : PropsValues.AUTH_PIPELINE_PRE) {
            authenticator = (Authenticator)InstancePool.get((String)authenticatorClassName);
            authenticators.add(authenticator);
        }
        this._authenticators.put("auth.pipeline.pre", authenticators.toArray(new Authenticator[authenticators.size()]));
        authenticators.clear();
        for (String authenticatorClassName : PropsValues.AUTH_PIPELINE_POST) {
            authenticator = (Authenticator)InstancePool.get((String)authenticatorClassName);
            authenticators.add(authenticator);
        }
        this._authenticators.put("auth.pipeline.post", authenticators.toArray(new Authenticator[authenticators.size()]));
        ArrayList<AuthFailure> authFailures = new ArrayList<AuthFailure>();
        for (String authFailureClassName : PropsValues.AUTH_FAILURE) {
            authFailure = (AuthFailure)InstancePool.get((String)authFailureClassName);
            authFailures.add(authFailure);
        }
        this._authFailures.put("auth.failure", authFailures.toArray(new AuthFailure[authFailures.size()]));
        authFailures.clear();
        for (String authFailureClassName : PropsValues.AUTH_MAX_FAILURES) {
            authFailure = (AuthFailure)InstancePool.get((String)authFailureClassName);
            authFailures.add(authFailure);
        }
        this._authFailures.put("auth.max.failures", authFailures.toArray(new AuthFailure[authFailures.size()]));
    }

    private int _authenticate(String key, long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        Authenticator[] authenticators = this._authenticators.get(key);
        if (authenticators == null || authenticators.length == 0) {
            return 1;
        }
        for (Authenticator authenticator : authenticators) {
            try {
                int authResult = -1;
                if (authType.equals("emailAddress")) {
                    authResult = authenticator.authenticateByEmailAddress(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    authResult = authenticator.authenticateByScreenName(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    long userId = GetterUtil.getLong((String)login);
                    authResult = authenticator.authenticateByUserId(companyId, userId, password, headerMap, parameterMap);
                }
                if (authResult == 1) continue;
                return authResult;
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
        return 1;
    }

    private void _onFailure(String key, long companyId, String login, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthFailure[] authFailures = this._authFailures.get(key);
        if (authFailures == null || authFailures.length == 0) {
            return;
        }
        for (AuthFailure authFailure : authFailures) {
            try {
                if (authType.equals("emailAddress")) {
                    authFailure.onFailureByEmailAddress(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (authType.equals("screenName")) {
                    authFailure.onFailureByScreenName(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (!authType.equals("userId")) continue;
                long userId = GetterUtil.getLong((String)login);
                authFailure.onFailureByUserId(companyId, userId, headerMap, parameterMap);
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
    }

    private void _registerAuthenticator(String key, Authenticator authenticator) {
        List authenticators = ListUtil.fromArray((Object[])this._authenticators.get(key));
        authenticators.add(authenticator);
        this._authenticators.put(key, authenticators.toArray(new Authenticator[authenticators.size()]));
    }

    private void _registerAuthFailure(String key, AuthFailure authFailure) {
        List authFailures = ListUtil.fromArray((Object[])this._authFailures.get(key));
        authFailures.add(authFailure);
        this._authFailures.put(key, authFailures.toArray(new AuthFailure[authFailures.size()]));
    }

    private void _unregisterAuthenticator(String key, Authenticator authenticator) {
        List authenticators = ListUtil.fromArray((Object[])this._authenticators.get(key));
        if (authenticators.remove(authenticator)) {
            this._authenticators.put(key, authenticators.toArray(new Authenticator[authenticators.size()]));
        }
    }

    private void _unregisterAuthFailure(String key, AuthFailure authFailure) {
        List authFailures = ListUtil.fromArray((Object[])this._authFailures.get(key));
        if (authFailures.remove(authFailure)) {
            this._authFailures.put(key, authFailures.toArray(new AuthFailure[authFailures.size()]));
        }
    }
}

