/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.sso.cas.CASFilter;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CASAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(CASAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            String redirect;
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
                return credentials;
            }
            HttpSession session = request.getSession();
            String screenName = (String)session.getAttribute(CASFilter.SCREEN_NAME);
            if (Validator.isNull((String)screenName)) {
                return credentials;
            }
            User user = null;
            if (PrefsPropsUtil.getBoolean(companyId, "cas.import.from.ldap", PropsValues.CAS_IMPORT_FROM_LDAP)) {
                try {
                    user = this.importLDAPUser(companyId, screenName);
                }
                catch (SystemException se) {
                    // empty catch block
                }
            }
            if (user == null) {
                user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
            }
            if (Validator.isNotNull((String)(redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect")))) {
                request.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return credentials;
        }
    }

    protected User addUser(long companyId, String screenName) throws Exception {
        return this.importLDAPUser(companyId, screenName);
    }

    protected User importLDAPUser(long companyId, String screenName) throws Exception {
        Context ctx = null;
        try {
            SearchControls cons;
            NamingEnumeration<SearchResult> enu;
            long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, screenName);
            String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
            if (ctx == null) {
                throw new SystemException("Failed to bind to the LDAP server");
            }
            String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter before transformation " + filter));
            }
            filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@"}, (String[])new String[]{String.valueOf(companyId), "", screenName});
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter after transformation " + filter));
            }
            if ((enu = ctx.search(baseDN, filter, cons = new SearchControls(2, 1L, 0, null, false, false))).hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enu.nextElement();
                Attributes attrs = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, (LdapContext)ctx, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                User user = PortalLDAPUtil.importLDAPUser(ldapServerId, companyId, (LdapContext)ctx, attrs, "", true);
                return user;
            }
            try {
                throw new NoSuchUserException("User " + screenName + " was not found in the LDAP server");
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Problem accessing LDAP server " + e.getMessage()));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
                throw new SystemException("Problem accessing LDAP server " + e.getMessage());
            }
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }
}

