/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.util.PortalUtil;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NtlmAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(NtlmAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PortalLDAPUtil.isNtlmEnabled(companyId)) {
                return credentials;
            }
            String screenName = (String)request.getAttribute("NTLM_REMOTE_USER");
            if (screenName == null) {
                return credentials;
            }
            request.removeAttribute("NTLM_REMOTE_USER");
            User user = this.getUser(companyId, screenName);
            if (user != null) {
                String redirect = ParamUtil.getString((HttpServletRequest)request, (String)"redirect");
                if (Validator.isNotNull((String)redirect)) {
                    request.setAttribute("AUTO_LOGIN_REDIRECT_AND_CONTINUE", (Object)redirect);
                }
                credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return credentials;
    }

    protected User getUser(long companyId, String screenName) throws Exception {
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, screenName);
        SearchResult result = (SearchResult)PortalLDAPUtil.getUser(ldapServerId, companyId, screenName);
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        LdapContext ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
        User user = PortalLDAPUtil.importLDAPUser(ldapServerId, companyId, ctx, result.getAttributes(), "", false);
        ctx.close();
        return user;
    }
}

