/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.auth.AutoLogin;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.CookieKeys;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RememberMeAutoLogin
implements AutoLogin {
    private static Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {
        try {
            String[] credentials = null;
            String autoUserId = CookieKeys.getCookie(request, "ID");
            String autoPassword = CookieKeys.getCookie(request, "PASSWORD");
            String rememberMe = CookieKeys.getCookie(request, "REMEMBER_ME");
            if (!PortalUtil.getPathContext().equals(request.getContextPath())) {
                rememberMe = Boolean.TRUE.toString();
            }
            if (Validator.isNotNull((String)autoUserId) && Validator.isNotNull((String)autoPassword) && Validator.isNotNull((String)rememberMe)) {
                Company company = PortalUtil.getCompany((HttpServletRequest)request);
                KeyValuePair kvp = null;
                if (company.isAutoLogin()) {
                    kvp = UserLocalServiceUtil.decryptUserId((long)company.getCompanyId(), (String)autoUserId, (String)autoPassword);
                    credentials = new String[]{kvp.getKey(), kvp.getValue(), Boolean.FALSE.toString()};
                }
            }
            return credentials;
        }
        catch (Exception e) {
            _log.warn((Object)e, (Throwable)e);
            Cookie cookie = new Cookie("ID", "");
            cookie.setMaxAge(0);
            cookie.setPath("/");
            CookieKeys.addCookie(request, response, cookie);
            cookie = new Cookie("PASSWORD", "");
            cookie.setMaxAge(0);
            cookie.setPath("/");
            CookieKeys.addCookie(request, response, cookie);
            throw new AutoLoginException((Throwable)e);
        }
    }
}

