/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CASAutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteMinderAutoLogin
extends CASAutoLogin {
    private static Log _log = LogFactoryUtil.getLog(SiteMinderAutoLogin.class);

    public String[] login(HttpServletRequest request, HttpServletResponse response) {
        String[] credentials = null;
        try {
            long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
            if (!PortalLDAPUtil.isSiteMinderEnabled(companyId)) {
                return credentials;
            }
            String screenName = request.getHeader(PrefsPropsUtil.getString(companyId, "siteminder.user.header", PropsValues.SITEMINDER_USER_HEADER));
            if (Validator.isNull((String)screenName)) {
                return credentials;
            }
            User user = null;
            if (PrefsPropsUtil.getBoolean(companyId, "siteminder.import.from.ldap", PropsValues.SITEMINDER_IMPORT_FROM_LDAP)) {
                try {
                    user = this.importLDAPUser(companyId, screenName);
                }
                catch (SystemException se) {
                    // empty catch block
                }
            }
            if (user == null) {
                user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
            }
            credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
            return credentials;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return credentials;
        }
    }
}

