/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.jaas.ext;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.jaas.PortalPrincipal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicLoginModule
implements LoginModule {
    private static Log _log = LogFactoryUtil.getLog(BasicLoginModule.class);
    private Subject _subject;
    private CallbackHandler _callbackHandler;
    private Principal _principal;
    private String _password;

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean commit() {
        if (this.getPrincipal() != null) {
            this.getSubject().getPrincipals().add(this.getPrincipal());
            return true;
        }
        return false;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._subject = subject;
        this._callbackHandler = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        String[] credentials = null;
        try {
            credentials = this.authenticate();
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
            throw new LoginException();
        }
        if (credentials != null && credentials.length == 2) {
            this.setPrincipal(this.getPortalPrincipal(credentials[0]));
            this.setPassword(credentials[1]);
            return true;
        }
        throw new LoginException();
    }

    @Override
    public boolean logout() {
        this.getSubject().getPrincipals().clear();
        return true;
    }

    protected Subject getSubject() {
        return this._subject;
    }

    protected Principal getPrincipal() {
        return this._principal;
    }

    protected void setPrincipal(Principal principal) {
        this._principal = principal;
    }

    protected Principal getPortalPrincipal(String name) {
        return new PortalPrincipal(name);
    }

    protected String getPassword() {
        return this._password;
    }

    protected void setPassword(String password) {
        this._password = password;
    }

    protected String[] authenticate() throws IOException, UnsupportedCallbackException {
        NameCallback nameCallback = new NameCallback("name: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        this._callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        String name = nameCallback.getName();
        String password = null;
        char[] passwordChar = passwordCallback.getPassword();
        if (passwordChar != null) {
            password = new String(passwordChar);
        }
        if (name == null) {
            return new String[]{"", ""};
        }
        try {
            long userId = GetterUtil.getLong((String)name);
            if (UserLocalServiceUtil.authenticateForJAAS((long)userId, (String)password)) {
                return new String[]{name, password};
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return null;
    }
}

