/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.jaas.ext.jonas;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodCache;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.security.jaas.ext.BasicLoginModule;
import java.lang.reflect.Method;
import java.security.Principal;

public class PortalLoginModule
extends BasicLoginModule {
    private static final String _JGROUP = "org.objectweb.jonas.security.auth.JGroup";
    private static final String _JPRINCIPAL = "org.objectweb.jonas.security.auth.JPrincipal";
    private static final String _JROLE = "org.objectweb.jonas.security.auth.JRole";
    private static Log _log = LogFactoryUtil.getLog(PortalLoginModule.class);

    public boolean commit() {
        boolean commitValue = super.commit();
        if (commitValue) {
            this.getSubject().getPrincipals().add(this.getPrincipal());
            this.getSubject().getPrivateCredentials().add(this.getPassword());
            Principal group = (Principal)ReflectionUtil.newInstance((String)_JGROUP, (String)"Roles");
            Object role = ReflectionUtil.newInstance((String)_JROLE, (String)"users");
            try {
                Method method = MethodCache.get((String)_JGROUP, (String)"addMember", (Class[])new Class[]{role.getClass()});
                method.invoke((Object)group, role);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            this.getSubject().getPrincipals().add(group);
        }
        return commitValue;
    }

    protected Principal getPortalPrincipal(String name) {
        return (Principal)ReflectionUtil.newInstance((String)_JPRINCIPAL, (String)name);
    }
}

