/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.util.ldap.DummyDirContext;
import java.util.Properties;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

public class LDAPUser
extends DummyDirContext {
    private User _user;
    private Attributes _attributes;

    public User getUser() {
        return this._user;
    }

    public void setUser(User user, long ldapServerId) throws Exception {
        String jobTitleMapping;
        String fullNameMapping;
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        this._user = user;
        Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, this._user.getCompanyId());
        this._attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectclass");
        String[] defaultObjectClasses = PrefsPropsUtil.getStringArray(this._user.getCompanyId(), "ldap.user.default.object.classes" + postfix, ",");
        for (int i = 0; i < defaultObjectClasses.length; ++i) {
            objectClass.add(defaultObjectClasses[i]);
        }
        this._attributes.put(objectClass);
        this._attributes.put(userMappings.getProperty("firstName"), this._user.getFirstName());
        this._attributes.put(userMappings.getProperty("lastName"), this._user.getLastName());
        if (Validator.isNotNull((String)this._user.getPasswordUnencrypted())) {
            this._attributes.put(userMappings.getProperty("password"), this._user.getPasswordUnencrypted());
        }
        if (Validator.isNotNull((String)this._user.getEmailAddress())) {
            this._attributes.put(userMappings.getProperty("emailAddress"), this._user.getEmailAddress());
        }
        if (Validator.isNotNull((String)(fullNameMapping = userMappings.getProperty("fullName")))) {
            this._attributes.put(fullNameMapping, this._user.getFullName());
        }
        if (Validator.isNotNull((String)(jobTitleMapping = userMappings.getProperty("jobTitle"))) && Validator.isNotNull((String)this._user.getJobTitle())) {
            this._attributes.put(jobTitleMapping, this._user.getJobTitle());
        }
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (Validator.isNotNull((String)name)) {
            throw new NameNotFoundException();
        }
        return (Attributes)this._attributes.clone();
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(String name, String[] ids) throws NamingException {
        if (Validator.isNotNull((String)name)) {
            throw new NameNotFoundException();
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (int i = 0; i < ids.length; ++i) {
            Attribute attr = this._attributes.get(ids[i]);
            if (attr == null) continue;
            attributes.put(attr);
        }
        return attributes;
    }

    public Attributes getAttributes(Name name, String[] ids) throws NamingException {
        return this.getAttributes(name.toString(), ids);
    }
}

