/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ldap.LDAPUtil;
import com.liferay.util.ldap.Modifications;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalLDAPUtil {
    public static final String IMPORT_BY_GROUP = "group";
    public static final String IMPORT_BY_USER = "user";
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPUtil.class);

    public static void exportToLDAP(Contact contact) throws Exception {
        long companyId = contact.getCompanyId();
        if (!PortalLDAPUtil.isAuthEnabled(companyId) || !PortalLDAPUtil.isExportEnabled(companyId)) {
            return;
        }
        User user = UserLocalServiceUtil.getUserByContactId((long)contact.getContactId());
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, user.getScreenName());
        LdapContext ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
        try {
            if (ctx == null) {
                return;
            }
            Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, companyId);
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, contact.getCompanyId(), user.getScreenName());
            CompositeName name = new CompositeName();
            if (binding == null) {
                PortalLDAPUtil._getDNName(ldapServerId, companyId, user, userMappings, name);
                LDAPUser ldapUser = (LDAPUser)((Object)Class.forName(PropsValues.LDAP_USER_IMPL).newInstance());
                ldapUser.setUser(user, ldapServerId);
                ctx.bind(name, (Object)ldapUser);
            } else {
                String jobTitleMapping;
                name.add(PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                Modifications mods = Modifications.getInstance();
                mods.addItem(userMappings.getProperty("firstName"), contact.getFirstName());
                mods.addItem(userMappings.getProperty("lastName"), contact.getLastName());
                String fullNameMapping = userMappings.getProperty("fullName");
                if (Validator.isNotNull((String)fullNameMapping)) {
                    mods.addItem(fullNameMapping, contact.getFullName());
                }
                if (Validator.isNotNull((String)(jobTitleMapping = userMappings.getProperty("jobTitle")))) {
                    mods.addItem(jobTitleMapping, contact.getJobTitle());
                }
                ModificationItem[] modItems = mods.getItems();
                ctx.modifyAttributes(name, modItems);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToLDAP(User user) throws Exception {
        long companyId = user.getCompanyId();
        if (!PortalLDAPUtil.isAuthEnabled(companyId) || !PortalLDAPUtil.isExportEnabled(companyId)) {
            return;
        }
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, user.getScreenName());
        LdapContext ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
        try {
            String jobTitleMapping;
            if (ctx == null) {
                return;
            }
            Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, companyId);
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, user.getCompanyId(), user.getScreenName());
            CompositeName name = new CompositeName();
            if (binding == null) {
                PortalLDAPUtil._getDNName(ldapServerId, companyId, user, userMappings, name);
                LDAPUser ldapUser = (LDAPUser)((Object)Class.forName(PropsValues.LDAP_USER_IMPL).newInstance());
                ldapUser.setUser(user, ldapServerId);
                ctx.bind(name, (Object)ldapUser);
                binding = PortalLDAPUtil.getUser(ldapServerId, user.getCompanyId(), user.getScreenName());
                name = new CompositeName();
            }
            name.add(PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
            Modifications mods = Modifications.getInstance();
            mods.addItem(userMappings.getProperty("firstName"), user.getFirstName());
            mods.addItem(userMappings.getProperty("lastName"), user.getLastName());
            String fullNameMapping = userMappings.getProperty("fullName");
            if (Validator.isNotNull((String)fullNameMapping)) {
                mods.addItem(fullNameMapping, user.getFullName());
            }
            if (user.isPasswordModified() && Validator.isNotNull((String)user.getPasswordUnencrypted())) {
                mods.addItem(userMappings.getProperty("password"), user.getPasswordUnencrypted());
            }
            if (Validator.isNotNull((String)user.getEmailAddress())) {
                mods.addItem(userMappings.getProperty("emailAddress"), user.getEmailAddress());
            }
            if (Validator.isNotNull((String)(jobTitleMapping = userMappings.getProperty("jobTitle")))) {
                mods.addItem(jobTitleMapping, user.getJobTitle());
            }
            ModificationItem[] modItems = mods.getItems();
            ctx.modifyAttributes(name, modItems);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    public static String getAuthSearchFilter(long ldapServerId, long companyId, String emailAddress, String screenName, String userId) throws SystemException {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter before transformation " + filter));
        }
        filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@", "@user_id@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName, userId});
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter after transformation " + filter));
        }
        return filter;
    }

    public static LdapContext getContext(long ldapServerId, long companyId) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        String baseProviderURL = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + postfix);
        String pricipal = PrefsPropsUtil.getString(companyId, "ldap.security.principal" + postfix);
        String credentials = PrefsPropsUtil.getString(companyId, "ldap.security.credentials" + postfix);
        return PortalLDAPUtil.getContext(companyId, baseProviderURL, pricipal, credentials);
    }

    public static LdapContext getContext(long companyId, String providerURL, String pricipal, String credentials) throws Exception {
        InitialLdapContext ctx;
        block3: {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", PrefsPropsUtil.getString(companyId, "ldap.factory.initial"));
            env.put("java.naming.provider.url", providerURL);
            env.put("java.naming.security.principal", pricipal);
            env.put("java.naming.security.credentials", credentials);
            env.put("java.naming.referral", PrefsPropsUtil.getString(companyId, "ldap.referral"));
            env.put("com.sun.jndi.ldap.connect.pool", "true");
            env.put("com.sun.jndi.ldap.connect.pool.maxsize", "50");
            env.put("com.sun.jndi.ldap.connect.pool.timeout", "10000");
            LogUtil.debug((Log)_log, (Properties)env);
            ctx = null;
            try {
                ctx = new InitialLdapContext(env, null);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Failed to bind to the LDAP server");
                }
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)e);
            }
        }
        return ctx;
    }

    public static Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ctx, String fullDistinguishedName) throws Exception {
        return PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ctx, fullDistinguishedName, false);
    }

    public static Attributes getGroupAttributes(long ldapServerId, long companyId, LdapContext ctx, String fullDistinguishedName, boolean includeReferenceAttributes) throws Exception {
        Properties groupMappings = PortalLDAPUtil.getGroupMappings(ldapServerId, companyId);
        ArrayList<String> mappedGroupAttributeIds = new ArrayList<String>();
        mappedGroupAttributeIds.add(groupMappings.getProperty("groupName"));
        mappedGroupAttributeIds.add(groupMappings.getProperty("description"));
        if (includeReferenceAttributes) {
            mappedGroupAttributeIds.add(groupMappings.getProperty(IMPORT_BY_USER));
        }
        return PortalLDAPUtil._getAttributes(ctx, fullDistinguishedName, mappedGroupAttributeIds.toArray(new String[0]));
    }

    public static Properties getGroupMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        Properties groupMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.group.mappings" + postfix));
        LogUtil.debug((Log)_log, (Properties)groupMappings);
        return groupMappings;
    }

    public static List<SearchResult> getGroups(long companyId, LdapContext ctx, int maxResults, String baseDN, String groupFilter) throws Exception {
        return PortalLDAPUtil._searchLDAP(companyId, ctx, maxResults, baseDN, groupFilter, null);
    }

    public static List<SearchResult> getGroups(long ldapServerId, long companyId, LdapContext ctx, int maxResults) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String groupFilter = PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix);
        return PortalLDAPUtil.getGroups(companyId, ctx, maxResults, baseDN, groupFilter);
    }

    public static long getLdapServerId(long companyId, String screenName) throws Exception {
        long[] ldapServerIds;
        for (long ldapServerId : ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L)) {
            if (!PortalLDAPUtil.hasUser(ldapServerId, companyId, screenName)) continue;
            return ldapServerId;
        }
        if (ldapServerIds.length > 0) {
            return ldapServerIds[0];
        }
        return 0L;
    }

    public static Attribute getMultivaluedAttribute(long companyId, LdapContext ctx, String baseDN, String filter, Attribute attribute) throws Exception {
        NamingEnumeration<? extends Attribute> enu;
        SearchResult result;
        Attributes attributes;
        List<SearchResult> results;
        if (attribute.size() > 0) {
            return attribute;
        }
        String[] attributeIds = new String[]{PortalLDAPUtil._getNextRange(attribute.getID())};
        while ((results = PortalLDAPUtil._searchLDAP(companyId, ctx, 0, baseDN, filter, attributeIds)).size() == 1 && (attributes = (result = results.get(0)).getAttributes()).size() == 1 && (enu = attributes.getAll()).hasMoreElements()) {
            Attribute curAttribute = (Attribute)enu.nextElement();
            for (int i = 0; i < curAttribute.size(); ++i) {
                attribute.add(curAttribute.get(i));
            }
            if (StringUtil.endsWith((String)curAttribute.getID(), (String)"*") || curAttribute.size() < PropsValues.LDAP_RANGE_SIZE) break;
            attributeIds[0] = PortalLDAPUtil._getNextRange(attributeIds[0]);
        }
        return attribute;
    }

    public static String getNameInNamespace(long ldapServerId, long companyId, Binding binding) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String name = binding.getName();
        if (name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        if (Validator.isNull((String)baseDN)) {
            return name.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(",");
        sb.append(baseDN);
        return sb.toString();
    }

    public static String getPropertyPostfix(long ldapServerId) {
        if (ldapServerId > 0L) {
            return "." + ldapServerId;
        }
        return "";
    }

    public static Binding getUser(long ldapServerId, long companyId, String screenName) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        LdapContext ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
        NamingEnumeration<SearchResult> enu = null;
        try {
            if (ctx == null) {
                Binding binding = null;
                return binding;
            }
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, companyId);
            StringBuilder filter = new StringBuilder();
            filter.append("(");
            filter.append(userMappings.getProperty("screenName"));
            filter.append("=");
            filter.append(screenName);
            filter.append(")");
            SearchControls cons = new SearchControls(2, 1L, 0, null, false, false);
            enu = ctx.search(baseDN, filter.toString(), cons);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        if (enu.hasMoreElements()) {
            Binding binding = (Binding)enu.nextElement();
            enu.close();
            return binding;
        }
        return null;
    }

    public static Attributes getUserAttributes(long ldapServerId, long companyId, LdapContext ctx, String fullDistinguishedName) throws Exception {
        Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, companyId);
        String[] mappedUserAttributeIds = new String[]{userMappings.getProperty("screenName"), userMappings.getProperty("emailAddress"), userMappings.getProperty("fullName"), userMappings.getProperty("firstName"), userMappings.getProperty("middleName"), userMappings.getProperty("lastName"), userMappings.getProperty("jobTitle"), userMappings.getProperty(IMPORT_BY_GROUP)};
        return PortalLDAPUtil._getAttributes(ctx, fullDistinguishedName, mappedUserAttributeIds);
    }

    public static Properties getUserMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        Properties userMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.user.mappings" + postfix));
        LogUtil.debug((Log)_log, (Properties)userMappings);
        return userMappings;
    }

    public static List<SearchResult> getUsers(long companyId, LdapContext ctx, int maxResults, String baseDN, String userFilter) throws Exception {
        return PortalLDAPUtil._searchLDAP(companyId, ctx, maxResults, baseDN, userFilter, null);
    }

    public static List<SearchResult> getUsers(long ldapServerId, long companyId, LdapContext ctx, int maxResults) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        String userFilter = PrefsPropsUtil.getString(companyId, "ldap.import.user.search.filter" + postfix);
        return PortalLDAPUtil.getUsers(companyId, ctx, maxResults, baseDN, userFilter);
    }

    public static String getUsersDN(long ldapServerId, long companyId) throws Exception {
        String postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
        return PrefsPropsUtil.getString(companyId, "ldap.users.dn" + postfix);
    }

    public static boolean hasUser(long ldapServerId, long companyId, String screenName) throws Exception {
        return PortalLDAPUtil.getUser(ldapServerId, companyId, screenName) != null;
    }

    public static void importFromLDAP() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
        for (Company company : companies) {
            PortalLDAPUtil.importFromLDAP(company.getCompanyId());
        }
    }

    public static void importFromLDAP(long companyId) throws Exception {
        long[] ldapServerIds;
        if (!PortalLDAPUtil.isImportEnabled(companyId)) {
            return;
        }
        for (long ldapServerId : ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L)) {
            PortalLDAPUtil.importFromLDAP(ldapServerId, companyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromLDAP(long ldapServerId, long companyId) throws Exception {
        if (!PortalLDAPUtil.isImportEnabled(companyId)) {
            return;
        }
        LdapContext ctx = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ctx == null) {
            return;
        }
        try {
            String importMethod = PrefsPropsUtil.getString(companyId, "ldap.import.method");
            if (importMethod.equals(IMPORT_BY_USER)) {
                List<SearchResult> results = PortalLDAPUtil.getUsers(ldapServerId, companyId, ctx, 0);
                for (SearchResult result : results) {
                    Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ctx, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result));
                    PortalLDAPUtil.importLDAPUser(ldapServerId, companyId, ctx, attributes, "", true);
                }
            } else if (importMethod.equals(IMPORT_BY_GROUP)) {
                List<SearchResult> results = PortalLDAPUtil.getGroups(ldapServerId, companyId, ctx, 0);
                for (SearchResult result : results) {
                    Attributes attributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ctx, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result), true);
                    PortalLDAPUtil.importLDAPGroup(ldapServerId, companyId, ctx, attributes, true);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error importing LDAP users and groups", (Throwable)e);
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
    }

    public static UserGroup importLDAPGroup(long ldapServerId, long companyId, LdapContext ctx, Attributes attributes, boolean importGroupMembership) throws Exception {
        Attribute attribute;
        UserGroup userGroup;
        Properties groupMappings;
        String postfix;
        block7: {
            postfix = PortalLDAPUtil.getPropertyPostfix(ldapServerId);
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformGroup(attributes);
            groupMappings = PortalLDAPUtil.getGroupMappings(ldapServerId, companyId);
            LogUtil.debug((Log)_log, (Properties)groupMappings);
            String groupName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)groupMappings.getProperty("groupName")).toLowerCase();
            String description = LDAPUtil.getAttributeValue((Attributes)attributes, (String)groupMappings.getProperty("description"));
            userGroup = null;
            try {
                userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)groupName);
                UserGroupLocalServiceUtil.updateUserGroup((long)companyId, (long)userGroup.getUserGroupId(), (String)groupName, (String)description);
            }
            catch (NoSuchUserGroupException nsuge) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user group to portal " + groupName));
                }
                long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
                try {
                    userGroup = UserGroupLocalServiceUtil.addUserGroup((long)defaultUserId, (long)companyId, (String)groupName, (String)description);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Could not create user group " + groupName));
                    }
                    if (!_log.isDebugEnabled()) break block7;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
        if (importGroupMembership && userGroup != null && (attribute = attributes.get(groupMappings.getProperty(IMPORT_BY_USER))) != null) {
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            StringBuilder sb = new StringBuilder();
            sb.append("(&");
            sb.append(PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix));
            sb.append("(");
            sb.append(groupMappings.getProperty("groupName"));
            sb.append("=");
            sb.append(LDAPUtil.getAttributeValue((Attributes)attributes, (String)groupMappings.getProperty("groupName")));
            sb.append("))");
            attribute = PortalLDAPUtil.getMultivaluedAttribute(companyId, ctx, baseDN, sb.toString(), attribute);
            PortalLDAPUtil._importUsersAndMembershipFromLDAPGroup(ldapServerId, companyId, ctx, userGroup.getUserGroupId(), attribute);
        }
        return userGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User importLDAPUser(long ldapServerId, long companyId, LdapContext ctx, Attributes attributes, String password, boolean importGroupMembership) throws Exception {
        LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(true);
        try {
            User user = PortalLDAPUtil._importLDAPUser(ldapServerId, companyId, ctx, attributes, password, importGroupMembership);
            return user;
        }
        finally {
            LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(false);
        }
    }

    public static boolean isAuthEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.auth.enabled", PropsValues.LDAP_AUTH_ENABLED);
    }

    public static boolean isExportEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.export.enabled", PropsValues.LDAP_EXPORT_ENABLED);
    }

    public static boolean isImportEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.import.enabled", PropsValues.LDAP_IMPORT_ENABLED);
    }

    public static boolean isImportOnStartup(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.import.on.startup");
    }

    public static boolean isNtlmEnabled(long companyId) throws SystemException {
        if (!PortalLDAPUtil.isAuthEnabled(companyId)) {
            return false;
        }
        return PrefsPropsUtil.getBoolean(companyId, "ntlm.auth.enabled", PropsValues.NTLM_AUTH_ENABLED);
    }

    public static boolean isPasswordPolicyEnabled(long companyId) throws SystemException {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.password.policy.enabled", PropsValues.LDAP_PASSWORD_POLICY_ENABLED);
    }

    public static boolean isSiteMinderEnabled(long companyId) throws SystemException {
        if (!PortalLDAPUtil.isAuthEnabled(companyId)) {
            return false;
        }
        return PrefsPropsUtil.getBoolean(companyId, "siteminder.auth.enabled", PropsValues.SITEMINDER_AUTH_ENABLED);
    }

    private static Attributes _getAttributes(LdapContext ctx, String fullDistinguishedName, String[] attributeIds) throws Exception {
        Name fullDN = new CompositeName().add(fullDistinguishedName);
        Attributes attributes = null;
        String[] auditAttributeIds = new String[]{"creatorsName", "createTimestamp", "modifiersName", "modifyTimestamp"};
        if (attributeIds == null) {
            attributes = ctx.getAttributes(fullDN);
            NamingEnumeration<? extends Attribute> enu = ctx.getAttributes(fullDN, auditAttributeIds).getAll();
            while (enu.hasMoreElements()) {
                attributes.put((Attribute)enu.nextElement());
            }
            enu.close();
        } else {
            int attributeCount = attributeIds.length + auditAttributeIds.length;
            String[] allAttributeIds = new String[attributeCount];
            System.arraycopy(attributeIds, 0, allAttributeIds, 0, attributeIds.length);
            System.arraycopy(auditAttributeIds, 0, allAttributeIds, attributeIds.length, auditAttributeIds.length);
            attributes = ctx.getAttributes(fullDN, allAttributeIds);
        }
        return attributes;
    }

    private static byte[] _getCookie(Control[] controls) {
        if (controls == null) {
            return null;
        }
        for (Control control : controls) {
            if (!(control instanceof PagedResultsResponseControl)) continue;
            PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)control;
            return pagedResultsResponseControl.getCookie();
        }
        return null;
    }

    private static void _getDNName(long ldapServerId, long companyId, User user, Properties userMappings, Name name) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(userMappings.getProperty("screenName"));
        sb.append("=");
        sb.append(user.getScreenName());
        sb.append(",");
        sb.append(PortalLDAPUtil.getUsersDN(ldapServerId, companyId));
        name.add(sb.toString());
    }

    private static String _getNextRange(String attributeId) {
        String originalAttributeId = null;
        int start = 0;
        int end = 0;
        int x = attributeId.indexOf(";");
        if (x < 0) {
            originalAttributeId = attributeId;
            end = PropsValues.LDAP_RANGE_SIZE - 1;
        } else {
            int y = attributeId.indexOf("=", x);
            int z = attributeId.indexOf("-", y);
            originalAttributeId = attributeId.substring(0, x);
            start = GetterUtil.getInteger((String)attributeId.substring(y + 1, z));
            end = GetterUtil.getInteger((String)attributeId.substring(z + 1));
            start += PropsValues.LDAP_RANGE_SIZE;
            end += PropsValues.LDAP_RANGE_SIZE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(originalAttributeId);
        sb.append(";");
        sb.append("range=");
        sb.append(start);
        sb.append("-");
        sb.append(end);
        return sb.toString();
    }

    private static void _importGroupsAndMembershipFromLDAPUser(long ldapServerId, long companyId, LdapContext ctx, long userId, Attribute attr) throws Exception {
        ArrayList<Long> newUserGroupIds = new ArrayList<Long>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String fullGroupDN = (String)attr.get(i);
            Attributes groupAttributes = null;
            try {
                groupAttributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ctx, fullGroupDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP group not found with fullGroupDN " + fullGroupDN));
                _log.error((Object)nnfe, (Throwable)nnfe);
                continue;
            }
            UserGroup userGroup = PortalLDAPUtil.importLDAPGroup(ldapServerId, companyId, ctx, groupAttributes, false);
            if (userGroup == null) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding " + userId + " to group " + userGroup.getUserGroupId()));
            }
            newUserGroupIds.add(userGroup.getUserGroupId());
        }
        UserGroupLocalServiceUtil.setUserUserGroups((long)userId, (long[])ArrayUtil.toArray((Long[])newUserGroupIds.toArray(new Long[newUserGroupIds.size()])));
    }

    private static User _importLDAPUser(long ldapServerId, long companyId, LdapContext ctx, Attributes attributes, String password, boolean importGroupMembership) throws Exception {
        Attribute attribute;
        String userMappingsGroup;
        AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
        attributes = attributesTransformer.transformUser(attributes);
        Properties userMappings = PortalLDAPUtil.getUserMappings(ldapServerId, companyId);
        LogUtil.debug((Log)_log, (Properties)userMappings);
        User defaultUser = UserLocalServiceUtil.getDefaultUser((long)companyId);
        boolean autoPassword = false;
        boolean updatePassword = true;
        if (password.equals("")) {
            autoPassword = true;
            updatePassword = false;
        }
        long creatorUserId = 0L;
        boolean passwordReset = false;
        boolean autoScreenName = false;
        String screenName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("screenName")).toLowerCase();
        String emailAddress = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("emailAddress"));
        String openId = "";
        Locale locale = defaultUser.getLocale();
        String firstName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("firstName"));
        String middleName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("middleName"));
        String lastName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("lastName"));
        if (Validator.isNull((String)firstName) || Validator.isNull((String)lastName)) {
            String fullName = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("fullName"));
            String[] names = LDAPUtil.splitFullName((String)fullName);
            firstName = names[0];
            middleName = names[1];
            lastName = names[2];
        }
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = LDAPUtil.getAttributeValue((Attributes)attributes, (String)userMappings.getProperty("jobTitle"));
        long[] groupIds = null;
        long[] organizationIds = null;
        long[] roleIds = null;
        List userGroupRoles = null;
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Screen name " + screenName + " and email address " + emailAddress));
        }
        if (Validator.isNull((String)screenName) || Validator.isNull((String)emailAddress)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Cannot add user because screen name and email address are required");
            }
            return null;
        }
        User user = null;
        try {
            String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
            user = authType.equals("screenName") ? UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName) : UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
            if (user.isDefaultUser()) {
                return user;
            }
            Date ldapUserModifiedDate = null;
            String modifiedDate = LDAPUtil.getAttributeValue((Attributes)attributes, (String)"modifyTimestamp");
            try {
                if (Validator.isNull((String)modifiedDate)) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("LDAP entry never modified, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
                ldapUserModifiedDate = dateFormat.parse(modifiedDate);
                if (ldapUserModifiedDate.equals(user.getModifiedDate()) && autoPassword) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("User is already syncronized, skipping user " + user.getEmailAddress()));
                    }
                    return user;
                }
            }
            catch (ParseException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifiedDate));
                }
                _log.debug((Object)pe, (Throwable)pe);
            }
            if (Validator.isNull((String)screenName)) {
                autoScreenName = true;
            }
            if (autoScreenName) {
                ScreenNameGenerator screenNameGenerator = (ScreenNameGenerator)InstancePool.get((String)PropsValues.USERS_SCREEN_NAME_GENERATOR);
                screenName = screenNameGenerator.generate(companyId, user.getUserId(), emailAddress);
            }
            Contact contact = user.getContact();
            Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
            birthdayCal.setTime(contact.getBirthday());
            birthdayMonth = birthdayCal.get(2);
            birthdayDay = birthdayCal.get(5);
            birthdayYear = birthdayCal.get(1);
            if (updatePassword) {
                user = UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)password, (String)password, (boolean)passwordReset, (boolean)true);
            }
            user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)password, (String)"", (String)"", (boolean)user.isPasswordReset(), (String)user.getReminderQueryQuestion(), (String)user.getReminderQueryAnswer(), (String)screenName, (String)emailAddress, (String)openId, (String)user.getLanguageId(), (String)user.getTimeZoneId(), (String)user.getGreeting(), (String)user.getComments(), (String)firstName, (String)middleName, (String)lastName, (int)contact.getPrefixId(), (int)contact.getSuffixId(), (boolean)contact.getMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)contact.getSmsSn(), (String)contact.getAimSn(), (String)contact.getFacebookSn(), (String)contact.getIcqSn(), (String)contact.getJabberSn(), (String)contact.getMsnSn(), (String)contact.getMySpaceSn(), (String)contact.getSkypeSn(), (String)contact.getTwitterSn(), (String)contact.getYmSn(), (String)jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, (ServiceContext)serviceContext);
            if (ldapUserModifiedDate != null) {
                UserLocalServiceUtil.updateModifiedDate((long)user.getUserId(), (Date)ldapUserModifiedDate);
            }
        }
        catch (NoSuchUserException nsue) {
        }
        catch (Exception e) {
            _log.error((Object)("Error updating user with screen name " + screenName + " and email address " + emailAddress), (Throwable)e);
            return null;
        }
        if (user == null) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding user to portal " + emailAddress));
                }
                user = UserLocalServiceUtil.addUser((long)creatorUserId, (long)companyId, (boolean)autoPassword, (String)password, (String)password, (boolean)autoScreenName, (String)screenName, (String)emailAddress, (String)openId, (Locale)locale, (String)firstName, (String)middleName, (String)lastName, (int)prefixId, (int)suffixId, (boolean)male, (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)jobTitle, groupIds, organizationIds, roleIds, userGroupIds, (boolean)sendEmail, (ServiceContext)serviceContext);
            }
            catch (Exception e) {
                _log.error((Object)("Problem adding user with screen name " + screenName + " and email address " + emailAddress), (Throwable)e);
            }
        }
        if (importGroupMembership && user != null && (userMappingsGroup = userMappings.getProperty(IMPORT_BY_GROUP)) != null && (attribute = attributes.get(userMappingsGroup)) != null) {
            PortalLDAPUtil._importGroupsAndMembershipFromLDAPUser(ldapServerId, companyId, ctx, user.getUserId(), attribute);
        }
        return user;
    }

    private static void _importUsersAndMembershipFromLDAPGroup(long ldapServerId, long companyId, LdapContext ctx, long userGroupId, Attribute attr) throws Exception {
        ArrayList<Long> newUserIds = new ArrayList<Long>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String fullUserDN = (String)attr.get(i);
            Attributes userAttributes = null;
            try {
                userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ctx, fullUserDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN));
                _log.error((Object)nnfe, (Throwable)nnfe);
                continue;
            }
            User user = PortalLDAPUtil.importLDAPUser(ldapServerId, companyId, ctx, userAttributes, "", false);
            if (user == null) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
            }
            newUserIds.add(user.getUserId());
        }
        UserLocalServiceUtil.setUserGroupUsers((long)userGroupId, (long[])ArrayUtil.toArray((Long[])newUserIds.toArray(new Long[newUserIds.size()])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SearchResult> _searchLDAP(long companyId, LdapContext ctx, int maxResults, String baseDN, String filter, String[] attributeIds) throws Exception {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        SearchControls cons = new SearchControls(2, maxResults, 0, attributeIds, false, false);
        try {
            byte[] cookie = new byte[]{};
            while (cookie != null) {
                if (cookie.length == 0) {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(PropsValues.LDAP_PAGE_SIZE, true)});
                } else {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(PropsValues.LDAP_PAGE_SIZE, cookie, true)});
                }
                NamingEnumeration<SearchResult> enu = ctx.search(baseDN, filter, cons);
                while (enu.hasMoreElements()) {
                    results.add((SearchResult)enu.nextElement());
                }
                enu.close();
                cookie = PortalLDAPUtil._getCookie(ctx.getResponseControls());
            }
        }
        catch (OperationNotSupportedException onse) {
            ctx.setRequestControls(null);
            NamingEnumeration<SearchResult> enu = ctx.search(baseDN, filter, cons);
            while (enu.hasMoreElements()) {
                results.add((SearchResult)enu.nextElement());
            }
            enu.close();
        }
        finally {
            ctx.setRequestControls(null);
        }
        return results;
    }
}

