/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionCheckerBagImpl
implements PermissionCheckerBag {
    private long _userId;
    private List<Group> _userGroups;
    private List<Organization> _userOrgs;
    private List<Group> _userOrgGroups;
    private List<Group> _userUserGroupGroups;
    private List<Group> _groups;
    private List<Role> _roles;
    private Map<Long, Boolean> _communityAdmins = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _communityOwners = new HashMap<Long, Boolean>();

    public PermissionCheckerBagImpl() {
    }

    public PermissionCheckerBagImpl(long userId, List<Group> userGroups, List<Organization> userOrgs, List<Group> userOrgGroups, List<Group> userUserGroupGroups, List<Group> groups, List<Role> roles) {
        this._userId = userId;
        this._userGroups = userGroups;
        this._userOrgs = userOrgs;
        this._userOrgGroups = userOrgGroups;
        this._userUserGroupGroups = userUserGroupGroups;
        this._groups = groups;
        this._roles = roles;
    }

    public List<Group> getUserGroups() {
        return this._userGroups;
    }

    public List<Organization> getUserOrgs() {
        return this._userOrgs;
    }

    public List<Group> getUserOrgGroups() {
        return this._userOrgGroups;
    }

    public List<Group> getUserUserGroupGroups() {
        return this._userUserGroupGroups;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public boolean isCommunityAdmin(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._communityAdmins.get(group.getGroupId());
        if (value == null) {
            value = this.isCommunityAdminImpl(permissionChecker, group);
            this._communityAdmins.put(group.getGroupId(), value);
        }
        return value;
    }

    public boolean isCommunityOwner(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._communityOwners.get(group.getGroupId());
        if (value == null) {
            value = this.isCommunityOwnerImpl(permissionChecker, group);
            this._communityOwners.put(group.getGroupId(), value);
        }
        return value;
    }

    protected boolean isCommunityAdminImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        long userId;
        if (group.isCommunity()) {
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Community Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Community Owner", (boolean)true)) {
                return true;
            }
        } else if (group.isOrganization()) {
            long organizationId = group.getClassPK();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                Group organizationGroup = organization.getGroup();
                long organizationGroupId = organizationGroup.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser() && (userId = group.getClassPK()) == this._userId) {
            return true;
        }
        return false;
    }

    protected boolean isCommunityOwnerImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        long userId;
        if (group.isCommunity()) {
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Community Owner", (boolean)true)) {
                return true;
            }
        } else if (group.isOrganization()) {
            long organizationId = group.getClassPK();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                Group organizationGroup = organization.getGroup();
                long organizationGroupId = organizationGroup.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser() && (userId = group.getClassPK()) == this._userId) {
            return true;
        }
        return false;
    }
}

