/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.PortletResourceBundles;
import com.liferay.portlet.expando.model.ExpandoColumn;
import com.liferay.util.UniqueList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceActionsUtil {
    public static final String ACTION_NAME_PREFIX = "action.";
    public static final String MODEL_RESOURCE_NAME_PREFIX = "model.resource.";
    public static final String[] ORGANIZATION_MODEL_RESOURCES = new String[]{Organization.class.getName(), PasswordPolicy.class.getName(), User.class.getName()};
    public static final String[] PORTAL_MODEL_RESOURCES = new String[]{ExpandoColumn.class.getName(), Organization.class.getName(), PasswordPolicy.class.getName(), Role.class.getName(), User.class.getName(), UserGroup.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(ResourceActionsUtil.class);
    private static ResourceActionsUtil _instance = new ResourceActionsUtil();
    private Set<String> _organizationModelResources = new HashSet<String>();
    private Set<String> _portalModelResources;
    private Map<String, Set<String>> _portletModelResources;
    private Map<String, List<String>> _portletResourceActions;
    private Map<String, List<String>> _portletResourceCommunityDefaultActions;
    private Map<String, List<String>> _portletResourceGuestDefaultActions;
    private Map<String, List<String>> _portletResourceGuestUnsupportedActions;
    private Map<String, List<String>> _portletResourceLayoutManagerActions;
    private Map<String, Set<String>> _modelPortletResources;
    private Map<String, List<String>> _modelResourceActions;
    private Map<String, List<String>> _modelResourceCommunityDefaultActions;
    private Map<String, List<String>> _modelResourceGuestDefaultActions;
    private Map<String, List<String>> _modelResourceGuestUnsupportedActions;
    private Map<String, List<String>> _modelResourceOwnerDefaultActions;

    public static String getAction(Locale locale, String action) {
        String key = ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static String getAction(PageContext pageContext, String action) {
        String key = ACTION_NAME_PREFIX + action;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static List<String> getActions(List<Permission> permissions) {
        UniqueList actions = new UniqueList();
        for (Permission permission : permissions) {
            actions.add(permission.getActionId());
        }
        return actions;
    }

    public static List<String> getActionsNames(PageContext pageContext, List<String> actions) {
        UniqueList uniqueList = new UniqueList();
        for (String action : actions) {
            uniqueList.add(ResourceActionsUtil.getAction(pageContext, action));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection<String>)uniqueList);
        return list;
    }

    public static List<String> getActionsNames(PageContext pageContext, String name, long actionIds) {
        try {
            List resourceActions = ResourceActionLocalServiceUtil.getResourceActions((String)name);
            ArrayList<String> actions = new ArrayList<String>();
            for (ResourceAction resourceAction : resourceActions) {
                long bitwiseValue = resourceAction.getBitwiseValue();
                if ((actionIds & bitwiseValue) != bitwiseValue) continue;
                actions.add(resourceAction.getActionId());
            }
            return ResourceActionsUtil.getActionsNames(pageContext, actions);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public static List<String> getModelNames() {
        return _instance._getModelNames();
    }

    public static List<String> getModelPortletResources(String name) {
        return _instance._getModelPortletResources(name);
    }

    public static String getModelResource(Locale locale, String name) {
        String key = MODEL_RESOURCE_NAME_PREFIX + name;
        String value = LanguageUtil.get((Locale)locale, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(locale, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static String getModelResource(PageContext pageContext, String name) {
        String key = MODEL_RESOURCE_NAME_PREFIX + name;
        String value = LanguageUtil.get((PageContext)pageContext, (String)key, null);
        if (value == null || value.equals(key)) {
            value = PortletResourceBundles.getString(pageContext, key);
        }
        if (value == null) {
            value = key;
        }
        return value;
    }

    public static List<String> getModelResourceActions(String name) {
        return _instance._getModelResourceActions(name);
    }

    public static List<String> getModelResourceCommunityDefaultActions(String name) {
        return _instance._getModelResourceCommunityDefaultActions(name);
    }

    public static List<String> getModelResourceGuestDefaultActions(String name) {
        return _instance._getModelResourceGuestDefaultActions(name);
    }

    public static List<String> getModelResourceGuestUnsupportedActions(String name) {
        return _instance._getModelResourceGuestUnsupportedActions(name);
    }

    public static List<String> getModelResourceOwnerDefaultActions(String name) {
        return _instance._getModelResourceOwnerDefaultActions(name);
    }

    public static List<String> getPortletModelResources(String portletName) {
        return _instance._getPortletModelResources(portletName);
    }

    public static List<String> getPortletNames() {
        return _instance._getPortletNames();
    }

    public static List<String> getPortletResourceActions(String name) {
        return _instance._getPortletResourceActions(name);
    }

    public static List<String> getPortletResourceCommunityDefaultActions(String name) {
        return _instance._getPortletResourceCommunityDefaultActions(name);
    }

    public static List<String> getPortletResourceGuestDefaultActions(String name) {
        return _instance._getPortletResourceGuestDefaultActions(name);
    }

    public static List<String> getPortletResourceGuestUnsupportedActions(String name) {
        return _instance._getPortletResourceGuestUnsupportedActions(name);
    }

    public static List<String> getPortletResourceLayoutManagerActions(String name) {
        return _instance._getPortletResourceLayoutManagerActions(name);
    }

    public static List<String> getResourceActions(String name) {
        if (name.contains(".")) {
            return ResourceActionsUtil.getModelResourceActions(name);
        }
        return ResourceActionsUtil.getPortletResourceActions(name);
    }

    public static List<String> getResourceActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? ResourceActionsUtil.getPortletResourceActions(portletResource) : ResourceActionsUtil.getModelResourceActions(modelResource);
        return actions;
    }

    public static List<String> getResourceCommunityDefaultActions(String name) {
        if (name.contains(".")) {
            return ResourceActionsUtil.getModelResourceCommunityDefaultActions(name);
        }
        return ResourceActionsUtil.getPortletResourceCommunityDefaultActions(name);
    }

    public static List<String> getResourceGuestUnsupportedActions(String portletResource, String modelResource) {
        List<String> actions = null;
        actions = Validator.isNull((String)modelResource) ? ResourceActionsUtil.getPortletResourceGuestUnsupportedActions(portletResource) : ResourceActionsUtil.getModelResourceGuestUnsupportedActions(modelResource);
        return actions;
    }

    public static List<Role> getRoles(Group group, String modelResource) throws SystemException {
        List allRoles = RoleLocalServiceUtil.getRoles((long)group.getCompanyId());
        int[] types = new int[]{1, 2};
        if (ResourceActionsUtil.isPortalModelResource(modelResource)) {
            types = modelResource.equals(Organization.class.getName()) || modelResource.equals(User.class.getName()) ? new int[]{1, 3} : new int[]{1};
        } else if (group.isOrganization()) {
            types = new int[]{1, 3};
        } else if (group.isUser()) {
            types = new int[]{1};
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        for (int type : types) {
            for (Role role : allRoles) {
                if (role.getType() != type) continue;
                roles.add(role);
            }
        }
        return roles;
    }

    public static void init() {
        _instance._init();
    }

    public static boolean isOrganizationModelResource(String modelResource) {
        return _instance._isOrganizationModelResource(modelResource);
    }

    public static boolean isPortalModelResource(String modelResource) {
        return _instance._isPortalModelResource(modelResource);
    }

    public static void read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        _instance._read(servletContextName, classLoader, source);
    }

    private ResourceActionsUtil() {
        int i;
        for (i = 0; i < ORGANIZATION_MODEL_RESOURCES.length; ++i) {
            this._organizationModelResources.add(ORGANIZATION_MODEL_RESOURCES[i]);
        }
        this._portalModelResources = new HashSet<String>();
        for (i = 0; i < PORTAL_MODEL_RESOURCES.length; ++i) {
            this._portalModelResources.add(PORTAL_MODEL_RESOURCES[i]);
        }
        this._portletModelResources = new HashMap<String, Set<String>>();
        this._portletResourceActions = new HashMap<String, List<String>>();
        this._portletResourceCommunityDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._portletResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._portletResourceLayoutManagerActions = new HashMap<String, List<String>>();
        this._modelPortletResources = new HashMap<String, Set<String>>();
        this._modelResourceActions = new HashMap<String, List<String>>();
        this._modelResourceCommunityDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestDefaultActions = new HashMap<String, List<String>>();
        this._modelResourceGuestUnsupportedActions = new HashMap<String, List<String>>();
        this._modelResourceOwnerDefaultActions = new HashMap<String, List<String>>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String[] configs = StringUtil.split((String)PropsUtil.get("resource.actions.configs"));
            for (int i2 = 0; i2 < configs.length; ++i2) {
                this._read(null, classLoader, configs[i2]);
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private void _checkGuestUnsupportedActions(List<String> guestUnsupportedActions, List<String> guestDefaultActions) {
        Iterator<String> itr = guestDefaultActions.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (!guestUnsupportedActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    private void _checkPortletActions(List<String> actions) {
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletCommunityDefaultActions(List<String> actions) {
        if (actions.size() == 0) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletGuestDefaultActions(List<String> actions) {
        if (actions.size() == 0) {
            actions.add("VIEW");
        }
    }

    private void _checkPortletLayoutManagerActions(List<String> actions) {
        if (!actions.contains("CONFIGURATION")) {
            actions.add("CONFIGURATION");
        }
        if (!actions.contains("PREFERENCES")) {
            actions.add("PREFERENCES");
        }
        if (!actions.contains("VIEW")) {
            actions.add("VIEW");
        }
    }

    private List<String> _getActions(Map<String, List<String>> map, String name) {
        UniqueList actions = map.get(name);
        if (actions == null) {
            actions = new UniqueList();
            map.put(name, (List<String>)actions);
        }
        return actions;
    }

    private List<String> _getModelNames() {
        return ListUtil.fromCollection(this._modelPortletResources.keySet());
    }

    private List<String> _getModelPortletResources(String name) {
        Set<String> resources = this._modelPortletResources.get(name);
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    private List<String> _getModelResourceActions(String name) {
        return this._getActions(this._modelResourceActions, name);
    }

    private List<String> _getModelResourceCommunityDefaultActions(String name) {
        return this._getActions(this._modelResourceCommunityDefaultActions, name);
    }

    private List<String> _getModelResourceGuestDefaultActions(String name) {
        return this._getActions(this._modelResourceGuestDefaultActions, name);
    }

    private List<String> _getModelResourceGuestUnsupportedActions(String name) {
        return this._getActions(this._modelResourceGuestUnsupportedActions, name);
    }

    private List<String> _getModelResourceOwnerDefaultActions(String name) {
        return this._getActions(this._modelResourceOwnerDefaultActions, name);
    }

    private List<String> _getPortletModelResources(String portletName) {
        Set<String> resources = this._portletModelResources.get(portletName = PortletConstants.getRootPortletId((String)portletName));
        if (resources == null) {
            return new UniqueList();
        }
        return Collections.list(Collections.enumeration(resources));
    }

    private List<String> _getPortletNames() {
        return ListUtil.fromCollection(this._portletModelResources.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _getPortletResourceActions(String name) {
        List<String> actions = this._getActions(this._portletResourceActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.size() == 0) {
            ResourceActionsUtil resourceActionsUtil = this;
            synchronized (resourceActionsUtil) {
                UniqueList layoutManagerActions;
                UniqueList guestDefaultActions;
                Portlet portlet = PortletLocalServiceUtil.getPortletById((String)name);
                if (portlet != null) {
                    Map portletModes = portlet.getPortletModes();
                    Set mimeTypePortletModes = (Set)portletModes.get("text/html");
                    if (mimeTypePortletModes != null) {
                        for (String actionId : mimeTypePortletModes) {
                            if (actionId.equalsIgnoreCase("edit")) {
                                actions.add("PREFERENCES");
                                continue;
                            }
                            if (actionId.equalsIgnoreCase("edit_guest")) {
                                actions.add("GUEST_PREFERENCES");
                                continue;
                            }
                            actions.add(actionId.toUpperCase());
                        }
                    }
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to obtain resource actions for unknown portlet " + name));
                }
                this._checkPortletActions(actions);
                UniqueList communityDefaultActions = this._portletResourceCommunityDefaultActions.get(name);
                if (communityDefaultActions == null) {
                    communityDefaultActions = new UniqueList();
                    this._portletResourceCommunityDefaultActions.put(name, (List<String>)communityDefaultActions);
                    this._checkPortletCommunityDefaultActions((List<String>)communityDefaultActions);
                }
                if ((guestDefaultActions = this._portletResourceGuestDefaultActions.get(name)) == null) {
                    guestDefaultActions = new UniqueList();
                    this._portletResourceGuestDefaultActions.put(name, (List<String>)guestDefaultActions);
                    this._checkPortletGuestDefaultActions((List<String>)guestDefaultActions);
                }
                if ((layoutManagerActions = this._portletResourceLayoutManagerActions.get(name)) == null) {
                    layoutManagerActions = new UniqueList();
                    this._portletResourceLayoutManagerActions.put(name, (List<String>)layoutManagerActions);
                    this._checkPortletLayoutManagerActions((List<String>)layoutManagerActions);
                }
            }
        }
        return actions;
    }

    private List<String> _getPortletResourceCommunityDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceCommunityDefaultActions, name);
    }

    private List<String> _getPortletResourceGuestDefaultActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceGuestDefaultActions, name);
    }

    private List<String> _getPortletResourceGuestUnsupportedActions(String name) {
        name = PortletConstants.getRootPortletId((String)name);
        return this._getActions(this._portletResourceGuestUnsupportedActions, name);
    }

    private List<String> _getPortletResourceLayoutManagerActions(String name) {
        List<String> actions = this._getActions(this._portletResourceLayoutManagerActions, name = PortletConstants.getRootPortletId((String)name));
        if (actions.size() < 1) {
            actions.add("CONFIGURATION");
            actions.add("PREFERENCES");
            actions.add("VIEW");
        }
        return actions;
    }

    private void _init() {
    }

    private boolean _isOrganizationModelResource(String modelResource) {
        return this._organizationModelResources.contains(modelResource);
    }

    private boolean _isPortalModelResource(String modelResource) {
        return this._portalModelResources.contains(modelResource);
    }

    private void _read(String servletContextName, ClassLoader classLoader, String source) throws Exception {
        String name;
        String xml;
        block26: {
            xml = null;
            try {
                xml = StringUtil.read((ClassLoader)classLoader, (String)source);
            }
            catch (IOException ioe) {
                if (_log.isWarnEnabled() && !source.endsWith("-ext.xml")) {
                    _log.warn((Object)("Cannot load " + source));
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block26;
                _log.warn((Object)("Error reading " + source), (Throwable)e);
            }
        }
        if (xml == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        for (Element resource : root.elements("resource")) {
            String file = resource.attributeValue("file");
            this._read(servletContextName, classLoader, file);
            String extFile = StringUtil.replace((String)file, (String)".xml", (String)"-ext.xml");
            this._read(servletContextName, classLoader, extFile);
        }
        for (Element resource : root.elements("portlet-resource")) {
            name = resource.elementText("portlet-name");
            if (servletContextName != null) {
                name = name + "_WAR_" + servletContextName;
            }
            name = PortalUtil.getJsSafePortletId((String)name);
            List<String> actions = this._getActions(this._portletResourceActions, name);
            Element supports = resource.element("supports");
            for (Element actionKey : supports.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                actions.add(actionKeyText);
            }
            if (!name.equals("90")) {
                this._checkPortletActions(actions);
            }
            List<String> communityDefaultActions = this._getActions(this._portletResourceCommunityDefaultActions, name);
            Element communityDefaults = resource.element("community-defaults");
            for (Element actionKey : communityDefaults.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                communityDefaultActions.add(actionKeyText);
            }
            List<String> guestDefaultActions = this._getActions(this._portletResourceGuestDefaultActions, name);
            Element guestDefaults = resource.element("guest-defaults");
            for (Element actionKey : guestDefaults.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                guestDefaultActions.add(actionKeyText);
            }
            List<String> guestUnsupportedActions = this._getActions(this._portletResourceGuestUnsupportedActions, name);
            Element guestUnsupported = resource.element("guest-unsupported");
            for (Element actionKey : guestUnsupported.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                guestUnsupportedActions.add(actionKeyText);
            }
            this._checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
            List<String> layoutManagerActions = this._getActions(this._portletResourceLayoutManagerActions, name);
            Element layoutManager = resource.element("layout-manager");
            if (layoutManager != null) {
                for (Element actionKey : layoutManager.elements("action-key")) {
                    String actionKeyText = actionKey.getText();
                    if (!Validator.isNotNull((String)actionKeyText)) continue;
                    layoutManagerActions.add(actionKeyText);
                }
                continue;
            }
            layoutManagerActions.addAll(actions);
        }
        for (Element resource : root.elements("model-resource")) {
            name = resource.elementText("model-name");
            Element portletRef = resource.element("portlet-ref");
            for (Element portletName : portletRef.elements("portlet-name")) {
                Set<String> modelResources;
                String portletNameString = portletName.getText();
                if (servletContextName != null) {
                    portletNameString = portletNameString + "_WAR_" + servletContextName;
                }
                if ((modelResources = this._portletModelResources.get(portletNameString = PortalUtil.getJsSafePortletId((String)portletNameString))) == null) {
                    modelResources = new HashSet<String>();
                    this._portletModelResources.put(portletNameString, modelResources);
                }
                modelResources.add(name);
                Set<String> portletResources = this._modelPortletResources.get(name);
                if (portletResources == null) {
                    portletResources = new HashSet<String>();
                    this._modelPortletResources.put(name, portletResources);
                }
                portletResources.add(portletNameString);
            }
            List<String> actions = this._getActions(this._modelResourceActions, name);
            Element supports = resource.element("supports");
            for (Element actionKey : supports.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                actions.add(actionKeyText);
            }
            List<String> communityDefaultActions = this._getActions(this._modelResourceCommunityDefaultActions, name);
            Element communityDefaults = resource.element("community-defaults");
            for (Element actionKey : communityDefaults.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                communityDefaultActions.add(actionKeyText);
            }
            List<String> guestDefaultActions = this._getActions(this._modelResourceGuestDefaultActions, name);
            Element guestDefaults = resource.element("guest-defaults");
            for (Element actionKey : guestDefaults.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                guestDefaultActions.add(actionKeyText);
            }
            List<String> guestUnsupportedActions = this._getActions(this._modelResourceGuestUnsupportedActions, name);
            Element guestUnsupported = resource.element("guest-unsupported");
            for (Element actionKey : guestUnsupported.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                guestUnsupportedActions.add(actionKeyText);
            }
            this._checkGuestUnsupportedActions(guestUnsupportedActions, guestDefaultActions);
            List<String> ownerDefaultActions = this._getActions(this._modelResourceOwnerDefaultActions, name);
            Element ownerDefaults = resource.element("owner-defaults");
            if (ownerDefaults == null) continue;
            for (Element actionKey : ownerDefaults.elements("action-key")) {
                String actionKeyText = actionKey.getText();
                if (!Validator.isNotNull((String)actionKeyText)) continue;
                ownerDefaultActions.add(actionKeyText);
            }
        }
    }
}

