/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.User;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.service.PasswordTrackerLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.words.util.WordsUtil;
import com.liferay.util.PwdGenerator;
import java.util.Date;

public class PasswordPolicyToolkit
extends BasicToolkit {
    public String generate() {
        if (PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR.equals("static")) {
            return PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_STATIC;
        }
        return PwdGenerator.getPassword();
    }

    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (passwordPolicy.getCheckSyntax()) {
            if (!passwordPolicy.getAllowDictionaryWords() && WordsUtil.isDictionaryWord(password1)) {
                throw new UserPasswordException(2);
            }
            if (password1.length() < passwordPolicy.getMinLength()) {
                throw new UserPasswordException(4);
            }
        }
        if (!passwordPolicy.getChangeable()) {
            throw new UserPasswordException(5);
        }
        if (userId != 0L) {
            User user;
            Date passwordModfiedDate;
            if (passwordPolicy.getChangeable() && (passwordModfiedDate = (user = UserLocalServiceUtil.getUserById((long)userId)).getPasswordModifiedDate()) != null) {
                Date now = new Date();
                long passwordModificationElapsedTime = now.getTime() - passwordModfiedDate.getTime();
                long userCreationElapsedTime = now.getTime() - user.getCreateDate().getTime();
                long minAge = passwordPolicy.getMinAge() * 1000L;
                if (passwordModificationElapsedTime < minAge && userCreationElapsedTime > minAge) {
                    throw new UserPasswordException(7);
                }
            }
            if (PasswordTrackerLocalServiceUtil.isSameAsCurrentPassword((long)userId, (String)password1)) {
                throw new UserPasswordException(6);
            }
            if (!PasswordTrackerLocalServiceUtil.isValidPassword((long)userId, (String)password1)) {
                throw new UserPasswordException(1);
            }
        }
    }
}

