/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.util.PropsUtil;

public class PwdToolkitUtil {
    private static PwdToolkitUtil _instance = new PwdToolkitUtil();
    private BasicToolkit _toolkit = (BasicToolkit)InstancePool.get((String)PropsUtil.get("passwords.toolkit"));

    public static String generate() {
        return _instance._generate();
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException(8);
        }
        if (!PortalLDAPUtil.isPasswordPolicyEnabled(companyId)) {
            _instance._validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
    }

    private String _generate() {
        return this._toolkit.generate();
    }

    private void _validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        this._toolkit.validate(userId, password1, password2, passwordPolicy);
    }
}

