/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.CompanyServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(CompanyServiceHttp.class);

    public static Company addCompany(HttpPrincipal httpPrincipal, String webId, String virtualHost, String mx, String shardName, boolean system) throws PortalException, SystemException {
        try {
            String paramObj0 = webId;
            if (webId == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            String paramObj1 = virtualHost;
            if (virtualHost == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = mx;
            if (mx == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = shardName;
            if (shardName == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj4 = new BooleanWrapper(system);
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "addCompany", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "deleteLogo", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyById(HttpPrincipal httpPrincipal, long companyId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "getCompanyById", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByLogoId(HttpPrincipal httpPrincipal, long logoId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(logoId);
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "getCompanyByLogoId", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByMx(HttpPrincipal httpPrincipal, String mx) throws PortalException, SystemException {
        try {
            String paramObj0 = mx;
            if (mx == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "getCompanyByMx", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByVirtualHost(HttpPrincipal httpPrincipal, String virtualHost) throws PortalException, SystemException {
        try {
            String paramObj0 = virtualHost;
            if (virtualHost == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "getCompanyByVirtualHost", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company getCompanyByWebId(HttpPrincipal httpPrincipal, String webId) throws PortalException, SystemException {
        try {
            String paramObj0 = webId;
            if (webId == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "getCompanyByWebId", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void removePreferences(HttpPrincipal httpPrincipal, long companyId, String[] keys) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            NullWrapper paramObj1 = keys;
            if (keys == null) {
                paramObj1 = new NullWrapper("[Ljava.lang.String;");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "removePreferences", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = virtualHost;
            if (virtualHost == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = mx;
            if (mx == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateCompany", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = virtualHost;
            if (virtualHost == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = mx;
            if (mx == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = homeURL;
            if (homeURL == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = name;
            if (name == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = legalName;
            if (legalName == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            String paramObj6 = legalId;
            if (legalId == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            String paramObj7 = legalType;
            if (legalType == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            String paramObj8 = sicCode;
            if (sicCode == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            String paramObj9 = tickerSymbol;
            if (tickerSymbol == null) {
                paramObj9 = new NullWrapper("java.lang.String");
            }
            String paramObj10 = industry;
            if (industry == null) {
                paramObj10 = new NullWrapper("java.lang.String");
            }
            String paramObj11 = type;
            if (type == null) {
                paramObj11 = new NullWrapper("java.lang.String");
            }
            String paramObj12 = size;
            if (size == null) {
                paramObj12 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateCompany", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Company updateCompany(HttpPrincipal httpPrincipal, long companyId, String virtualHost, String mx, String homeURL, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = virtualHost;
            if (virtualHost == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = mx;
            if (mx == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = homeURL;
            if (homeURL == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = name;
            if (name == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = legalName;
            if (legalName == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            String paramObj6 = legalId;
            if (legalId == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            String paramObj7 = legalType;
            if (legalType == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            String paramObj8 = sicCode;
            if (sicCode == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            String paramObj9 = tickerSymbol;
            if (tickerSymbol == null) {
                paramObj9 = new NullWrapper("java.lang.String");
            }
            String paramObj10 = industry;
            if (industry == null) {
                paramObj10 = new NullWrapper("java.lang.String");
            }
            String paramObj11 = type;
            if (type == null) {
                paramObj11 = new NullWrapper("java.lang.String");
            }
            String paramObj12 = size;
            if (size == null) {
                paramObj12 = new NullWrapper("java.lang.String");
            }
            String paramObj13 = languageId;
            if (languageId == null) {
                paramObj13 = new NullWrapper("java.lang.String");
            }
            String paramObj14 = timeZoneId;
            if (timeZoneId == null) {
                paramObj14 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj15 = addresses;
            if (addresses == null) {
                paramObj15 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj16 = emailAddresses;
            if (emailAddresses == null) {
                paramObj16 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj17 = phones;
            if (phones == null) {
                paramObj17 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj18 = websites;
            if (websites == null) {
                paramObj18 = new NullWrapper("java.util.List");
            }
            UnicodeProperties paramObj19 = properties;
            if (properties == null) {
                paramObj19 = new NullWrapper("com.liferay.portal.kernel.util.UnicodeProperties");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateCompany", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12, paramObj13, paramObj14, paramObj15, paramObj16, paramObj17, paramObj18, paramObj19});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Company)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateDisplay(HttpPrincipal httpPrincipal, long companyId, String languageId, String timeZoneId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = languageId;
            if (languageId == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = timeZoneId;
            if (timeZoneId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateDisplay", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateLogo(HttpPrincipal httpPrincipal, long companyId, File file) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            File paramObj1 = file;
            if (file == null) {
                paramObj1 = new NullWrapper("java.io.File");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateLogo", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updatePreferences(HttpPrincipal httpPrincipal, long companyId, UnicodeProperties properties) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            UnicodeProperties paramObj1 = properties;
            if (properties == null) {
                paramObj1 = new NullWrapper("com.liferay.portal.kernel.util.UnicodeProperties");
            }
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updatePreferences", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void updateSecurity(HttpPrincipal httpPrincipal, long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean communityLogo) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = authType;
            if (authType == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj2 = new BooleanWrapper(autoLogin);
            BooleanWrapper paramObj3 = new BooleanWrapper(sendPassword);
            BooleanWrapper paramObj4 = new BooleanWrapper(strangers);
            BooleanWrapper paramObj5 = new BooleanWrapper(strangersWithMx);
            BooleanWrapper paramObj6 = new BooleanWrapper(strangersVerify);
            BooleanWrapper paramObj7 = new BooleanWrapper(communityLogo);
            MethodWrapper methodWrapper = new MethodWrapper(CompanyServiceUtil.class.getName(), "updateSecurity", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

