/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceHttp.class);

    public static Group addGroup(HttpPrincipal httpPrincipal, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            String paramObj0 = name;
            if (name == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            String paramObj1 = description;
            if (description == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj2 = new IntegerWrapper(type);
            String paramObj3 = friendlyURL;
            if (friendlyURL == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj4 = new BooleanWrapper(active);
            ServiceContext paramObj5 = serviceContext;
            if (serviceContext == null) {
                paramObj5 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "addGroup", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group addGroup(HttpPrincipal httpPrincipal, long liveGroupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(liveGroupId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = description;
            if (description == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj3 = new IntegerWrapper(type);
            String paramObj4 = friendlyURL;
            if (friendlyURL == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj5 = new BooleanWrapper(active);
            ServiceContext paramObj6 = serviceContext;
            if (serviceContext == null) {
                paramObj6 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "addGroup", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            Object paramObj1 = groupIds;
            if (groupIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "addRoleGroups", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "deleteGroup", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long groupId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getGroup", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getGroup(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getGroup", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getManageableGroups(HttpPrincipal httpPrincipal, String actionId, int max) throws PortalException, SystemException {
        try {
            String paramObj0 = actionId;
            if (actionId == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj1 = new IntegerWrapper(max);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getManageableGroups", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getOrganizationsGroups(HttpPrincipal httpPrincipal, List<Organization> organizations) throws SystemException {
        try {
            NullWrapper paramObj0 = organizations;
            if (organizations == null) {
                paramObj0 = new NullWrapper("java.util.List");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getOrganizationsGroups", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group getUserGroup(HttpPrincipal httpPrincipal, long companyId, long userId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            LongWrapper paramObj1 = new LongWrapper(userId);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getUserGroup", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserGroupsGroups(HttpPrincipal httpPrincipal, List<UserGroup> userGroups) throws SystemException {
        try {
            NullWrapper paramObj0 = userGroups;
            if (userGroups == null) {
                paramObj0 = new NullWrapper("java.util.List");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getUserGroupsGroups", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> getUserOrganizationsGroups(HttpPrincipal httpPrincipal, long userId, int start, int end) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            IntegerWrapper paramObj1 = new IntegerWrapper(start);
            IntegerWrapper paramObj2 = new IntegerWrapper(end);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "getUserOrganizationsGroups", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserGroup(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "hasUserGroup", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Group> search(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params, int start, int end) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = description;
            if (description == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = params;
            if (params == null) {
                paramObj3 = new NullWrapper("[Ljava.lang.String;");
            }
            IntegerWrapper paramObj4 = new IntegerWrapper(start);
            IntegerWrapper paramObj5 = new IntegerWrapper(end);
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "search", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long companyId, String name, String description, String[] params) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = description;
            if (description == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = params;
            if (params == null) {
                paramObj3 = new NullWrapper("[Ljava.lang.String;");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "searchCount", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            Object paramObj1 = groupIds;
            if (groupIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "setRoleGroups", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRoleGroups(HttpPrincipal httpPrincipal, long roleId, long[] groupIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            Object paramObj1 = groupIds;
            if (groupIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "unsetRoleGroups", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateFriendlyURL(HttpPrincipal httpPrincipal, long groupId, String friendlyURL) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = friendlyURL;
            if (friendlyURL == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "updateFriendlyURL", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = description;
            if (description == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj3 = new IntegerWrapper(type);
            String paramObj4 = friendlyURL;
            if (friendlyURL == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj5 = new BooleanWrapper(active);
            ServiceContext paramObj6 = serviceContext;
            if (serviceContext == null) {
                paramObj6 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "updateGroup", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateGroup(HttpPrincipal httpPrincipal, long groupId, String typeSettings) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = typeSettings;
            if (typeSettings == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "updateGroup", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Group updateWorkflow(HttpPrincipal httpPrincipal, long groupId, boolean workflowEnabled, int workflowStages, String workflowRoleNames) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(workflowEnabled);
            IntegerWrapper paramObj2 = new IntegerWrapper(workflowStages);
            String paramObj3 = workflowRoleNames;
            if (workflowRoleNames == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(GroupServiceUtil.class.getName(), "updateWorkflow", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Group)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

