/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutServiceHttp.class);

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(parentLayoutId);
            NullWrapper paramObj3 = localeNamesMap;
            if (localeNamesMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            NullWrapper paramObj4 = localeTitlesMap;
            if (localeTitlesMap == null) {
                paramObj4 = new NullWrapper("java.util.Map");
            }
            String paramObj5 = description;
            if (description == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            String paramObj6 = type;
            if (type == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj7 = new BooleanWrapper(hidden);
            String paramObj8 = friendlyURL;
            if (friendlyURL == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "addLayout", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(parentLayoutId);
            String paramObj3 = name;
            if (name == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = title;
            if (title == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = description;
            if (description == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            String paramObj6 = type;
            if (type == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj7 = new BooleanWrapper(hidden);
            String paramObj8 = friendlyURL;
            if (friendlyURL == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "addLayout", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long plid) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "deleteLayout", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "deleteLayout", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            Object paramObj2 = layoutIds;
            if (layoutIds == null) {
                paramObj2 = new NullWrapper("[J");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            Date paramObj4 = startDate;
            if (startDate == null) {
                paramObj4 = new NullWrapper("java.util.Date");
            }
            Date paramObj5 = endDate;
            if (endDate == null) {
                paramObj5 = new NullWrapper("java.util.Date");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "exportLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj2 = parameterMap;
            if (parameterMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            Date paramObj3 = startDate;
            if (startDate == null) {
                paramObj3 = new NullWrapper("java.util.Date");
            }
            Date paramObj4 = endDate;
            if (endDate == null) {
                paramObj4 = new NullWrapper("java.util.Date");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "exportLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportLayoutsAsFile(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            Object paramObj2 = layoutIds;
            if (layoutIds == null) {
                paramObj2 = new NullWrapper("[J");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            Date paramObj4 = startDate;
            if (startDate == null) {
                paramObj4 = new NullWrapper("java.util.Date");
            }
            Date paramObj5 = endDate;
            if (endDate == null) {
                paramObj5 = new NullWrapper("java.util.Date");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "exportLayoutsAsFile", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = portletId;
            if (portletId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            Date paramObj4 = startDate;
            if (startDate == null) {
                paramObj4 = new NullWrapper("java.util.Date");
            }
            Date paramObj5 = endDate;
            if (endDate == null) {
                paramObj5 = new NullWrapper("java.util.Date");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "exportPortletInfo", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportPortletInfoAsFile(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = portletId;
            if (portletId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            Date paramObj4 = startDate;
            if (startDate == null) {
                paramObj4 = new NullWrapper("java.util.Date");
            }
            Date paramObj5 = endDate;
            if (endDate == null) {
                paramObj5 = new NullWrapper("java.util.Date");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "exportPortletInfoAsFile", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getLayoutName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            String paramObj3 = languageId;
            if (languageId == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "getLayoutName", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutReference[] getLayoutReferences(HttpPrincipal httpPrincipal, long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = portletId;
            if (portletId == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = preferencesKey;
            if (preferencesKey == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = preferencesValue;
            if (preferencesValue == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "getLayoutReferences", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (LayoutReference[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj2 = parameterMap;
            if (parameterMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            Object paramObj3 = bytes;
            if (bytes == null) {
                paramObj3 = new NullWrapper("[B");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "importLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj2 = parameterMap;
            if (parameterMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            File paramObj3 = file;
            if (file == null) {
                paramObj3 = new NullWrapper("java.io.File");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "importLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj2 = parameterMap;
            if (parameterMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            InputStream paramObj3 = is;
            if (is == null) {
                paramObj3 = new NullWrapper("java.io.InputStream");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "importLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = portletId;
            if (portletId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            File paramObj4 = file;
            if (file == null) {
                paramObj4 = new NullWrapper("java.io.File");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "importPortletInfo", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = portletId;
            if (portletId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            InputStream paramObj4 = is;
            if (is == null) {
                paramObj4 = new NullWrapper("java.io.InputStream");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "importPortletInfo", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToLive(HttpPrincipal httpPrincipal, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(sourceGroupId);
            LongWrapper paramObj1 = new LongWrapper(targetGroupId);
            BooleanWrapper paramObj2 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj3 = layoutIdMap;
            if (layoutIdMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            NullWrapper paramObj4 = parameterMap;
            if (parameterMap == null) {
                paramObj4 = new NullWrapper("java.util.Map");
            }
            String paramObj5 = scope;
            if (scope == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            Date paramObj6 = startDate;
            if (startDate == null) {
                paramObj6 = new NullWrapper("java.util.Date");
            }
            Date paramObj7 = endDate;
            if (endDate == null) {
                paramObj7 = new NullWrapper("java.util.Date");
            }
            String paramObj8 = groupName;
            if (groupName == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            String paramObj9 = cronText;
            if (cronText == null) {
                paramObj9 = new NullWrapper("java.lang.String");
            }
            Date paramObj10 = schedulerStartDate;
            if (schedulerStartDate == null) {
                paramObj10 = new NullWrapper("java.util.Date");
            }
            Date paramObj11 = schedulerEndDate;
            if (schedulerEndDate == null) {
                paramObj11 = new NullWrapper("java.util.Date");
            }
            String paramObj12 = description;
            if (description == null) {
                paramObj12 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "schedulePublishToLive", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToRemote(HttpPrincipal httpPrincipal, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(sourceGroupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            NullWrapper paramObj2 = layoutIdMap;
            if (layoutIdMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            NullWrapper paramObj3 = parameterMap;
            if (parameterMap == null) {
                paramObj3 = new NullWrapper("java.util.Map");
            }
            String paramObj4 = remoteAddress;
            if (remoteAddress == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj5 = new IntegerWrapper(remotePort);
            BooleanWrapper paramObj6 = new BooleanWrapper(secureConnection);
            LongWrapper paramObj7 = new LongWrapper(remoteGroupId);
            BooleanWrapper paramObj8 = new BooleanWrapper(remotePrivateLayout);
            Date paramObj9 = startDate;
            if (startDate == null) {
                paramObj9 = new NullWrapper("java.util.Date");
            }
            Date paramObj10 = endDate;
            if (endDate == null) {
                paramObj10 = new NullWrapper("java.util.Date");
            }
            String paramObj11 = groupName;
            if (groupName == null) {
                paramObj11 = new NullWrapper("java.lang.String");
            }
            String paramObj12 = cronText;
            if (cronText == null) {
                paramObj12 = new NullWrapper("java.lang.String");
            }
            Date paramObj13 = schedulerStartDate;
            if (schedulerStartDate == null) {
                paramObj13 = new NullWrapper("java.util.Date");
            }
            Date paramObj14 = schedulerEndDate;
            if (schedulerEndDate == null) {
                paramObj14 = new NullWrapper("java.util.Date");
            }
            String paramObj15 = description;
            if (description == null) {
                paramObj15 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "schedulePublishToRemote", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12, paramObj13, paramObj14, paramObj15});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(parentLayoutId);
            Object paramObj3 = layoutIds;
            if (layoutIds == null) {
                paramObj3 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "setLayouts", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToLive(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = jobName;
            if (jobName == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = groupName;
            if (groupName == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "unschedulePublishToLive", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToRemote(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = jobName;
            if (jobName == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = groupName;
            if (groupName == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "unschedulePublishToRemote", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            LongWrapper paramObj3 = new LongWrapper(parentLayoutId);
            NullWrapper paramObj4 = localeNamesMap;
            if (localeNamesMap == null) {
                paramObj4 = new NullWrapper("java.util.Map");
            }
            NullWrapper paramObj5 = localeTitlesMap;
            if (localeTitlesMap == null) {
                paramObj5 = new NullWrapper("java.util.Map");
            }
            String paramObj6 = description;
            if (description == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            String paramObj7 = type;
            if (type == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj8 = new BooleanWrapper(hidden);
            String paramObj9 = friendlyURL;
            if (friendlyURL == null) {
                paramObj9 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateLayout", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            LongWrapper paramObj3 = new LongWrapper(parentLayoutId);
            NullWrapper paramObj4 = localeNamesMap;
            if (localeNamesMap == null) {
                paramObj4 = new NullWrapper("java.util.Map");
            }
            NullWrapper paramObj5 = localeTitlesMap;
            if (localeTitlesMap == null) {
                paramObj5 = new NullWrapper("java.util.Map");
            }
            String paramObj6 = description;
            if (description == null) {
                paramObj6 = new NullWrapper("java.lang.String");
            }
            String paramObj7 = type;
            if (type == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj8 = new BooleanWrapper(hidden);
            String paramObj9 = friendlyURL;
            if (friendlyURL == null) {
                paramObj9 = new NullWrapper("java.lang.String");
            }
            Boolean paramObj10 = iconImage;
            if (iconImage == null) {
                paramObj10 = new NullWrapper("java.lang.Boolean");
            }
            Object paramObj11 = iconBytes;
            if (iconBytes == null) {
                paramObj11 = new NullWrapper("[B");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateLayout", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            String paramObj3 = typeSettings;
            if (typeSettings == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateLayout", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLookAndFeel(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            String paramObj3 = themeId;
            if (themeId == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = colorSchemeId;
            if (colorSchemeId == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = css;
            if (css == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj6 = new BooleanWrapper(wapTheme);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateLookAndFeel", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            String paramObj3 = name;
            if (name == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = languageId;
            if (languageId == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateName", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long plid, String name, String languageId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = languageId;
            if (languageId == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateName", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            LongWrapper paramObj3 = new LongWrapper(parentLayoutId);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateParentLayoutId", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long plid, long parentPlid) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            LongWrapper paramObj1 = new LongWrapper(parentPlid);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updateParentLayoutId", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            BooleanWrapper paramObj1 = new BooleanWrapper(privateLayout);
            LongWrapper paramObj2 = new LongWrapper(layoutId);
            IntegerWrapper paramObj3 = new IntegerWrapper(priority);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updatePriority", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long plid, int priority) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(plid);
            IntegerWrapper paramObj1 = new IntegerWrapper(priority);
            MethodWrapper methodWrapper = new MethodWrapper(LayoutServiceUtil.class.getName(), "updatePriority", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

