/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.OrganizationServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OrganizationServiceHttp.class);

    public static void addGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            Object paramObj1 = organizationIds;
            if (organizationIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "addGroupOrganizations", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addPasswordPolicyOrganizations(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(passwordPolicyId);
            Object paramObj1 = organizationIds;
            if (organizationIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "addPasswordPolicyOrganizations", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization addOrganization(HttpPrincipal httpPrincipal, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(parentOrganizationId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = type;
            if (type == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj3 = new BooleanWrapper(recursable);
            LongWrapper paramObj4 = new LongWrapper(regionId);
            LongWrapper paramObj5 = new LongWrapper(countryId);
            IntegerWrapper paramObj6 = new IntegerWrapper(statusId);
            String paramObj7 = comments;
            if (comments == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            ServiceContext paramObj8 = serviceContext;
            if (serviceContext == null) {
                paramObj8 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "addOrganization", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization addOrganization(HttpPrincipal httpPrincipal, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(parentOrganizationId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = type;
            if (type == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj3 = new BooleanWrapper(recursable);
            LongWrapper paramObj4 = new LongWrapper(regionId);
            LongWrapper paramObj5 = new LongWrapper(countryId);
            IntegerWrapper paramObj6 = new IntegerWrapper(statusId);
            String paramObj7 = comments;
            if (comments == null) {
                paramObj7 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj8 = addresses;
            if (addresses == null) {
                paramObj8 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj9 = emailAddresses;
            if (emailAddresses == null) {
                paramObj9 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj10 = orgLabors;
            if (orgLabors == null) {
                paramObj10 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj11 = phones;
            if (phones == null) {
                paramObj11 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj12 = websites;
            if (websites == null) {
                paramObj12 = new NullWrapper("java.util.List");
            }
            ServiceContext paramObj13 = serviceContext;
            if (serviceContext == null) {
                paramObj13 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "addOrganization", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12, paramObj13});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLogo(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "deleteLogo", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteOrganization(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "deleteOrganization", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getManageableOrganizations(HttpPrincipal httpPrincipal, String actionId, int max) throws PortalException, SystemException {
        try {
            String paramObj0 = actionId;
            if (actionId == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj1 = new IntegerWrapper(max);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "getManageableOrganizations", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization getOrganization(HttpPrincipal httpPrincipal, long organizationId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "getOrganization", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getOrganizationId(HttpPrincipal httpPrincipal, long companyId, String name) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "getOrganizationId", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getUserOrganizations(HttpPrincipal httpPrincipal, long userId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "getUserOrganizations", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Organization> getUserOrganizations(HttpPrincipal httpPrincipal, long userId, boolean inheritUserGroups) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            BooleanWrapper paramObj1 = new BooleanWrapper(inheritUserGroups);
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "getUserOrganizations", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            Object paramObj1 = organizationIds;
            if (organizationIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "setGroupOrganizations", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetGroupOrganizations(HttpPrincipal httpPrincipal, long groupId, long[] organizationIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            Object paramObj1 = organizationIds;
            if (organizationIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "unsetGroupOrganizations", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetPasswordPolicyOrganizations(HttpPrincipal httpPrincipal, long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(passwordPolicyId);
            Object paramObj1 = organizationIds;
            if (organizationIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "unsetPasswordPolicyOrganizations", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization updateOrganization(HttpPrincipal httpPrincipal, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            LongWrapper paramObj1 = new LongWrapper(parentOrganizationId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = type;
            if (type == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj4 = new BooleanWrapper(recursable);
            LongWrapper paramObj5 = new LongWrapper(regionId);
            LongWrapper paramObj6 = new LongWrapper(countryId);
            IntegerWrapper paramObj7 = new IntegerWrapper(statusId);
            String paramObj8 = comments;
            if (comments == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            ServiceContext paramObj9 = serviceContext;
            if (serviceContext == null) {
                paramObj9 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "updateOrganization", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Organization updateOrganization(HttpPrincipal httpPrincipal, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            LongWrapper paramObj1 = new LongWrapper(parentOrganizationId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            String paramObj3 = type;
            if (type == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj4 = new BooleanWrapper(recursable);
            LongWrapper paramObj5 = new LongWrapper(regionId);
            LongWrapper paramObj6 = new LongWrapper(countryId);
            IntegerWrapper paramObj7 = new IntegerWrapper(statusId);
            String paramObj8 = comments;
            if (comments == null) {
                paramObj8 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj9 = addresses;
            if (addresses == null) {
                paramObj9 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj10 = emailAddresses;
            if (emailAddresses == null) {
                paramObj10 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj11 = orgLabors;
            if (orgLabors == null) {
                paramObj11 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj12 = phones;
            if (phones == null) {
                paramObj12 = new NullWrapper("java.util.List");
            }
            NullWrapper paramObj13 = websites;
            if (websites == null) {
                paramObj13 = new NullWrapper("java.util.List");
            }
            ServiceContext paramObj14 = serviceContext;
            if (serviceContext == null) {
                paramObj14 = new NullWrapper("com.liferay.portal.service.ServiceContext");
            }
            MethodWrapper methodWrapper = new MethodWrapper(OrganizationServiceUtil.class.getName(), "updateOrganization", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5, paramObj6, paramObj7, paramObj8, paramObj9, paramObj10, paramObj11, paramObj12, paramObj13, paramObj14});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Organization)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

