/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.model.Resource;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.PermissionServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(PermissionServiceHttp.class);

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            LongWrapper paramObj1 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "checkPermission", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, long primKey) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            LongWrapper paramObj2 = new LongWrapper(primKey);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "checkPermission", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void checkPermission(HttpPrincipal httpPrincipal, long groupId, String name, String primKey) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            String paramObj2 = primKey;
            if (primKey == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "checkPermission", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasGroupPermission(HttpPrincipal httpPrincipal, long groupId, String actionId, long resourceId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            String paramObj1 = actionId;
            if (actionId == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            LongWrapper paramObj2 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "hasGroupPermission", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserPermission(HttpPrincipal httpPrincipal, long userId, String actionId, long resourceId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            String paramObj1 = actionId;
            if (actionId == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            LongWrapper paramObj2 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "hasUserPermission", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, List<Resource> resources, String actionId, PermissionCheckerBag permissionCheckerBag) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            NullWrapper paramObj2 = resources;
            if (resources == null) {
                paramObj2 = new NullWrapper("java.util.List");
            }
            String paramObj3 = actionId;
            if (actionId == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            PermissionCheckerBag paramObj4 = permissionCheckerBag;
            if (permissionCheckerBag == null) {
                paramObj4 = new NullWrapper("com.liferay.portal.security.permission.PermissionCheckerBag");
            }
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "hasUserPermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupPermissions(HttpPrincipal httpPrincipal, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            NullWrapper paramObj1 = actionIds;
            if (actionIds == null) {
                paramObj1 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj2 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setGroupPermissions", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setGroupPermissions(HttpPrincipal httpPrincipal, String className, String classPK, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            String paramObj0 = className;
            if (className == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            String paramObj1 = classPK;
            if (classPK == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            LongWrapper paramObj2 = new LongWrapper(groupId);
            NullWrapper paramObj3 = actionIds;
            if (actionIds == null) {
                paramObj3 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj4 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setGroupPermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setOrgGroupPermissions(HttpPrincipal httpPrincipal, long organizationId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(organizationId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            NullWrapper paramObj2 = actionIds;
            if (actionIds == null) {
                paramObj2 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj3 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setOrgGroupPermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj3 = new IntegerWrapper(scope);
            String paramObj4 = primKey;
            if (primKey == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = actionId;
            if (actionId == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setRolePermission", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setRolePermissions(HttpPrincipal httpPrincipal, long roleId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            NullWrapper paramObj2 = actionIds;
            if (actionIds == null) {
                paramObj2 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj3 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setRolePermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            NullWrapper paramObj2 = actionIds;
            if (actionIds == null) {
                paramObj2 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj3 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "setUserPermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, long permissionId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            LongWrapper paramObj2 = new LongWrapper(permissionId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "unsetRolePermission", new Object[]{paramObj0, paramObj1, paramObj2});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermission(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj3 = new IntegerWrapper(scope);
            String paramObj4 = primKey;
            if (primKey == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            String paramObj5 = actionId;
            if (actionId == null) {
                paramObj5 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "unsetRolePermission", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4, paramObj5});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetRolePermissions(HttpPrincipal httpPrincipal, long roleId, long groupId, String name, int scope, String actionId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj3 = new IntegerWrapper(scope);
            String paramObj4 = actionId;
            if (actionId == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "unsetRolePermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserPermissions(HttpPrincipal httpPrincipal, long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            NullWrapper paramObj2 = actionIds;
            if (actionIds == null) {
                paramObj2 = new NullWrapper("[Ljava.lang.String;");
            }
            LongWrapper paramObj3 = new LongWrapper(resourceId);
            MethodWrapper methodWrapper = new MethodWrapper(PermissionServiceUtil.class.getName(), "unsetUserPermissions", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

