/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.BooleanWrapper;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.LongWrapper;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.NullWrapper;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceHttp.class);

    public static Role addRole(HttpPrincipal httpPrincipal, String name, String description, int type) throws PortalException, SystemException {
        try {
            String paramObj0 = name;
            if (name == null) {
                paramObj0 = new NullWrapper("java.lang.String");
            }
            String paramObj1 = description;
            if (description == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            IntegerWrapper paramObj2 = new IntegerWrapper(type);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "addRole", new Object[]{paramObj0, paramObj1, paramObj2});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void addUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            Object paramObj1 = roleIds;
            if (roleIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "addUserRoles", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "deleteRole", new Object[]{paramObj0});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getGroupRole(HttpPrincipal httpPrincipal, long companyId, long groupId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getGroupRole", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getGroupRoles(HttpPrincipal httpPrincipal, long groupId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getGroupRoles", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long roleId) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getRole", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role getRole(HttpPrincipal httpPrincipal, long companyId, String name) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(companyId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getRole", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getUserGroupGroupRoles", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserGroupRoles(HttpPrincipal httpPrincipal, long userId, long groupId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(groupId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getUserGroupRoles", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRelatedRoles(HttpPrincipal httpPrincipal, long userId, List<Group> groups) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            NullWrapper paramObj1 = groups;
            if (groups == null) {
                paramObj1 = new NullWrapper("java.util.List");
            }
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getUserRelatedRoles", new Object[]{paramObj0, paramObj1});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Role> getUserRoles(HttpPrincipal httpPrincipal, long userId) throws SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "getUserRoles", new Object[]{paramObj0});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRole(HttpPrincipal httpPrincipal, long userId, long companyId, String name, boolean inherited) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(companyId);
            String paramObj2 = name;
            if (name == null) {
                paramObj2 = new NullWrapper("java.lang.String");
            }
            BooleanWrapper paramObj3 = new BooleanWrapper(inherited);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "hasUserRole", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserRoles(HttpPrincipal httpPrincipal, long userId, long companyId, String[] names, boolean inherited) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            LongWrapper paramObj1 = new LongWrapper(companyId);
            NullWrapper paramObj2 = names;
            if (names == null) {
                paramObj2 = new NullWrapper("[Ljava.lang.String;");
            }
            BooleanWrapper paramObj3 = new BooleanWrapper(inherited);
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "hasUserRoles", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unsetUserRoles(HttpPrincipal httpPrincipal, long userId, long[] roleIds) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(userId);
            Object paramObj1 = roleIds;
            if (roleIds == null) {
                paramObj1 = new NullWrapper("[J");
            }
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "unsetUserRoles", new Object[]{paramObj0, paramObj1});
            try {
                TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Role updateRole(HttpPrincipal httpPrincipal, long roleId, String name, Map<Locale, String> localeTitlesMap, String description, String subtype) throws PortalException, SystemException {
        try {
            LongWrapper paramObj0 = new LongWrapper(roleId);
            String paramObj1 = name;
            if (name == null) {
                paramObj1 = new NullWrapper("java.lang.String");
            }
            NullWrapper paramObj2 = localeTitlesMap;
            if (localeTitlesMap == null) {
                paramObj2 = new NullWrapper("java.util.Map");
            }
            String paramObj3 = description;
            if (description == null) {
                paramObj3 = new NullWrapper("java.lang.String");
            }
            String paramObj4 = subtype;
            if (subtype == null) {
                paramObj4 = new NullWrapper("java.lang.String");
            }
            MethodWrapper methodWrapper = new MethodWrapper(RoleServiceUtil.class.getName(), "updateRole", new Object[]{paramObj0, paramObj1, paramObj2, paramObj3, paramObj4});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodWrapper);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Role)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

