/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.EmailAddressServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailAddressServiceImpl
extends EmailAddressServiceBaseImpl {
    public EmailAddress addEmailAddress(String className, long classPK, String address, int typeId, boolean primary) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"UPDATE");
        return this.emailAddressLocalService.addEmailAddress(this.getUserId(), className, classPK, address, typeId, primary);
    }

    public void deleteEmailAddress(long emailAddressId) throws PortalException, SystemException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)emailAddress.getClassNameId(), (long)emailAddress.getClassPK(), (String)"UPDATE");
        this.emailAddressLocalService.deleteEmailAddress(emailAddressId);
    }

    public EmailAddress getEmailAddress(long emailAddressId) throws PortalException, SystemException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)emailAddress.getClassNameId(), (long)emailAddress.getClassPK(), (String)"VIEW");
        return emailAddress;
    }

    public List<EmailAddress> getEmailAddresses(String className, long classPK) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.emailAddressLocalService.getEmailAddresses(this.getUser().getCompanyId(), className, classPK);
    }

    public EmailAddress updateEmailAddress(long emailAddressId, String address, int typeId, boolean primary) throws PortalException, SystemException {
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)emailAddress.getClassNameId(), (long)emailAddress.getClassPK(), (String)"UPDATE");
        return this.emailAddressLocalService.updateEmailAddress(emailAddressId, address, typeId, primary);
    }
}

