/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.GroupServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupServiceImpl
extends GroupServiceBaseImpl {
    public Group addGroup(String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
        return this.groupLocalService.addGroup(this.getUserId(), null, 0L, name, description, type, friendlyURL, active, serviceContext);
    }

    public Group addGroup(long liveGroupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)liveGroupId, (String)"UPDATE");
        return this.groupLocalService.addGroup(this.getUserId(), null, 0L, liveGroupId, name, description, type, friendlyURL, active, serviceContext);
    }

    public void addRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        this.groupLocalService.addRoleGroups(roleId, groupIds);
    }

    public void deleteGroup(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"DELETE");
        this.groupLocalService.deleteGroup(groupId);
    }

    public Group getGroup(long groupId) throws PortalException, SystemException {
        return this.groupLocalService.getGroup(groupId);
    }

    public Group getGroup(long companyId, String name) throws PortalException, SystemException {
        return this.groupLocalService.getGroup(companyId, name);
    }

    public List<Group> getManageableGroups(String actionId, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.groupLocalService.search(permissionChecker.getCompanyId(), null, null, null, 0, max);
        }
        List groups = this.userPersistence.getGroups(permissionChecker.getUserId(), 0, max);
        groups = ListUtil.copy((List)groups);
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            Group group = (Group)itr.next();
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)actionId)) continue;
            itr.remove();
        }
        return groups;
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) {
        return this.groupLocalService.getOrganizationsGroups(organizations);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException, SystemException {
        return this.groupLocalService.getUserGroup(companyId, userId);
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) {
        return this.groupLocalService.getUserGroupsGroups(userGroups);
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException, SystemException {
        return this.groupLocalService.getUserOrganizationsGroups(userId, start, end);
    }

    public boolean hasUserGroup(long userId, long groupId) throws SystemException {
        return this.groupLocalService.hasUserGroup(userId, groupId);
    }

    public List<Group> search(long companyId, String name, String description, String[] params, int start, int end) throws SystemException {
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        return this.groupLocalService.search(companyId, name, description, paramsObj, start, end);
    }

    public int searchCount(long companyId, String name, String description, String[] params) throws SystemException {
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        return this.groupLocalService.searchCount(companyId, name, description, paramsObj);
    }

    public void setRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        this.groupLocalService.setRoleGroups(roleId, groupIds);
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        this.groupLocalService.unsetRoleGroups(roleId, groupIds);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateFriendlyURL(groupId, friendlyURL);
    }

    public Group updateGroup(long groupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateGroup(groupId, name, description, type, friendlyURL, active, serviceContext);
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateGroup(groupId, typeSettings);
    }

    public Group updateWorkflow(long groupId, boolean workflowEnabled, int workflowStages, String workflowRoleNames) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_STAGING");
        return this.groupLocalService.updateWorkflow(groupId, workflowEnabled, workflowStages, workflowRoleNames);
    }
}

