/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutHiddenException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.PortalException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.lar.LayoutImporter;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.util.FriendlyURLNormalizer;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.LayoutPriorityComparator;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutLocalServiceImpl.class);

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, 0L);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, long dlFolderId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = localeNamesMap.get(LocaleUtil.getDefault());
        friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, friendlyURL);
        int priority = this.getNextPriority(groupId, privateLayout, parentLayoutId);
        this.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURL);
        long plid = this.counterLocalService.increment();
        Layout layout = this.layoutPersistence.create(plid);
        layout.setGroupId(groupId);
        layout.setCompanyId(user.getCompanyId());
        layout.setPrivateLayout(privateLayout);
        layout.setLayoutId(layoutId);
        layout.setParentLayoutId(parentLayoutId);
        layout.setDescription(description);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        layout.setPriority(priority);
        layout.setDlFolderId(dlFolderId);
        this.setLocalizedAttributes(layout, localeNamesMap, localeTitlesMap);
        if (type.equals("portlet")) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, true, true);
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        if (PropsValues.LAYOUT_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, user.getFullName(), Layout.class.getName(), plid);
        }
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        HashMap<Locale, String> localeNamesMap = new HashMap<Locale, String>();
        Locale defaultLocale = LocaleUtil.getDefault();
        localeNamesMap.put(defaultLocale, name);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, localeNamesMap, new HashMap<Locale, String>(), description, type, hidden, friendlyURL);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, long dlFolderId) throws PortalException, SystemException {
        HashMap<Locale, String> localeNamesMap = new HashMap<Locale, String>();
        Locale defaultLocale = LocaleUtil.getDefault();
        localeNamesMap.put(defaultLocale, name);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, localeNamesMap, null, description, type, hidden, friendlyURL, dlFolderId);
    }

    public void deleteLayout(Layout layout, boolean updateLayoutSet) throws PortalException, SystemException {
        List childLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        for (Layout childLayout : childLayouts) {
            this.deleteLayout(childLayout, updateLayoutSet);
        }
        this.portletPreferencesLocalService.deletePortletPreferences(0L, 3, layout.getPlid());
        this.tasksProposalLocalService.deleteProposal(Layout.class.getName(), String.valueOf(layout.getPlid()));
        this.ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        this.mbMessageLocalService.deleteDiscussionMessages(Layout.class.getName(), layout.getPlid());
        this.journalContentSearchLocalService.deleteLayoutContentSearches(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        this.imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this.groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = layout.getPlid() + "_LAYOUT_" + "%";
        List resources = this.resourceFinder.findByC_P(layout.getCompanyId(), primKey);
        for (Resource resource : resources) {
            this.resourceLocalService.deleteResource(resource);
        }
        this.resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        this.layoutPersistence.remove((BaseModel)layout);
        if (updateLayoutSet) {
            this.layoutSetLocalService.updatePageCount(layout.getGroupId(), layout.isPrivateLayout());
        }
    }

    @Override
    public void deleteLayout(long plid) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.deleteLayout(layout, true);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.deleteLayout(layout, true);
    }

    public void deleteLayouts(long groupId, boolean privateLayout) throws PortalException, SystemException {
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L);
        for (Layout layout : layouts) {
            try {
                this.deleteLayout(layout, false);
            }
            catch (NoSuchLayoutException nsle) {}
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        return this.exportLayouts(groupId, privateLayout, null, parameterMap, startDate, endDate);
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        LayoutExporter layoutExporter = new LayoutExporter();
        return layoutExporter.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        PortletExporter portletExporter = new PortletExporter();
        return portletExporter.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    public long getDefaultPlid(long groupId) throws SystemException {
        List layouts;
        if (groupId > 0L && (layouts = this.layoutPersistence.findByGroupId(groupId, 0, 1)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) throws SystemException {
        List layouts;
        if (groupId > 0L && (layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1)).size() > 0) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws SystemException {
        if (groupId > 0L) {
            List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.getType().equals("portlet") || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    public Layout getDLFolderLayout(long dlFolderId) throws PortalException, SystemException {
        return this.layoutPersistence.findByDLFolderId(dlFolderId);
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            throw new NoSuchLayoutException();
        }
        Layout layout = this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL = this.getFriendlyURL(friendlyURL));
        if (layout == null && friendlyURL.startsWith("/")) {
            long layoutId = GetterUtil.getLong((String)friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        }
        if (layout == null) {
            throw new NoSuchLayoutException();
        }
        return layout;
    }

    @Override
    public Layout getLayout(long plid) throws PortalException, SystemException {
        return this.layoutPersistence.findByPrimaryKey(plid);
    }

    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        return this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException, SystemException {
        return this.layoutPersistence.findByIconImageId(iconImageId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) throws SystemException {
        return this.layoutPersistence.findByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, int start, int end) throws SystemException {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException, SystemException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (long layoutId : layoutIds) {
            Layout layout = this.getLayout(groupId, privateLayout, layoutId);
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) throws SystemException {
        return this.layoutPersistence.findByG_P_T(groupId, privateLayout, type);
    }

    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        List layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[layoutReferences.size()]);
    }

    public long getNextLayoutId(long groupId, boolean privateLayout) throws SystemException {
        long layoutId = 0L;
        List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
        for (Layout curLayout : layouts) {
            long curLayoutId = curLayout.getLayoutId();
            if (curLayoutId <= layoutId) continue;
            layoutId = curLayoutId;
        }
        return ++layoutId;
    }

    public List<Layout> getNullFriendlyURLLayouts() throws SystemException {
        return this.layoutFinder.findByNullFriendlyURL();
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        this.importLayouts(userId, groupId, privateLayout, parameterMap, (InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        BatchSessionUtil.setEnabled((boolean)true);
        try {
            LayoutImporter layoutImporter = new LayoutImporter();
            layoutImporter.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        finally {
            BatchSessionUtil.setEnabled((boolean)false);
        }
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            File file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        BatchSessionUtil.setEnabled((boolean)true);
        try {
            PortletImporter portletImporter = new PortletImporter();
            portletImporter.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        finally {
            BatchSessionUtil.setEnabled((boolean)false);
        }
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            File file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds) throws PortalException, SystemException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutIds[0]);
            if (!PortalUtil.isLayoutFirstPageable((String)layout.getType())) {
                throw new RequiredLayoutException(3);
            }
            if (layout.isHidden()) {
                throw new RequiredLayoutException(4);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        for (int i = 0; i < layoutIds.length; ++i) {
            layoutIdsSet.add(layoutIds[i]);
        }
        HashSet<Long> newLayoutIdsSet = new HashSet<Long>();
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, true);
                continue;
            }
            newLayoutIdsSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator i$ = layoutIdsSet.iterator();
        while (i$.hasNext()) {
            long layoutId = (Long)i$.next();
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            layout.setPriority(priority++);
            this.layoutPersistence.update((BaseModel)layout, false);
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    public Layout updateFriendlyURL(long plid, String friendlyURL) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.getFriendlyURL(layout.getGroupId(), layout.getPrivateLayout(), layout.getLayoutId(), "", friendlyURL);
        this.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL);
        layout.setFriendlyURL(friendlyURL);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        return this.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, null, null);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes) throws PortalException, SystemException {
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = localeNamesMap.get(LocaleUtil.getDefault());
        friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, "", friendlyURL);
        this.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURL);
        this.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            layout.setPriority(this.getNextPriority(groupId, privateLayout, parentLayoutId));
        }
        layout.setParentLayoutId(parentLayoutId);
        layout.setDescription(description);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        this.setLocalizedAttributes(layout, localeNamesMap, localeTitlesMap);
        if (iconImage != null) {
            long iconImageId;
            layout.setIconImage(iconImage.booleanValue());
            if (iconImage.booleanValue() && (iconImageId = layout.getIconImageId()) <= 0L) {
                iconImageId = this.counterLocalService.increment();
                layout.setIconImageId(iconImageId);
            }
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        if (iconImage != null) {
            if (!iconImage.booleanValue()) {
                this.imageLocalService.deleteImage(layout.getIconImageId());
            } else if (iconBytes != null && iconBytes.length > 0) {
                this.imageLocalService.updateImage(layout.getIconImageId(), iconBytes);
            }
        }
        try {
            if (layout.getDlFolderId() > 0L) {
                DLFolder folder = this.dlFolderLocalService.getFolder(layout.getDlFolderId());
                ServiceContext serviceContext = new ServiceContext();
                if (!name.equals(folder.getName())) {
                    this.dlFolderLocalService.updateFolder(folder.getFolderId(), folder.getParentFolderId(), name, folder.getDescription(), serviceContext);
                }
            }
        }
        catch (DuplicateFolderNameException dfne) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)dfne);
            }
        }
        catch (NoSuchFolderException nsfe) {
            // empty catch block
        }
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setTypeSettings(typeSettings);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (wapTheme) {
            layout.setWapThemeId(themeId);
            layout.setWapColorSchemeId(colorSchemeId);
        } else {
            layout.setThemeId(themeId);
            layout.setColorSchemeId(colorSchemeId);
            layout.setCss(css);
        }
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException, SystemException {
        this.validateName(name, languageId);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        this.layoutPersistence.update((BaseModel)layout, false);
        try {
            if (layout.getDlFolderId() > 0L) {
                DLFolder folder = this.dlFolderLocalService.getFolder(layout.getDlFolderId());
                ServiceContext serviceContext = new ServiceContext();
                this.dlFolderLocalService.updateFolder(folder.getFolderId(), folder.getParentFolderId(), layout.getName(LocaleUtil.getDefault()), folder.getDescription(), serviceContext);
            }
        }
        catch (NoSuchFolderException nsfe) {
            // empty catch block
        }
        return layout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        parentLayoutId = this.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            layout.setPriority(this.getNextPriority(groupId, privateLayout, parentLayoutId));
        }
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException, SystemException {
        Layout parentLayout;
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.getParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
        this.validateParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
            layout.setPriority(priority);
        }
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout, false);
        return layout;
    }

    public Layout updatePriority(Layout layout, int priority) throws SystemException {
        if (layout.getPriority() == priority) {
            return layout;
        }
        boolean lessThan = false;
        if (layout.getPriority() < priority) {
            lessThan = true;
        }
        layout.setPriority(priority);
        this.layoutPersistence.update((BaseModel)layout, false);
        priority = 0;
        List layouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        for (Layout curLayout : layouts) {
            curLayout.setPriority(priority++);
            this.layoutPersistence.update((BaseModel)curLayout, false);
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    protected String getFriendlyURL(long groupId, boolean privateLayout, long layoutId, String name, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(name);
            int i = 1;
            while (true) {
                try {
                    this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
                }
                catch (LayoutFriendlyURLException lfurle) {
                    int type = lfurle.getType();
                    if (type != 6) {
                        friendlyURL = "/" + layoutId;
                        break;
                    }
                    friendlyURL = originalFriendlyURL + i;
                    ++i;
                    continue;
                }
                break;
            }
        }
        return friendlyURL;
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizer.normalize(friendlyURL);
    }

    protected int getNextPriority(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        if (layouts.size() == 0) {
            return 0;
        }
        Layout layout = (Layout)layouts.get(layouts.size() - 1);
        return layout.getPriority() + 1;
    }

    protected long getParentLayoutId(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        Layout parentLayout;
        if (parentLayoutId != 0L && (parentLayout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, parentLayoutId)) == null) {
            parentLayoutId = 0L;
        }
        return parentLayoutId;
    }

    protected boolean isDescendant(Layout layout, long layoutId) throws PortalException, SystemException {
        if (layout.getLayoutId() == layoutId) {
            return true;
        }
        for (Layout childLayout : layout.getChildren()) {
            if (!this.isDescendant(childLayout, layoutId)) continue;
            return true;
        }
        return false;
    }

    protected void setLocalizedAttributes(Layout layout, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap) {
        Locale[] locales;
        if (localeNamesMap == null) {
            return;
        }
        if (localeTitlesMap == null) {
            return;
        }
        for (Locale locale : locales = LanguageUtil.getAvailableLocales()) {
            String name = localeNamesMap.get(locale);
            String title = localeTitlesMap.get(locale);
            layout.setName(name, locale);
            layout.setTitle(title, locale);
        }
    }

    protected void validate(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String name, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        this.validateName(name);
        boolean firstLayout = false;
        if (parentLayoutId == 0L) {
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, 0, 1);
            if (layouts.size() == 0) {
                firstLayout = true;
            } else {
                long firstLayoutId = ((Layout)layouts.get(0)).getLayoutId();
                if (firstLayoutId == layoutId) {
                    firstLayout = true;
                }
            }
        }
        if (firstLayout) {
            this.validateFirstLayout(type, hidden);
        }
        if (!PortalUtil.isLayoutParentable((String)type) && this.layoutPersistence.countByG_P_P(groupId, privateLayout, layoutId) > 0) {
            throw new LayoutTypeException(1);
        }
        this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
    }

    protected void validateFirstLayout(String type, boolean hidden) throws PortalException {
        if (!PortalUtil.isLayoutFirstPageable((String)type)) {
            throw new LayoutTypeException(2);
        }
        if (hidden) {
            throw new LayoutHiddenException();
        }
    }

    protected void validateFriendlyURL(long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
        Layout layout = this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL);
        if (layout != null && layout.getLayoutId() != layoutId) {
            throw new LayoutFriendlyURLException(6);
        }
        LayoutImpl.validateFriendlyURLKeyword(friendlyURL);
        String layoutIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)layoutIdFriendlyURL) && !layoutIdFriendlyURL.equals(String.valueOf(layoutId))) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(8);
            lfurle.setKeywordConflict(layoutIdFriendlyURL);
            throw lfurle;
        }
    }

    protected void validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutNameException();
        }
    }

    protected void validateName(String name, String languageId) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (defaultLanguageId.equals(languageId)) {
            this.validateName(name);
        }
    }

    protected void validateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            List layouts;
            long firstLayoutId;
            if (parentLayoutId == 0L) {
                return;
            }
            Layout parentLayout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, parentLayoutId);
            if (!PortalUtil.isLayoutParentable((Layout)parentLayout)) {
                throw new LayoutParentLayoutIdException(1);
            }
            if (this.isDescendant(layout, parentLayoutId)) {
                throw new LayoutParentLayoutIdException(2);
            }
            if (layout.getParentLayoutId() == 0L && (firstLayoutId = ((Layout)(layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, 0, 2)).get(0)).getLayoutId()) == layoutId) {
                Layout secondLayout = (Layout)layouts.get(1);
                try {
                    this.validateFirstLayout(secondLayout.getType(), secondLayout.getHidden());
                }
                catch (LayoutHiddenException lhe) {
                    throw new LayoutParentLayoutIdException(4);
                }
                catch (LayoutTypeException lte) {
                    throw new LayoutParentLayoutIdException(3);
                }
            }
        }
    }
}

