/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portlet.communities.messaging.LayoutsLocalPublisherRequest;
import com.liferay.portlet.communities.messaging.LayoutsRemotePublisherRequest;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        HashMap<Locale, String> localeNamesMap = new HashMap<Locale, String>();
        Locale defaultLocale = LocaleUtil.getDefault();
        localeNamesMap.put(defaultLocale, name);
        return this.addLayout(groupId, privateLayout, parentLayoutId, localeNamesMap, new HashMap<Locale, String>(), description, type, hidden, friendlyURL);
    }

    public void deleteLayout(long plid) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"DELETE");
        this.layoutLocalService.deleteLayout(plid);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId);
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, parameterMap, startDate, endDate);
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.exportPortletInfo(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS");
        return this.layoutLocalService.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        return layout.getName(languageId);
    }

    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        return this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, bytes);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, file);
    }

    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, is);
    }

    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, file);
    }

    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, is);
    }

    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)targetGroupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)targetGroupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        String command = "";
        if (scope.equals("all-pages")) {
            command = "ALL_PAGES";
        } else if (scope.equals("selected-pages")) {
            command = "SELECTED_PAGES";
        }
        LayoutsLocalPublisherRequest publisherRequest = new LayoutsLocalPublisherRequest(command, this.getUserId(), sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, startDate, endDate);
        SchedulerEngineUtil.schedule((String)groupName, (String)cronText, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)description, (String)"liferay/layouts_local_publisher", (String)JSONFactoryUtil.serialize((Object)publisherRequest));
    }

    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        Group group = this.groupLocalService.getGroup(sourceGroupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isWorkflowEnabled() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)sourceGroupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)sourceGroupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)sourceGroupId, (String)"MANAGE_LAYOUTS");
        LayoutsRemotePublisherRequest publisherRequest = new LayoutsRemotePublisherRequest(this.getUserId(), sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate);
        SchedulerEngineUtil.schedule((String)groupName, (String)cronText, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)description, (String)"liferay/layouts_remote_publisher", (String)JSONFactoryUtil.serialize((Object)publisherRequest));
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds);
    }

    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        SchedulerEngineUtil.unschedule((String)jobName, (String)groupName);
    }

    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        Group group = this.groupLocalService.getGroup(groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isWorkflowEnabled() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_STAGING") && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"PUBLISH_STAGING")) {
            throw new PrincipalException();
        }
        GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"MANAGE_LAYOUTS");
        SchedulerEngineUtil.unschedule((String)jobName, (String)groupName);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, String description, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, description, type, hidden, friendlyURL, iconImage, iconBytes);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme);
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException, SystemException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(plid, priority);
    }
}

