/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutSetVirtualHostException;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.impl.ColorSchemeImpl;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.service.base.LayoutSetLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class LayoutSetLocalServiceImpl
extends LayoutSetLocalServiceBaseImpl {
    public LayoutSet addLayoutSet(long groupId, boolean privateLayout) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        long layoutSetId = this.counterLocalService.increment();
        LayoutSet layoutSet = this.layoutSetPersistence.create(layoutSetId);
        layoutSet.setGroupId(groupId);
        layoutSet.setCompanyId(group.getCompanyId());
        layoutSet.setPrivateLayout(privateLayout);
        layoutSet.setThemeId(ThemeImpl.getDefaultRegularThemeId(group.getCompanyId()));
        layoutSet.setColorSchemeId(ColorSchemeImpl.getDefaultRegularColorSchemeId());
        layoutSet.setWapThemeId(ThemeImpl.getDefaultWapThemeId(group.getCompanyId()));
        layoutSet.setWapColorSchemeId(ColorSchemeImpl.getDefaultWapColorSchemeId());
        layoutSet.setCss("");
        this.layoutSetPersistence.update((BaseModel)layoutSet, false);
        return layoutSet;
    }

    public void deleteLayoutSet(long groupId, boolean privateLayout) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L);
        for (Layout layout : layouts) {
            try {
                this.layoutLocalService.deleteLayout(layout, false);
            }
            catch (NoSuchLayoutException nsle) {}
        }
        this.imageLocalService.deleteImage(layoutSet.getLogoId());
        this.layoutSetPersistence.removeByG_P(groupId, privateLayout);
    }

    public LayoutSet getLayoutSet(long groupId, boolean privateLayout) throws PortalException, SystemException {
        return this.layoutSetPersistence.findByG_P(groupId, privateLayout);
    }

    public LayoutSet getLayoutSet(String virtualHost) throws PortalException, SystemException {
        virtualHost = virtualHost.trim().toLowerCase();
        return this.layoutSetPersistence.findByVirtualHost(virtualHost);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException, SystemException {
        FileInputStream is = null;
        if (logo) {
            try {
                is = new FileInputStream(file);
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
        }
        this.updateLogo(groupId, privateLayout, logo, is);
    }

    public void updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is) throws PortalException, SystemException {
        long logoId;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setLogo(logo);
        if (logo && (logoId = layoutSet.getLogoId()) <= 0L) {
            logoId = this.counterLocalService.increment();
            layoutSet.setLogoId(logoId);
        }
        this.layoutSetPersistence.update((BaseModel)layoutSet, false);
        if (logo) {
            this.imageLocalService.updateImage(layoutSet.getLogoId(), is);
        } else {
            this.imageLocalService.deleteImage(layoutSet.getLogoId());
        }
    }

    public void updateLookAndFeel(long groupId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        this.updateLookAndFeel(groupId, false, themeId, colorSchemeId, css, wapTheme);
        this.updateLookAndFeel(groupId, true, themeId, colorSchemeId, css, wapTheme);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (wapTheme) {
            layoutSet.setWapThemeId(themeId);
            layoutSet.setWapColorSchemeId(colorSchemeId);
        } else {
            layoutSet.setThemeId(themeId);
            layoutSet.setColorSchemeId(colorSchemeId);
            layoutSet.setCss(css);
        }
        this.layoutSetPersistence.update((BaseModel)layoutSet, false);
        if (PrefsPropsUtil.getBoolean("theme.sync.on.group", PropsValues.THEME_SYNC_ON_GROUP)) {
            LayoutSet otherLayoutSet = this.layoutSetPersistence.findByG_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
            if (wapTheme) {
                otherLayoutSet.setWapThemeId(themeId);
                otherLayoutSet.setWapColorSchemeId(colorSchemeId);
            } else {
                otherLayoutSet.setThemeId(themeId);
                otherLayoutSet.setColorSchemeId(colorSchemeId);
            }
            this.layoutSetPersistence.update((BaseModel)otherLayoutSet, false);
        }
        return layoutSet;
    }

    public LayoutSet updatePageCount(long groupId, boolean privateLayout) throws PortalException, SystemException {
        int pageCount = this.layoutPersistence.countByG_P(groupId, privateLayout);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setPageCount(pageCount);
        this.layoutSetPersistence.update((BaseModel)layoutSet, false);
        return layoutSet;
    }

    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHost) throws PortalException, SystemException {
        if ((virtualHost = virtualHost.trim().toLowerCase()).startsWith("http://") || virtualHost.startsWith("https://")) {
            throw new LayoutSetVirtualHostException();
        }
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (Validator.isNotNull((String)virtualHost)) {
            try {
                LayoutSet virtualHostLayoutSet = this.getLayoutSet(virtualHost);
                if (!layoutSet.equals(virtualHostLayoutSet)) {
                    throw new LayoutSetVirtualHostException();
                }
            }
            catch (NoSuchLayoutSetException nslse) {
                // empty catch block
            }
            try {
                this.companyLocalService.getCompanyByVirtualHost(virtualHost);
                throw new LayoutSetVirtualHostException();
            }
            catch (NoSuchCompanyException nsce) {
                // empty catch block
            }
        }
        layoutSet.setVirtualHost(virtualHost);
        this.layoutSetPersistence.update((BaseModel)layoutSet, false);
        return layoutSet;
    }
}

