/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.service.base.LayoutTemplateLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.layoutconfiguration.util.velocity.InitColumnProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutTemplateLocalServiceImpl
extends LayoutTemplateLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutTemplateLocalServiceImpl.class);
    private static Map<String, LayoutTemplate> _portalStandard = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, LayoutTemplate> _portalCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, LayoutTemplate> _warStandard = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, LayoutTemplate> _warCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, Map<String, LayoutTemplate>> _themes = new LinkedHashMap<String, Map<String, LayoutTemplate>>();

    public String getContent(String layoutTemplateId, boolean standard, String themeId) throws SystemException {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Layout template " + layoutTemplateId + " does not exist"));
            }
            if ((layoutTemplate = this.getLayoutTemplate(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID, standard, themeId)) == null) {
                _log.error((Object)("Layout template " + layoutTemplateId + " and default layout template " + PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID + " do not exist"));
                return "";
            }
        }
        if (PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return layoutTemplate.getContent();
        }
        try {
            return layoutTemplate.getUncachedContent();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public LayoutTemplate getLayoutTemplate(String layoutTemplateId, boolean standard, String themeId) {
        if (Validator.isNull((String)layoutTemplateId)) {
            return null;
        }
        LayoutTemplate layoutTemplate = null;
        if (themeId != null && (layoutTemplate = standard ? this._getThemesStandard(themeId).get(layoutTemplateId) : this._getThemesCustom(themeId).get(layoutTemplateId)) != null) {
            return layoutTemplate;
        }
        if (standard) {
            layoutTemplate = _warStandard.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalStandard.get(layoutTemplateId);
            }
        } else {
            layoutTemplate = _warCustom.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalCustom.get(layoutTemplateId);
            }
        }
        return layoutTemplate;
    }

    public List<LayoutTemplate> getLayoutTemplates() {
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size());
        customLayoutTemplates.addAll(ListUtil.fromCollection(_portalCustom.values()));
        customLayoutTemplates.addAll(ListUtil.fromCollection(_warCustom.values()));
        return customLayoutTemplates;
    }

    public List<LayoutTemplate> getLayoutTemplates(String themeId) {
        String layoutTemplateId;
        Map<String, LayoutTemplate> _themesCustom = this._getThemesCustom(themeId);
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size() + _themesCustom.size());
        for (Map.Entry<String, LayoutTemplate> entry : _portalCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            LayoutTemplate layoutTemplate = entry.getValue();
            if (_themesCustom.containsKey(layoutTemplateId)) {
                customLayoutTemplates.add(_themesCustom.get(layoutTemplateId));
                continue;
            }
            if (_warCustom.containsKey(layoutTemplateId)) {
                customLayoutTemplates.add(_warCustom.get(layoutTemplateId));
                continue;
            }
            customLayoutTemplates.add(layoutTemplate);
        }
        for (Map.Entry<String, LayoutTemplate> entry : _warCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || _themesCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(_warCustom.get(layoutTemplateId));
        }
        for (Map.Entry<String, LayoutTemplate> entry : _themesCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || _warCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(_themesCustom.get(layoutTemplateId));
        }
        return customLayoutTemplates;
    }

    public String getWapContent(String layoutTemplateId, boolean standard, String themeId) throws SystemException {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Layout template " + layoutTemplateId + " does not exist"));
            }
            if ((layoutTemplate = this.getLayoutTemplate(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID, standard, themeId)) == null) {
                _log.error((Object)("Layout template " + layoutTemplateId + " and default layout template " + PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID + " do not exist"));
                return "";
            }
        }
        if (PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return layoutTemplate.getWapContent();
        }
        try {
            return layoutTemplate.getUncachedWapContent();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public List<ObjectValuePair<String, Boolean>> init(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, xmls, pluginPackage);
    }

    public List<ObjectValuePair<String, Boolean>> init(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<ObjectValuePair<String, Boolean>> layoutTemplateIds = new ArrayList<ObjectValuePair<String, Boolean>>();
        try {
            for (int i = 0; i < xmls.length; ++i) {
                Set<ObjectValuePair<String, Boolean>> curLayoutTemplateIds = this._readLayoutTemplates(servletContextName, servletContext, xmls[i], pluginPackage);
                for (ObjectValuePair<String, Boolean> ovp : curLayoutTemplateIds) {
                    if (layoutTemplateIds.contains(ovp)) continue;
                    layoutTemplateIds.add(ovp);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return layoutTemplateIds;
    }

    public void readLayoutTemplate(String servletContextName, ServletContext servletContext, Set<ObjectValuePair<String, Boolean>> layoutTemplateIds, Element el, boolean standard, String themeId, PluginPackage pluginPackage) {
        Map<String, LayoutTemplate> layoutTemplates = null;
        layoutTemplates = themeId != null ? (standard ? this._getThemesStandard(themeId) : this._getThemesCustom(themeId)) : (servletContextName != null ? (standard ? _warStandard : _warCustom) : (standard ? _portalStandard : _portalCustom));
        for (Element layoutTemplate : el.elements("layout-template")) {
            LayoutTemplate layoutTemplateModel;
            String layoutTemplateId = layoutTemplate.attributeValue("id");
            if (layoutTemplateIds != null) {
                ObjectValuePair ovp = new ObjectValuePair((Object)layoutTemplateId, (Object)standard);
                layoutTemplateIds.add((ObjectValuePair<String, Boolean>)ovp);
            }
            if ((layoutTemplateModel = layoutTemplates.get(layoutTemplateId)) == null) {
                layoutTemplateModel = new LayoutTemplateImpl(layoutTemplateId);
                layoutTemplates.put(layoutTemplateId, layoutTemplateModel);
            }
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            layoutTemplateModel.setPluginPackage(pluginPackage);
            layoutTemplateModel.setServletContext(servletContext);
            if (servletContextName != null) {
                layoutTemplateModel.setServletContextName(servletContextName);
            }
            layoutTemplateModel.setStandard(standard);
            layoutTemplateModel.setThemeId(themeId);
            layoutTemplateModel.setName(GetterUtil.getString((String)layoutTemplate.attributeValue("name"), (String)layoutTemplateModel.getName()));
            layoutTemplateModel.setTemplatePath(GetterUtil.getString((String)layoutTemplate.elementText("template-path"), (String)layoutTemplateModel.getTemplatePath()));
            layoutTemplateModel.setWapTemplatePath(GetterUtil.getString((String)layoutTemplate.elementText("wap-template-path"), (String)layoutTemplateModel.getWapTemplatePath()));
            layoutTemplateModel.setThumbnailPath(GetterUtil.getString((String)layoutTemplate.elementText("thumbnail-path"), (String)layoutTemplateModel.getThumbnailPath()));
            String content = null;
            try {
                content = HttpUtil.URLtoString((URL)servletContext.getResource(layoutTemplateModel.getTemplatePath()));
            }
            catch (Exception e) {
                _log.error((Object)("Unable to get content at template path " + layoutTemplateModel.getTemplatePath() + ": " + e.getMessage()));
            }
            if (Validator.isNull((String)content)) {
                _log.error((Object)("No content found at template path " + layoutTemplateModel.getTemplatePath()));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(themeId);
                if (standard) {
                    sb.append("_STANDARD_");
                } else {
                    sb.append("_CUSTOM_");
                }
                sb.append(layoutTemplateId);
                String velocityTemplateId = sb.toString();
                layoutTemplateModel.setContent(content);
                layoutTemplateModel.setColumns(this._getColumns(velocityTemplateId, content));
            }
            if (Validator.isNull((String)layoutTemplateModel.getWapTemplatePath())) {
                _log.error((Object)("The element wap-template-path is not defined for " + layoutTemplateId));
            } else {
                String wapContent = null;
                try {
                    wapContent = HttpUtil.URLtoString((URL)servletContext.getResource(layoutTemplateModel.getWapTemplatePath()));
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to get content at WAP template path " + layoutTemplateModel.getWapTemplatePath() + ": " + e.getMessage()));
                }
                if (Validator.isNull((String)wapContent)) {
                    _log.error((Object)("No content found at WAP template path " + layoutTemplateModel.getWapTemplatePath()));
                } else {
                    layoutTemplateModel.setWapContent(wapContent);
                }
            }
            Element rolesEl = layoutTemplate.element("roles");
            if (rolesEl != null) {
                for (Element roleNameEl : rolesEl.elements("role-name")) {
                    pluginSetting.addRole(roleNameEl.getText());
                }
            }
            layoutTemplateModel.setDefaultPluginSetting(pluginSetting);
        }
    }

    public void uninstallLayoutTemplate(String layoutTemplateId, boolean standard) {
        if (standard) {
            VelocityEngineUtil.flushTemplate((String)("null_STANDARD_" + layoutTemplateId));
            _warStandard.remove(layoutTemplateId);
        } else {
            VelocityEngineUtil.flushTemplate((String)("null_CUSTOM_" + layoutTemplateId));
            _warCustom.remove(layoutTemplateId);
        }
    }

    public void uninstallLayoutTemplates(String themeId) {
        Map<String, LayoutTemplate> _themesStandard = this._getThemesStandard(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : _themesStandard.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            VelocityEngineUtil.flushTemplate((String)(themeId + "_STANDARD_" + layoutTemplate.getLayoutTemplateId()));
        }
        _themesStandard.clear();
        Map<String, LayoutTemplate> _themesCustom = this._getThemesCustom(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : _themesCustom.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            VelocityEngineUtil.flushTemplate((String)(themeId + "_CUSTOM_" + layoutTemplate.getLayoutTemplateId()));
        }
        _themesCustom.clear();
    }

    private List<String> _getColumns(String velocityTemplateId, String velocityTemplateContent) {
        try {
            InitColumnProcessor processor = new InitColumnProcessor();
            VelocityContext velocityContext = VelocityEngineUtil.getStandardToolsContext();
            velocityContext.put("processor", (Object)processor);
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)new PrintWriter((Writer)new UnsyncStringWriter(true)));
            return ListUtil.sort(processor.getColumns());
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return new ArrayList<String>();
        }
    }

    private Set<ObjectValuePair<String, Boolean>> _readLayoutTemplates(String servletContextName, ServletContext servletContext, String xml, PluginPackage pluginPackage) throws Exception {
        Element customEl;
        HashSet<ObjectValuePair<String, Boolean>> layoutTemplateIds = new HashSet<ObjectValuePair<String, Boolean>>();
        if (xml == null) {
            return layoutTemplateIds;
        }
        Document doc = SAXReaderUtil.read((String)xml, (boolean)true);
        Element root = doc.getRootElement();
        Element standardEl = root.element("standard");
        if (standardEl != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplateIds, standardEl, true, null, pluginPackage);
        }
        if ((customEl = root.element("custom")) != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplateIds, customEl, false, null, pluginPackage);
        }
        return layoutTemplateIds;
    }

    private Map<String, LayoutTemplate> _getThemesCustom(String themeId) {
        String key = themeId + "_CUSTOM_";
        Map<String, LayoutTemplate> layoutTemplates = _themes.get(key);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _themes.put(key, layoutTemplates);
        }
        return layoutTemplates;
    }

    private Map<String, LayoutTemplate> _getThemesStandard(String themeId) {
        String key = themeId + "_STANDARD_";
        Map<String, LayoutTemplate> layoutTemplates = _themes.get(key);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _themes.put(key, layoutTemplates);
        }
        return layoutTemplates;
    }
}

