/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.LockLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class LockLocalServiceImpl
extends LockLocalServiceBaseImpl {
    public void clear() throws SystemException {
        this.lockPersistence.removeByExpirationDate(new Date());
    }

    public Lock getLock(String className, long key) throws PortalException, SystemException {
        return this.getLock(className, String.valueOf(key));
    }

    public Lock getLock(String className, String key) throws PortalException, SystemException {
        Lock lock = this.lockPersistence.findByC_K(className, key);
        if (lock.isExpired()) {
            this.unlock(className, key);
            throw new ExpiredLockException();
        }
        return lock;
    }

    public boolean hasLock(long userId, String className, long key) throws PortalException, SystemException {
        return this.hasLock(userId, className, String.valueOf(key));
    }

    public boolean hasLock(long userId, String className, String key) throws PortalException, SystemException {
        try {
            Lock lock = this.getLock(className, key);
            if (lock.getUserId() == userId) {
                return true;
            }
        }
        catch (ExpiredLockException ele) {
        }
        catch (NoSuchLockException nsle) {
            // empty catch block
        }
        return false;
    }

    public boolean isLocked(String className, long key) throws PortalException, SystemException {
        return this.isLocked(className, String.valueOf(key));
    }

    public boolean isLocked(String className, String key) throws PortalException, SystemException {
        try {
            this.getLock(className, key);
            return true;
        }
        catch (ExpiredLockException ele) {
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
        return false;
    }

    public Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        return this.lock(userId, className, String.valueOf(key), owner, inheritable, expirationTime);
    }

    public Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime) throws PortalException, SystemException {
        Date now = new Date();
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null) {
            if (lock.isExpired()) {
                this.unlock(className, key);
                lock = null;
            } else if (!lock.getOwner().equals(owner)) {
                throw new DuplicateLockException(lock);
            }
        }
        if (lock == null) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            long lockId = this.counterLocalService.increment();
            lock = this.lockPersistence.create(lockId);
            lock.setCompanyId(user.getCompanyId());
            lock.setUserId(user.getUserId());
            lock.setUserName(user.getFullName());
            lock.setUserId(userId);
            lock.setClassName(className);
            lock.setKey(key);
            lock.setOwner(owner);
            lock.setInheritable(inheritable);
        }
        lock.setCreateDate(now);
        if (expirationTime == 0L) {
            lock.setExpirationDate(new Date(expirationTime));
        } else {
            lock.setExpirationDate(new Date(now.getTime() + expirationTime));
        }
        this.lockPersistence.update((BaseModel)lock, false);
        return lock;
    }

    public Lock refresh(String uuid, long expirationTime) throws PortalException, SystemException {
        Date now = new Date();
        List locks = this.lockPersistence.findByUuid(uuid);
        Lock lock = null;
        if (locks.size() <= 0) {
            throw new NoSuchLockException();
        }
        lock = (Lock)locks.get(0);
        lock.setCreateDate(now);
        if (expirationTime == 0L) {
            lock.setExpirationDate(new Date(Long.MAX_VALUE));
        } else {
            lock.setExpirationDate(new Date(now.getTime() + expirationTime));
        }
        this.lockPersistence.update((BaseModel)lock, false);
        return lock;
    }

    public void unlock(String className, long key) throws SystemException {
        this.unlock(className, String.valueOf(key));
    }

    public void unlock(String className, String key) throws SystemException {
        try {
            this.lockPersistence.removeByC_K(className, key);
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }
}

