/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateOrganizationException;
import com.liferay.portal.OrganizationNameException;
import com.liferay.portal.OrganizationParentException;
import com.liferay.portal.PortalException;
import com.liferay.portal.RequiredOrganizationException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.ListTypeImpl;
import com.liferay.portal.model.impl.OrganizationImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.OrganizationLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.OrganizationNameComparator;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationLocalServiceImpl
extends OrganizationLocalServiceBaseImpl {
    public void addGroupOrganizations(long groupId, long[] organizationIds) throws SystemException {
        this.groupPersistence.addOrganizations(groupId, organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public Organization addOrganization(long userId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentOrganizationId = this.getParentOrganizationId(user.getCompanyId(), parentOrganizationId);
        recursable = true;
        this.validate(user.getCompanyId(), parentOrganizationId, name, type, countryId, statusId);
        long organizationId = this.counterLocalService.increment();
        Organization organization = this.organizationPersistence.create(organizationId);
        organization.setCompanyId(user.getCompanyId());
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(recursable);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        this.organizationPersistence.update((BaseModel)organization, false);
        Group group = this.groupLocalService.addGroup(userId, Organization.class.getName(), organizationId, null, null, 0, null, true, null);
        if (PropsValues.ORGANIZATIONS_ASSIGNMENT_AUTO) {
            Role role = this.roleLocalService.getRole(organization.getCompanyId(), "Organization Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, group.getGroupId(), new long[]{role.getRoleId()});
            this.userPersistence.addOrganization(userId, organizationId);
        }
        this.addOrganizationResources(userId, organization);
        ExpandoBridge expandoBridge = organization.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        if (serviceContext != null) {
            this.updateTagsAsset(userId, organization, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        }
        return organization;
    }

    public void addOrganizationResources(long userId, Organization organization) throws PortalException, SystemException {
        String name = Organization.class.getName();
        this.resourceLocalService.addResources(organization.getCompanyId(), 0L, userId, name, organization.getOrganizationId(), false, false, false);
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws SystemException {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public void deleteLogo(long organizationId) throws PortalException, SystemException {
        LayoutSet privateLayoutSet;
        Organization organization = this.getOrganization(organizationId);
        Group group = organization.getGroup();
        LayoutSet publicLayoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
        if (publicLayoutSet.isLogo()) {
            long logoId = publicLayoutSet.getLogoId();
            publicLayoutSet.setLogo(false);
            publicLayoutSet.setLogoId(0L);
            this.layoutSetPersistence.update((BaseModel)publicLayoutSet, false);
            this.imageLocalService.deleteImage(logoId);
        }
        if ((privateLayoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).isLogo()) {
            long logoId = privateLayoutSet.getLogoId();
            privateLayoutSet.setLogo(false);
            privateLayoutSet.setLogoId(0L);
            this.layoutSetPersistence.update((BaseModel)publicLayoutSet, false);
            if (this.imageLocalService.getImage(logoId) != null) {
                this.imageLocalService.deleteImage(logoId);
            }
        }
    }

    @Override
    public void deleteOrganization(long organizationId) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        if (this.userLocalService.getOrganizationUsersCount(organization.getOrganizationId(), true) > 0 || this.organizationPersistence.countByC_P(organization.getCompanyId(), organization.getOrganizationId()) > 0) {
            throw new RequiredOrganizationException();
        }
        this.tagsAssetLocalService.deleteAsset(Organization.class.getName(), organization.getOrganizationId());
        this.addressLocalService.deleteAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.emailAddressLocalService.deleteEmailAddresses(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        this.phoneLocalService.deletePhones(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        this.websiteLocalService.deleteWebsites(organization.getCompanyId(), Organization.class.getName(), organization.getOrganizationId());
        Group group = organization.getGroup();
        this.groupLocalService.deleteGroup(group.getGroupId());
        String name = Organization.class.getName();
        this.resourceLocalService.deleteResource(organization.getCompanyId(), name, 4, organization.getOrganizationId());
        this.organizationPersistence.remove((BaseModel)organization);
        PermissionCacheUtil.clearCache();
    }

    public List<Organization> getGroupOrganizations(long groupId) throws SystemException {
        return this.groupPersistence.getOrganizations(groupId);
    }

    @Override
    public Organization getOrganization(long organizationId) throws PortalException, SystemException {
        return this.organizationPersistence.findByPrimaryKey(organizationId);
    }

    public Organization getOrganization(long companyId, String name) throws PortalException, SystemException {
        return this.organizationPersistence.findByC_N(companyId, name);
    }

    public long getOrganizationId(long companyId, String name) throws SystemException {
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null) {
            return organization.getOrganizationId();
        }
        return 0L;
    }

    public List<Organization> getOrganizations(long[] organizationIds) throws PortalException, SystemException {
        ArrayList<Organization> organizations = new ArrayList<Organization>(organizationIds.length);
        for (long organizationId : organizationIds) {
            Organization organization = this.getOrganization(organizationId);
            organizations.add(organization);
        }
        return organizations;
    }

    public List<Organization> getParentOrganizations(long organizationId) throws PortalException, SystemException {
        if (organizationId == 0L) {
            return new ArrayList<Organization>();
        }
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        return this.getParentOrganizations(organization, true);
    }

    public List<Organization> getSuborganizations(List<Organization> organizations) throws SystemException {
        ArrayList<Organization> allSuborganizations = new ArrayList<Organization>();
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = organizations.get(i);
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
        return allSuborganizations;
    }

    public List<Organization> getSubsetOrganizations(List<Organization> allOrganizations, List<Organization> availableOrganizations) {
        ArrayList<Organization> subsetOrganizations = new ArrayList<Organization>();
        for (Organization organization : allOrganizations) {
            if (!availableOrganizations.contains(organization)) continue;
            subsetOrganizations.add(organization);
        }
        return subsetOrganizations;
    }

    public List<Organization> getUserOrganizations(long userId) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, false);
    }

    public List<Organization> getUserOrganizations(long userId, boolean inheritUserGroups) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, inheritUserGroups, -1, -1);
    }

    public List<Organization> getUserOrganizations(long userId, int start, int end) throws PortalException, SystemException {
        return this.getUserOrganizations(userId, false, start, end);
    }

    public List<Organization> getUserOrganizations(long userId, boolean inheritUserGroups, int start, int end) throws PortalException, SystemException {
        if (inheritUserGroups && PropsValues.ORGANIZATIONS_USER_GROUP_MEMBERSHIP_ENABLED) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LinkedHashMap<String, Object> organizationParams = new LinkedHashMap<String, Object>();
            organizationParams.put("usersOrgs", new Long(userId));
            return this.search(user.getCompanyId(), -1L, null, null, null, null, organizationParams, start, end);
        }
        return this.userPersistence.getOrganizations(userId, start, end);
    }

    public int getUserOrganizationsCount(long userId) throws SystemException {
        return this.userPersistence.getOrganizationsSize(userId);
    }

    public boolean hasGroupOrganization(long groupId, long organizationId) throws SystemException {
        return this.groupPersistence.containsOrganization(groupId, organizationId);
    }

    public boolean hasUserOrganization(long userId, long organizationId) throws SystemException {
        return this.userPersistence.containsOrganization(userId, organizationId);
    }

    public boolean hasUserOrganization(long userId, long organizationId, boolean inheritSuborganizations, boolean inheritUserGroups, boolean includeSpecifiedOrganization) throws PortalException, SystemException {
        if (!inheritSuborganizations && !inheritUserGroups) {
            return this.userPersistence.containsOrganization(userId, organizationId);
        }
        if (inheritSuborganizations) {
            LinkedHashMap<String, Long[][]> params = new LinkedHashMap<String, Long[][]>();
            Long[][] leftAndRightOrganizationIds = EnterpriseAdminUtil.getLeftAndRightOrganizationIds(organizationId);
            if (!includeSpecifiedOrganization) {
                leftAndRightOrganizationIds[0][0] = leftAndRightOrganizationIds[0][0] + 1L;
            }
            params.put("usersOrgsTree", leftAndRightOrganizationIds);
            if (this.userFinder.countByUser(userId, params) > 0) {
                return true;
            }
        }
        return inheritUserGroups && this.organizationFinder.countByO_U(organizationId, userId) > 0;
    }

    public boolean hasPasswordPolicyOrganization(long passwordPolicyId, long organizationId) throws SystemException {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, Organization.class.getName(), organizationId);
    }

    public void rebuildTree(long companyId, boolean force) throws SystemException {
        this.organizationPersistence.rebuildTree(companyId, force);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, parentOrganizationId, keywords, type, regionId, countryId, params, start, end, (OrderByComparator)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params, start, end, obc);
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, parentOrganizationId, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, (OrderByComparator)new OrganizationNameComparator(true));
    }

    public List<Organization> search(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.findByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long parentOrganizationId, String keywords, String type, Long regionId, Long countryId, LinkedHashMap<String, Object> params) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.countByKeywords(companyId, parentOrganizationId, parentOrganizationIdComparator, keywords, type, regionId, countryId, params);
    }

    public int searchCount(long companyId, long parentOrganizationId, String name, String type, String street, String city, String zip, Long regionId, Long countryId, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String parentOrganizationIdComparator = "=";
        if (parentOrganizationId == -1L) {
            parentOrganizationIdComparator = "!=";
        }
        return this.organizationFinder.countByC_PO_N_T_S_C_Z_R_C(companyId, parentOrganizationId, parentOrganizationIdComparator, name, type, street, city, zip, regionId, countryId, params, andOperator);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) throws SystemException {
        this.groupPersistence.setOrganizations(groupId, organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws SystemException {
        this.groupPersistence.removeOrganizations(groupId, organizationIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, Organization.class.getName(), organizationIds);
    }

    public Organization updateOrganization(long companyId, long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        parentOrganizationId = this.getParentOrganizationId(companyId, parentOrganizationId);
        recursable = true;
        this.validate(companyId, organizationId, parentOrganizationId, name, type, countryId, statusId);
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        organization.setParentOrganizationId(parentOrganizationId);
        organization.setName(name);
        organization.setType(type);
        organization.setRecursable(recursable);
        organization.setRegionId(regionId);
        organization.setCountryId(countryId);
        organization.setStatusId(statusId);
        organization.setComments(comments);
        this.organizationPersistence.update((BaseModel)organization, false);
        ExpandoBridge expandoBridge = organization.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        if (serviceContext != null) {
            this.updateTagsAsset(serviceContext.getUserId(), organization, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        }
        return organization;
    }

    public void updateTagsAsset(long userId, Organization organization, String[] tagsCategories, String[] tagsEntries) throws PortalException, SystemException {
        this.tagsAssetLocalService.updateAsset(userId, 0L, Organization.class.getName(), organization.getOrganizationId(), tagsCategories, tagsEntries, true, null, null, null, null, null, organization.getName(), "", null, null, 0, 0, null, false);
    }

    protected void addSuborganizations(List<Organization> allSuborganizations, List<Organization> organizations) throws SystemException {
        for (Organization organization : organizations) {
            if (allSuborganizations.contains(organization)) continue;
            allSuborganizations.add(organization);
            List suborganizations = this.organizationPersistence.findByC_P(organization.getCompanyId(), organization.getOrganizationId());
            this.addSuborganizations(allSuborganizations, suborganizations);
        }
    }

    protected long getParentOrganizationId(long companyId, long parentOrganizationId) throws SystemException {
        Organization parentOrganization;
        if (parentOrganizationId != 0L && ((parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId)) == null || companyId != parentOrganization.getCompanyId())) {
            parentOrganizationId = 0L;
        }
        return parentOrganizationId;
    }

    protected List<Organization> getParentOrganizations(Organization organization, boolean lastOrganization) throws PortalException, SystemException {
        long parentOrganizationId;
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        if (!lastOrganization) {
            organizations.add(organization);
        }
        if ((parentOrganizationId = organization.getParentOrganizationId()) == 0L) {
            return organizations;
        }
        Organization parentOrganization = this.organizationPersistence.findByPrimaryKey(parentOrganizationId);
        List<Organization> parentOrganizatons = this.getParentOrganizations(parentOrganization, false);
        organizations.addAll(parentOrganizatons);
        return organizations;
    }

    protected boolean isParentOrganization(long parentOrganizationId, long organizationId) throws PortalException, SystemException {
        Organization parentOrganization = this.organizationPersistence.findByPrimaryKey(parentOrganizationId);
        List<Organization> parentOrganizations = this.getParentOrganizations(organizationId);
        return parentOrganizations.contains(parentOrganization);
    }

    protected void validate(long companyId, long parentOrganizationId, String name, String type, long countryId, int statusId) throws PortalException, SystemException {
        this.validate(companyId, 0L, parentOrganizationId, name, type, countryId, statusId);
    }

    protected void validate(long companyId, long organizationId, long parentOrganizationId, String name, String type, long countryId, int statusId) throws PortalException, SystemException {
        if (parentOrganizationId == 0L) {
            if (!OrganizationImpl.isRootable(type)) {
                throw new OrganizationParentException("Organization of type " + type + " cannot be a root");
            }
        } else {
            Organization parentOrganization = this.organizationPersistence.fetchByPrimaryKey(parentOrganizationId);
            if (parentOrganization == null) {
                throw new OrganizationParentException("Organization " + parentOrganizationId + " doesn't exist");
            }
            Object[] childrenTypes = OrganizationImpl.getChildrenTypes(parentOrganization.getType());
            if (childrenTypes.length == 0) {
                throw new OrganizationParentException("Organization of type " + type + " cannot have children");
            }
            if (companyId != parentOrganization.getCompanyId() || parentOrganizationId == organizationId) {
                throw new OrganizationParentException();
            }
            if (!ArrayUtil.contains((Object[])childrenTypes, (Object)type)) {
                throw new OrganizationParentException("Type " + type + " not allowed as child of " + parentOrganization.getType());
            }
        }
        if (organizationId > 0L && parentOrganizationId != 0L && this.isParentOrganization(organizationId, parentOrganizationId)) {
            throw new OrganizationParentException();
        }
        if (Validator.isNull((String)name)) {
            throw new OrganizationNameException();
        }
        Organization organization = this.organizationPersistence.fetchByC_N(companyId, name);
        if (organization != null && organization.getName().equalsIgnoreCase(name) && (organizationId <= 0L || organization.getOrganizationId() != organizationId)) {
            throw new DuplicateOrganizationException();
        }
        boolean countryRequired = GetterUtil.getBoolean((String)PropsUtil.get("organizations.country.required", new Filter(type)));
        if (countryRequired || countryId > 0L) {
            this.countryPersistence.findByPrimaryKey(countryId);
        }
        this.listTypeService.validate(statusId, ListTypeImpl.ORGANIZATION_STATUS);
    }
}

