/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.OrganizationServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portlet.enterpriseadmin.util.EnterpriseAdminUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationServiceImpl
extends OrganizationServiceBaseImpl {
    public void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.addGroupOrganizations(groupId, organizationIds);
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"UPDATE");
        this.organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"MANAGE_SUBORGANIZATIONS") && !PortalPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION")) {
            throw new PrincipalException("User " + this.getUserId() + " does not have permissions to add " + "an organization with parent " + parentOrganizationId);
        }
        return this.organizationLocalService.addOrganization(this.getUserId(), parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext);
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        Organization organization = this.addOrganization(parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext);
        EnterpriseAdminUtil.updateAddresses(Organization.class.getName(), organization.getOrganizationId(), addresses);
        EnterpriseAdminUtil.updateEmailAddresses(Organization.class.getName(), organization.getOrganizationId(), emailAddresses);
        EnterpriseAdminUtil.updateOrgLabors(organization.getOrganizationId(), orgLabors);
        EnterpriseAdminUtil.updatePhones(Organization.class.getName(), organization.getOrganizationId(), phones);
        EnterpriseAdminUtil.updateWebsites(Organization.class.getName(), organization.getOrganizationId(), websites);
        return organization;
    }

    public void deleteLogo(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        this.organizationLocalService.deleteLogo(organizationId);
    }

    public void deleteOrganization(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"DELETE");
        this.organizationLocalService.deleteOrganization(organizationId);
    }

    public List<Organization> getManageableOrganizations(String actionId, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.organizationLocalService.search(permissionChecker.getCompanyId(), -1L, null, null, null, null, null, 0, max);
        }
        LinkedHashMap<String, Long[][]> params = new LinkedHashMap<String, Long[][]>();
        List userOrganizations = this.organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        Long[][] leftAndRightOrganizationIds = EnterpriseAdminUtil.getLeftAndRightOrganizationIds(userOrganizations);
        params.put("organizationsTree", leftAndRightOrganizationIds);
        List manageableOrganizations = this.organizationLocalService.search(permissionChecker.getCompanyId(), -1L, null, null, null, null, params, 0, max);
        manageableOrganizations = ListUtil.copy((List)manageableOrganizations);
        Iterator itr = manageableOrganizations.iterator();
        while (itr.hasNext()) {
            Organization organization = (Organization)itr.next();
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)actionId)) continue;
            itr.remove();
        }
        return manageableOrganizations;
    }

    public Organization getOrganization(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW");
        return this.organizationLocalService.getOrganization(organizationId);
    }

    public long getOrganizationId(long companyId, String name) throws SystemException {
        return this.organizationLocalService.getOrganizationId(companyId, name);
    }

    public List<Organization> getUserOrganizations(long userId) throws PortalException, SystemException {
        return this.organizationLocalService.getUserOrganizations(userId);
    }

    public List<Organization> getUserOrganizations(long userId, boolean inheritUserGroups) throws PortalException, SystemException {
        return this.organizationLocalService.getUserOrganizations(userId, inheritUserGroups);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.setGroupOrganizations(groupId, organizationIds);
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.unsetGroupOrganizations(groupId, organizationIds);
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"UPDATE");
        this.organizationLocalService.unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, ServiceContext serviceContext) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        return this.organizationLocalService.updateOrganization(this.getUser().getCompanyId(), organizationId, parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext);
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        Organization organization = this.updateOrganization(organizationId, parentOrganizationId, name, type, recursable, regionId, countryId, statusId, comments, serviceContext);
        EnterpriseAdminUtil.updateAddresses(Organization.class.getName(), organizationId, addresses);
        EnterpriseAdminUtil.updateEmailAddresses(Organization.class.getName(), organizationId, emailAddresses);
        EnterpriseAdminUtil.updateOrgLabors(organizationId, orgLabors);
        EnterpriseAdminUtil.updatePhones(Organization.class.getName(), organizationId, phones);
        EnterpriseAdminUtil.updateWebsites(Organization.class.getName(), organizationId, websites);
        return organization;
    }
}

