/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.base.PermissionServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.service.permission.IGFolderPermission;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.model.JournalTemplate;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalFeedPermission;
import com.liferay.portlet.journal.service.permission.JournalStructurePermission;
import com.liferay.portlet.journal.service.permission.JournalTemplatePermission;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.permission.PollsQuestionPermission;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;
import com.liferay.portlet.shopping.service.permission.ShoppingItemPermission;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.service.permission.SCFrameworkVersionPermission;
import com.liferay.portlet.softwarecatalog.service.permission.SCProductEntryPermission;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceImpl
extends PermissionServiceBaseImpl {
    public void checkPermission(long groupId, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
    }

    public void checkPermission(long groupId, String name, long primKey) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    public void checkPermission(long groupId, String name, String primKey) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    public boolean hasGroupPermission(long groupId, String actionId, long resourceId) throws SystemException {
        return this.permissionLocalService.hasGroupPermission(groupId, actionId, resourceId);
    }

    public boolean hasUserPermission(long userId, String actionId, long resourceId) throws SystemException {
        return this.permissionLocalService.hasUserPermission(userId, actionId, resourceId);
    }

    public boolean hasUserPermissions(long userId, long groupId, List<Resource> resources, String actionId, PermissionCheckerBag permissionCheckerBag) throws PortalException, SystemException {
        return this.permissionLocalService.hasUserPermissions(userId, groupId, resources, actionId, permissionCheckerBag);
    }

    public void setGroupPermissions(long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.setGroupPermissions(groupId, actionIds, resourceId);
    }

    public void setGroupPermissions(String className, String classPK, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.setGroupPermissions(className, classPK, groupId, actionIds, resourceId);
    }

    public void setOrgGroupPermissions(long organizationId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.setOrgGroupPermissions(organizationId, groupId, actionIds, resourceId);
    }

    public void setRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, Role.class.getName(), roleId);
        this.permissionLocalService.setRolePermission(roleId, this.getUser().getCompanyId(), name, scope, primKey, actionId);
    }

    public void setRolePermissions(long roleId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.setRolePermissions(roleId, actionIds, resourceId);
    }

    public void setUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.setUserPermissions(userId, actionIds, resourceId);
    }

    public void unsetRolePermission(long roleId, long groupId, long permissionId) throws SystemException, PortalException {
        this.checkPermission(this.getPermissionChecker(), groupId, Role.class.getName(), roleId);
        this.permissionLocalService.unsetRolePermission(roleId, permissionId);
    }

    public void unsetRolePermission(long roleId, long groupId, String name, int scope, String primKey, String actionId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, Role.class.getName(), roleId);
        this.permissionLocalService.unsetRolePermission(roleId, this.getUser().getCompanyId(), name, scope, primKey, actionId);
    }

    public void unsetRolePermissions(long roleId, long groupId, String name, int scope, String actionId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, Role.class.getName(), roleId);
        this.permissionLocalService.unsetRolePermissions(roleId, this.getUser().getCompanyId(), name, scope, actionId);
    }

    public void unsetUserPermissions(long userId, long groupId, String[] actionIds, long resourceId) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, resourceId);
        this.permissionLocalService.unsetUserPermissions(userId, actionIds, resourceId);
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, long resourceId) throws PortalException, SystemException {
        Resource resource = this.resourcePersistence.findByPrimaryKey(resourceId);
        this.checkPermission(permissionChecker, groupId, resource.getName(), resource.getPrimKey().toString());
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, long primKey) throws PortalException, SystemException {
        this.checkPermission(permissionChecker, groupId, name, String.valueOf(primKey));
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, String primKey) throws PortalException, SystemException {
        if (name.equals(BlogsEntry.class.getName())) {
            BlogsEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(BookmarksFolder.class.getName())) {
            BookmarksFolderPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(CalEvent.class.getName())) {
            CalEventPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(DLFolder.class.getName())) {
            DLFolderPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(Group.class.getName())) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)GetterUtil.getLong((String)primKey), (String)"PERMISSIONS");
        } else if (name.equals(IGFolder.class.getName())) {
            IGFolderPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(JournalArticle.class.getName())) {
            JournalArticlePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(JournalFeed.class.getName())) {
            JournalFeedPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(JournalStructure.class.getName())) {
            JournalStructurePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(JournalTemplate.class.getName())) {
            JournalTemplatePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(Layout.class.getName())) {
            long plid = GetterUtil.getLong((String)primKey);
            Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)layout.getGroupId(), (String)"MANAGE_LAYOUTS");
        } else if (name.equals(MBCategory.class.getName())) {
            MBCategoryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(PollsQuestion.class.getName())) {
            PollsQuestionPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(SCFrameworkVersion.class.getName())) {
            SCFrameworkVersionPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(SCProductEntry.class.getName())) {
            SCProductEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(ShoppingCategory.class.getName())) {
            ShoppingCategoryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(ShoppingItem.class.getName())) {
            ShoppingItemPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(User.class.getName())) {
            long userId = GetterUtil.getLong((String)primKey);
            User user = this.userPersistence.findByPrimaryKey(userId);
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)userId, (long[])user.getOrganizationIds(), (String)"PERMISSIONS");
        } else if (name.equals(WikiNode.class.getName())) {
            WikiNodePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (primKey != null && primKey.indexOf("_LAYOUT_") != -1) {
            int pos = primKey.indexOf("_LAYOUT_");
            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
            String portletId = primKey.substring(pos + "_LAYOUT_".length(), primKey.length());
            PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"CONFIGURATION");
        } else if (!permissionChecker.hasPermission(groupId, name, primKey, "PERMISSIONS") && !permissionChecker.hasPermission(groupId, name, primKey, "DEFINE_PERMISSIONS")) {
            throw new PrincipalException();
        }
    }
}

