/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.Phone;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.PhoneServiceBaseImpl;
import com.liferay.portal.service.permission.CommonPermissionUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoneServiceImpl
extends PhoneServiceBaseImpl {
    public Phone addPhone(String className, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"UPDATE");
        return this.phoneLocalService.addPhone(this.getUserId(), className, classPK, number, extension, typeId, primary);
    }

    public void deletePhone(long phoneId) throws PortalException, SystemException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)phone.getClassNameId(), (long)phone.getClassPK(), (String)"UPDATE");
        this.phoneLocalService.deletePhone(phoneId);
    }

    public Phone getPhone(long phoneId) throws PortalException, SystemException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)phone.getClassNameId(), (long)phone.getClassPK(), (String)"VIEW");
        return phone;
    }

    public List<Phone> getPhones(String className, long classPK) throws PortalException, SystemException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.phoneLocalService.getPhones(this.getUser().getCompanyId(), className, classPK);
    }

    public Phone updatePhone(long phoneId, String number, String extension, int typeId, boolean primary) throws PortalException, SystemException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)phone.getClassNameId(), (long)phone.getClassPK(), (String)"UPDATE");
        return this.phoneLocalService.updatePhone(phoneId, number, extension, typeId, primary);
    }
}

