/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.EventDefinition;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletInfo;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletAppImpl;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.PortletLocalServiceBaseImpl;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesSerializer;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletMode;
import javax.portlet.PreferencesValidator;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletLocalServiceImpl
extends PortletLocalServiceBaseImpl {
    private static final String _WSRP_CATEGORY = "category.wsrp";
    private static Log _log = LogFactoryUtil.getLog(PortletLocalServiceImpl.class);
    private static Map<String, PortletApp> _portletAppsPool = new ConcurrentHashMap<String, PortletApp>();
    private static Map<String, Portlet> _portletsPool = new ConcurrentHashMap<String, Portlet>();
    private static Map<Long, Map<String, Portlet>> _companyPortletsPool = new ConcurrentHashMap<Long, Map<String, Portlet>>();
    private static Map<String, String> _portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
    private static Map<String, Portlet> _friendlyURLMapperPortlets = new ConcurrentHashMap<String, Portlet>();

    public Portlet deployRemotePortlet(Portlet portlet) throws SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.put(portlet.getPortletId(), portlet);
        this._clearCaches();
        PortletCategory newPortletCategory = new PortletCategory();
        PortletCategory wsrpCategory = new PortletCategory(_WSRP_CATEGORY);
        newPortletCategory.addCategory(wsrpCategory);
        wsrpCategory.getPortletIds().add(portlet.getPortletId());
        long companyId = portlet.getCompanyId();
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(String.valueOf(companyId), "PORTLET_CATEGORY");
        if (portletCategory != null) {
            portletCategory.merge(newPortletCategory);
        } else {
            _log.error((Object)("Unable to register remote portlet for company " + companyId + " because it does not exist"));
        }
        List<String> portletActions = ResourceActionsUtil.getPortletResourceActions(portlet.getPortletId());
        this.resourceActionLocalService.checkResourceActions(portlet.getPortletId(), portletActions);
        return portlet;
    }

    public void destroyRemotePortlet(Portlet portlet) {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        _portletAppsPool.remove(portletApp.getServletContextName());
        this._clearCaches();
    }

    public void destroyPortlet(Portlet portlet) {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.remove(portlet.getRootPortletId());
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp != null) {
            _portletAppsPool.remove(portletApp.getServletContextName());
        }
        this._clearCaches();
    }

    public PortletCategory getEARDisplay(String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public PortletApp getPortletApp(String servletContextName) {
        return this._getPortletApp(servletContextName);
    }

    public PortletCategory getWARDisplay(String servletContextName, String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(servletContextName, xml);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public List<Portlet> getFriendlyURLMapperPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    public List<FriendlyURLMapper> getFriendlyURLMappers() {
        ArrayList<FriendlyURLMapper> friendlyURLMappers = new ArrayList<FriendlyURLMapper>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            friendlyURLMappers.add(friendlyURLMapper);
        }
        return friendlyURLMappers;
    }

    public Portlet getPortletById(String portletId) {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        return portletsPool.get(portletId);
    }

    public Portlet getPortletById(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (portletId.equals(rootPortletId)) {
            portlet = companyPortletsPool.get(portletId);
        } else {
            portlet = companyPortletsPool.get(rootPortletId);
            if (portlet != null) {
                portlet = portlet.getClonedInstance(portletId);
            }
        }
        if (portlet == null && !portletId.equals("LIFERAY_PORTAL")) {
            if (_portletsPool.isEmpty()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"No portlets are installed");
                }
            } else {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Portlet not found for " + companyId + " " + portletId));
                }
                portlet = new PortletImpl(0L, portletId);
                portlet.setTimestamp(System.currentTimeMillis());
                PortletApp portletApp = this._getPortletApp("");
                portlet.setPortletApp(portletApp);
                portlet.setPortletName(portletId);
                portlet.setDisplayName(portletId);
                portlet.setPortletClass(MVCPortlet.class.getName());
                Map initParams = portlet.getInitParams();
                initParams.put("view-jsp", "/html/portal/undeployed_portlet.jsp");
                HashSet<String> mimeTypePortletModes = new HashSet<String>();
                mimeTypePortletModes.add(PortletMode.VIEW.toString().toLowerCase());
                portlet.getPortletModes().put("text/html", mimeTypePortletModes);
                HashSet<String> mimeTypeWindowStates = new HashSet<String>();
                mimeTypeWindowStates.add(WindowState.NORMAL.toString().toLowerCase());
                portlet.getWindowStates().put("text/html", mimeTypeWindowStates);
                portlet.setPortletInfo(new PortletInfo(portletId, portletId, portletId, portletId));
                if (portletId.indexOf("_INSTANCE_") != -1) {
                    portlet.setInstanceable(true);
                }
                portlet.setActive(true);
                portlet.setUndeployedPortlet(true);
                companyPortletsPool.put(portletId, portlet);
            }
        }
        return portlet;
    }

    public Portlet getPortletByStrutsPath(long companyId, String strutsPath) throws SystemException {
        return this.getPortletById(companyId, this._getPortletId(strutsPath));
    }

    public List<Portlet> getPortlets() {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        return ListUtil.fromCollection(portletsPool.values());
    }

    public List<Portlet> getPortlets(long companyId) throws SystemException {
        return this.getPortlets(companyId, true, true);
    }

    public List<Portlet> getPortlets(long companyId, boolean showSystem, boolean showPortal) throws SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool(companyId);
        List portlets = ListUtil.fromCollection(portletsPool.values());
        if (!showSystem || !showPortal) {
            Iterator itr = portlets.iterator();
            while (itr.hasNext()) {
                Portlet portlet = (Portlet)itr.next();
                if (showPortal && portlet.getPortletId().equals("90")) continue;
                if (!showPortal && portlet.getPortletId().equals("90")) {
                    itr.remove();
                    continue;
                }
                if (showSystem || !portlet.isSystem()) continue;
                itr.remove();
            }
        }
        return portlets;
    }

    public boolean hasPortlet(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        portlet = portletId.equals(rootPortletId) ? companyPortletsPool.get(portletId) : companyPortletsPool.get(rootPortletId);
        return portlet != null;
    }

    public void initEAR(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        _portletAppsPool.clear();
        _portletsPool.clear();
        _companyPortletsPool.clear();
        _portletIdsByStrutsPath.clear();
        _friendlyURLMapperPortlets.clear();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            List<String> servletURLPatterns = this._readWebXML(xmls[4]);
            Set<String> portletIds = this._readPortletXML(servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(xmls[2], portletsPool);
            liferayPortletIds.addAll(this._readLiferayPortletXML(xmls[3], portletsPool));
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            Iterator<Map.Entry<String, Portlet>> portletPoolsItr = portletsPool.entrySet().iterator();
            while (portletPoolsItr.hasNext()) {
                Map.Entry<String, Portlet> entry = portletPoolsItr.next();
                Portlet portletModel = entry.getValue();
                if (portletModel.getPortletId().equals("9") || portletModel.getPortletId().equals("2") || portletModel.isInclude()) continue;
                portletPoolsItr.remove();
            }
            PortletApp portletApp = this._getPortletApp("");
            this._setSpriteImages(servletContext, portletApp, "/html/icons/");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public List<Portlet> initWAR(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            List<String> servletURLPatterns = this._readWebXML(xmls[3]);
            Set<String> portletIds = this._readPortletXML(servletContextName, servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContextName, servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(servletContextName, xmls[2], portletsPool);
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            for (String portletId : portletIds) {
                Portlet portlet = this._getPortletsPool().get(portletId);
                portlets.add(portlet);
                PortletInstanceFactoryUtil.clear((Portlet)portlet);
            }
            PortletApp portletApp = this._getPortletApp(servletContextName);
            this._setSpriteImages(servletContext, portletApp, "/icons/");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        this._clearCaches();
        return portlets;
    }

    public Portlet newPortlet(long companyId, String portletId) {
        return new PortletImpl(companyId, portletId);
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) throws SystemException {
        Portlet portlet = this.portletPersistence.fetchByC_P(companyId, portletId = PortalUtil.getJsSafePortletId((String)portletId));
        if (portlet == null) {
            long id = this.counterLocalService.increment();
            portlet = this.portletPersistence.create(id);
            portlet.setCompanyId(companyId);
            portlet.setPortletId(portletId);
        }
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletPersistence.update((BaseModel)portlet, false);
        portlet = this.getPortletById(companyId, portletId);
        portlet.setRoles(roles);
        portlet.setActive(active);
        return portlet;
    }

    private void _clearCaches() {
        _portletIdsByStrutsPath.clear();
        _companyPortletsPool.clear();
    }

    private PortletApp _getPortletApp(String servletContextName) {
        PortletApp portletApp = _portletAppsPool.get(servletContextName);
        if (portletApp == null) {
            portletApp = new PortletAppImpl(servletContextName);
            _portletAppsPool.put(servletContextName, portletApp);
        }
        return portletApp;
    }

    private String _getPortletId(String securityPath) {
        String portletId;
        if (_portletIdsByStrutsPath.size() == 0) {
            for (Portlet portlet : this._getPortletsPool().values()) {
                _portletIdsByStrutsPath.put(portlet.getStrutsPath(), portlet.getPortletId());
            }
        }
        if (Validator.isNull((String)(portletId = _portletIdsByStrutsPath.get(securityPath)))) {
            _log.error((Object)("Struts path " + securityPath + " is not mapped to a portlet " + "in liferay-portlet.xml"));
        }
        return portletId;
    }

    private List<Portlet> _getPortletsByPortletName(String portletName, String servletContextName, Map<String, Portlet> portletsPool) {
        List<Object> portlets = null;
        int pos = portletName.indexOf("*");
        if (pos == -1) {
            Portlet portlet;
            portlets = new ArrayList();
            String portletId = portletName;
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId + "_WAR_" + servletContextName;
            }
            if ((portlet = portletsPool.get(portletId = PortalUtil.getJsSafePortletId((String)portletId))) != null) {
                portlets.add(portlet);
            }
            return portlets;
        }
        String portletNamePrefix = portletName.substring(0, pos);
        portlets = this._getPortletsByServletContextName(servletContextName, portletsPool);
        Iterator<Object> itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (portlet.getPortletId().startsWith(portletNamePrefix)) continue;
            itr.remove();
        }
        return portlets;
    }

    private List<Portlet> _getPortletsByServletContextName(String servletContextName, Map<String, Portlet> portletsPool) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        for (Map.Entry<String, Portlet> entry : portletsPool.entrySet()) {
            String portletId = entry.getKey();
            Portlet portlet = entry.getValue();
            if (Validator.isNotNull((String)servletContextName)) {
                if (!portletId.endsWith("_WAR_" + servletContextName)) continue;
                portlets.add(portlet);
                continue;
            }
            if (portletId.indexOf("_WAR_") != -1) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    private Map<String, Portlet> _getPortletsPool() {
        return _portletsPool;
    }

    private Map<String, Portlet> _getPortletsPool(long companyId) throws SystemException {
        Map<String, Portlet> portletsPool = _companyPortletsPool.get(companyId);
        if (portletsPool == null) {
            portletsPool = new ConcurrentHashMap<String, Portlet>();
            Map<String, Portlet> parentPortletsPool = this._getPortletsPool();
            if (parentPortletsPool == null) {
                return portletsPool;
            }
            for (Portlet portlet : parentPortletsPool.values()) {
                portlet = (Portlet)portlet.clone();
                portlet.setCompanyId(companyId);
                portletsPool.put(portlet.getPortletId(), portlet);
            }
            for (Portlet portlet : this.portletPersistence.findByCompanyId(companyId)) {
                Portlet portletModel = portletsPool.get(portlet.getPortletId());
                if (portletModel == null) continue;
                portletModel.setPluginPackage(portlet.getPluginPackage());
                portletModel.setDefaultPluginSetting(portlet.getDefaultPluginSetting());
                portletModel.setRoles(portlet.getRoles());
                portletModel.setActive(portlet.getActive());
            }
            _companyPortletsPool.put(companyId, portletsPool);
        }
        return portletsPool;
    }

    private void _readLiferayDisplay(String servletContextName, Element el, PortletCategory portletCategory, Set<String> portletIds) {
        for (Element category : el.elements("category")) {
            String name = category.attributeValue("name");
            PortletCategory curPortletCategory = new PortletCategory(name);
            portletCategory.addCategory(curPortletCategory);
            Set curPortletIds = curPortletCategory.getPortletIds();
            for (Element portlet : category.elements("portlet")) {
                String portletId = portlet.attributeValue("id");
                if (Validator.isNotNull((String)servletContextName)) {
                    portletId = portletId + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId((String)portletId);
                portletIds.add(portletId);
                curPortletIds.add(portletId);
            }
            this._readLiferayDisplay(servletContextName, category, curPortletCategory, portletIds);
        }
    }

    private PortletCategory _readLiferayDisplayXML(String xml) throws Exception {
        return this._readLiferayDisplayXML(null, xml);
    }

    private PortletCategory _readLiferayDisplayXML(String servletContextName, String xml) throws Exception {
        PortletCategory portletCategory = new PortletCategory();
        if (xml == null) {
            xml = ContentUtil.get("com/liferay/portal/deploy/dependencies/liferay-display.xml");
        }
        Document doc = SAXReaderUtil.read((String)xml, (boolean)true);
        Element root = doc.getRootElement();
        HashSet<String> portletIds = new HashSet<String>();
        this._readLiferayDisplay(servletContextName, root, portletCategory, portletIds);
        HashSet<String> undefinedPortletIds = new HashSet<String>();
        for (Portlet portlet : this._getPortletsPool().values()) {
            String portletId = portlet.getPortletId();
            PortletApp portletApp = portlet.getPortletApp();
            if (servletContextName != null && portletApp.isWARFile() && portletId.endsWith("_WAR_" + PortalUtil.getJsSafePortletId((String)servletContextName)) && !portletIds.contains(portletId)) {
                undefinedPortletIds.add(portletId);
                continue;
            }
            if (servletContextName != null || portletApp.isWARFile() || portletId.indexOf("_WAR_") != -1 || portletIds.contains(portletId)) continue;
            undefinedPortletIds.add(portletId);
        }
        if (undefinedPortletIds.size() > 0) {
            PortletCategory undefinedCategory = new PortletCategory("category.undefined");
            portletCategory.addCategory(undefinedCategory);
            undefinedCategory.getPortletIds().addAll(undefinedPortletIds);
        }
        return portletCategory;
    }

    private Set<String> _readLiferayPortletXML(String xml, Map<String, Portlet> portletsPool) throws Exception {
        return this._readLiferayPortletXML("", xml, portletsPool);
    }

    private Set<String> _readLiferayPortletXML(String servletContextName, String xml, Map<String, Portlet> portletsPool) throws Exception {
        HashSet<String> liferayPortletIds = new HashSet<String>();
        if (xml == null) {
            return liferayPortletIds;
        }
        Document doc = SAXReaderUtil.read((String)xml, (boolean)true);
        Element root = doc.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        HashMap<String, String> roleMappers = new HashMap<String, String>();
        for (Element roleMapper : root.elements("role-mapper")) {
            String roleName = roleMapper.elementText("role-name");
            String roleLink = roleMapper.elementText("role-link");
            roleMappers.put(roleName, roleLink);
        }
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Element customUserAttribute : root.elements("custom-user-attribute")) {
            String customClass = customUserAttribute.elementText("custom-class");
            for (Element nameEl : customUserAttribute.elements("name")) {
                String name = nameEl.getText();
                customUserAttributes.put(name, customClass);
            }
        }
        for (Element portlet : root.elements("portlet")) {
            String portletId = portlet.elementText("portlet-name");
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId + "_WAR_" + servletContextName;
            }
            portletId = PortalUtil.getJsSafePortletId((String)portletId);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading portlet extension " + portletId));
            }
            liferayPortletIds.add(portletId);
            Portlet portletModel = portletsPool.get(portletId);
            if (portletModel == null) continue;
            portletModel.setIcon(GetterUtil.getString((String)portlet.elementText("icon"), (String)portletModel.getIcon()));
            portletModel.setVirtualPath(GetterUtil.getString((String)portlet.elementText("virtual-path"), (String)portletModel.getVirtualPath()));
            portletModel.setStrutsPath(GetterUtil.getString((String)portlet.elementText("struts-path"), (String)portletModel.getStrutsPath()));
            if (Validator.isNotNull((String)portlet.elementText("configuration-path"))) {
                _log.error((Object)"The configuration-path element is no longer supported. Use configuration-action-class instead.");
            }
            portletModel.setConfigurationActionClass(GetterUtil.getString((String)portlet.elementText("configuration-action-class"), (String)portletModel.getConfigurationActionClass()));
            portletModel.setIndexerClass(GetterUtil.getString((String)portlet.elementText("indexer-class"), (String)portletModel.getIndexerClass()));
            portletModel.setOpenSearchClass(GetterUtil.getString((String)portlet.elementText("open-search-class"), (String)portletModel.getOpenSearchClass()));
            portletModel.setSchedulerClass(GetterUtil.getString((String)portlet.elementText("scheduler-class"), (String)portletModel.getSchedulerClass()));
            portletModel.setPortletURLClass(GetterUtil.getString((String)portlet.elementText("portlet-url-class"), (String)portletModel.getPortletURLClass()));
            portletModel.setFriendlyURLMapperClass(GetterUtil.getString((String)portlet.elementText("friendly-url-mapper-class"), (String)portletModel.getFriendlyURLMapperClass()));
            if (Validator.isNull((String)portletModel.getFriendlyURLMapperClass())) {
                _friendlyURLMapperPortlets.remove(portletId);
            } else {
                _friendlyURLMapperPortlets.put(portletId, portletModel);
            }
            portletModel.setURLEncoderClass(GetterUtil.getString((String)portlet.elementText("url-encoder-class"), (String)portletModel.getURLEncoderClass()));
            portletModel.setPortletDataHandlerClass(GetterUtil.getString((String)portlet.elementText("portlet-data-handler-class"), (String)portletModel.getPortletDataHandlerClass()));
            portletModel.setPortletLayoutListenerClass(GetterUtil.getString((String)portlet.elementText("portlet-layout-listener-class"), (String)portletModel.getPortletLayoutListenerClass()));
            portletModel.setPollerProcessorClass(GetterUtil.getString((String)portlet.elementText("poller-processor-class"), (String)portletModel.getPollerProcessorClass()));
            portletModel.setPopMessageListenerClass(GetterUtil.getString((String)portlet.elementText("pop-message-listener-class"), (String)portletModel.getPopMessageListenerClass()));
            portletModel.setSocialActivityInterpreterClass(GetterUtil.getString((String)portlet.elementText("social-activity-interpreter-class"), (String)portletModel.getSocialActivityInterpreterClass()));
            portletModel.setSocialRequestInterpreterClass(GetterUtil.getString((String)portlet.elementText("social-request-interpreter-class"), (String)portletModel.getSocialRequestInterpreterClass()));
            portletModel.setWebDAVStorageToken(GetterUtil.getString((String)portlet.elementText("webdav-storage-token"), (String)portletModel.getWebDAVStorageToken()));
            portletModel.setWebDAVStorageClass(GetterUtil.getString((String)portlet.elementText("webdav-storage-class"), (String)portletModel.getWebDAVStorageClass()));
            portletModel.setControlPanelEntryCategory(GetterUtil.getString((String)portlet.elementText("control-panel-entry-category"), (String)portletModel.getControlPanelEntryCategory()));
            portletModel.setControlPanelEntryWeight(GetterUtil.getDouble((String)portlet.elementText("control-panel-entry-weight"), (double)portletModel.getControlPanelEntryWeight()));
            portletModel.setControlPanelEntryClass(GetterUtil.getString((String)portlet.elementText("control-panel-entry-class"), (String)portletModel.getControlPanelEntryClass()));
            portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((String)portlet.elementText("preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
            portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((String)portlet.elementText("preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
            portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((String)portlet.elementText("preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
            portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((String)portlet.elementText("use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
            portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((String)portlet.elementText("show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
            portletModel.setShowPortletInactive(GetterUtil.getBoolean((String)portlet.elementText("show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
            portletModel.setActionURLRedirect(GetterUtil.getBoolean((String)portlet.elementText("action-url-redirect"), (boolean)portletModel.isActionURLRedirect()));
            portletModel.setRestoreCurrentView(GetterUtil.getBoolean((String)portlet.elementText("restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
            portletModel.setMaximizeEdit(GetterUtil.getBoolean((String)portlet.elementText("maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
            portletModel.setMaximizeHelp(GetterUtil.getBoolean((String)portlet.elementText("maximize-help"), (boolean)portletModel.isMaximizeHelp()));
            portletModel.setPopUpPrint(GetterUtil.getBoolean((String)portlet.elementText("pop-up-print"), (boolean)portletModel.isPopUpPrint()));
            portletModel.setLayoutCacheable(GetterUtil.getBoolean((String)portlet.elementText("layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
            portletModel.setInstanceable(GetterUtil.getBoolean((String)portlet.elementText("instanceable"), (boolean)portletModel.isInstanceable()));
            portletModel.setScopeable(GetterUtil.getBoolean((String)portlet.elementText("scopeable"), (boolean)portletModel.isScopeable()));
            portletModel.setUserPrincipalStrategy(GetterUtil.getString((String)portlet.elementText("user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
            portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((String)portlet.elementText("private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
            portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((String)portlet.elementText("private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
            portletModel.setRenderWeight(GetterUtil.getInteger((String)portlet.elementText("render-weight"), (int)portletModel.getRenderWeight()));
            portletModel.setAjaxable(GetterUtil.getBoolean((String)portlet.elementText("ajaxable"), (boolean)portletModel.isAjaxable()));
            List headerPortalCssList = portletModel.getHeaderPortalCss();
            for (Element headerPortalCssEl : portlet.elements("header-portal-css")) {
                headerPortalCssList.add(headerPortalCssEl.getText());
            }
            List headerPortletCssList = portletModel.getHeaderPortletCss();
            ArrayList list = new ArrayList();
            list.addAll(portlet.elements("header-css"));
            list.addAll(portlet.elements("header-portlet-css"));
            for (Element headerPortletCssEl : list) {
                headerPortletCssList.add(headerPortletCssEl.getText());
            }
            List headerPortalJavaScriptList = portletModel.getHeaderPortalJavaScript();
            for (Element headerPortalJavaScriptEl : portlet.elements("header-portal-javascript")) {
                headerPortalJavaScriptList.add(headerPortalJavaScriptEl.getText());
            }
            List headerPortletJavaScriptList = portletModel.getHeaderPortletJavaScript();
            list.clear();
            list.addAll(portlet.elements("header-javascript"));
            list.addAll(portlet.elements("header-portlet-javascript"));
            for (Element headerPortletJavaScriptEl : list) {
                headerPortletJavaScriptList.add(headerPortletJavaScriptEl.getText());
            }
            List footerPortalCssList = portletModel.getFooterPortalCss();
            for (Element footerPortalCssEl : portlet.elements("footer-portal-css")) {
                footerPortalCssList.add(footerPortalCssEl.getText());
            }
            List footerPortletCssList = portletModel.getFooterPortletCss();
            for (Element footerPortletCssEl : portlet.elements("footer-portlet-css")) {
                footerPortletCssList.add(footerPortletCssEl.getText());
            }
            List footerPortalJavaScriptList = portletModel.getFooterPortalJavaScript();
            for (Element footerPortalJavaScriptEl : portlet.elements("footer-portal-javascript")) {
                footerPortalJavaScriptList.add(footerPortalJavaScriptEl.getText());
            }
            List footerPortletJavaScriptList = portletModel.getFooterPortletJavaScript();
            for (Element footerPortletJavaScriptEl : portlet.elements("footer-portlet-javascript")) {
                footerPortletJavaScriptList.add(footerPortletJavaScriptEl.getText());
            }
            portletModel.setCssClassWrapper(GetterUtil.getString((String)portlet.elementText("css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
            portletModel.setFacebookIntegration(GetterUtil.getString((String)portlet.elementText("facebook-integration"), (String)portletModel.getFacebookIntegration()));
            portletModel.setAddDefaultResource(GetterUtil.getBoolean((String)portlet.elementText("add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
            portletModel.setSystem(GetterUtil.getBoolean((String)portlet.elementText("system"), (boolean)portletModel.isSystem()));
            portletModel.setActive(GetterUtil.getBoolean((String)portlet.elementText("active"), (boolean)portletModel.isActive()));
            portletModel.setInclude(GetterUtil.getBoolean((String)portlet.elementText("include"), (boolean)portletModel.isInclude()));
            if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
                portletModel.setRenderWeight(1);
            }
            portletModel.getRoleMappers().putAll(roleMappers);
            portletModel.linkRoles();
        }
        return liferayPortletIds;
    }

    private Set<String> _readPortletXML(ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, List<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        return this._readPortletXML("", servletContext, xml, portletsPool, servletURLPatterns, pluginPackage);
    }

    private Set<String> _readPortletXML(String servletContextName, ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, List<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        String filterName;
        QName qName;
        HashSet<String> portletIds = new HashSet<String>();
        if (xml == null) {
            return portletIds;
        }
        Document doc = SAXReaderUtil.read((String)xml, (boolean)PropsValues.PORTLET_XML_VALIDATE);
        Element root = doc.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        portletApp.getServletURLPatterns().addAll(servletURLPatterns);
        Set userAttributes = portletApp.getUserAttributes();
        for (Element userAttribute : root.elements("user-attribute")) {
            String name = userAttribute.elementText("name");
            userAttributes.add(name);
        }
        String defaultNamespace = root.elementText("default-namespace");
        if (Validator.isNotNull((String)defaultNamespace)) {
            portletApp.setDefaultNamespace(defaultNamespace);
        }
        for (Element eventDefinitionEl : root.elements("event-definition")) {
            Element qNameEl = eventDefinitionEl.element("qname");
            Element nameEl = eventDefinitionEl.element("name");
            String valueType = eventDefinitionEl.elementText("value-type");
            qName = PortletQNameUtil.getQName((Element)qNameEl, (Element)nameEl, (String)portletApp.getDefaultNamespace());
            EventDefinitionImpl eventDefinition = new EventDefinitionImpl(qName, valueType, portletApp);
            portletApp.addEventDefinition((EventDefinition)eventDefinition);
        }
        for (Element publicRenderParameterEl : root.elements("public-render-parameter")) {
            String identifier = publicRenderParameterEl.elementText("identifier");
            Element qNameEl = publicRenderParameterEl.element("qname");
            Element nameEl = publicRenderParameterEl.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameEl, (Element)nameEl, (String)portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, qName, portletApp);
            portletApp.addPublicRenderParameter((PublicRenderParameter)publicRenderParameter);
        }
        for (Element containerRuntimeOption : root.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOption.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element value : containerRuntimeOption.elements("value")) {
                values.add(value.getTextTrim());
            }
            portletApp.getContainerRuntimeOptions().put(name, values.toArray(new String[values.size()]));
            if (!name.equals("com.liferay.portal.portalContext") || values.isEmpty() || !GetterUtil.getBoolean((String)((String)values.get(0)))) continue;
            portletApp.setWARFile(false);
        }
        long timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext);
        for (Element portlet : root.elements("portlet")) {
            QName qName2;
            Element nameEl;
            Element qNameEl;
            Portlet portletModel;
            block40: {
                String portletName;
                String portletId = portletName = portlet.elementText("portlet-name");
                if (Validator.isNotNull((String)servletContextName)) {
                    portletId = portletId + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId((String)portletId);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Reading portlet " + portletId));
                }
                portletIds.add(portletId);
                portletModel = portletsPool.get(portletId);
                if (portletModel == null) {
                    portletModel = new PortletImpl(0L, portletId);
                    portletsPool.put(portletId, portletModel);
                }
                portletModel.setTimestamp(timestamp);
                portletModel.setPluginPackage(pluginPackage);
                portletModel.setPortletApp(portletApp);
                portletModel.setPortletName(portletName);
                portletModel.setDisplayName(GetterUtil.getString((String)portlet.elementText("display-name"), (String)portletModel.getDisplayName()));
                portletModel.setPortletClass(GetterUtil.getString((String)portlet.elementText("portlet-class")));
                for (Element initParam : portlet.elements("init-param")) {
                    portletModel.getInitParams().put(initParam.elementText("name"), initParam.elementText("value"));
                }
                Element expirationCache = portlet.element("expiration-cache");
                if (expirationCache != null) {
                    portletModel.setExpCache(new Integer(GetterUtil.getInteger((String)expirationCache.getText())));
                }
                for (Element supports : portlet.elements("supports")) {
                    String mimeType = supports.elementText("mime-type");
                    HashSet<String> mimeTypePortletModes = (HashSet<String>)portletModel.getPortletModes().get(mimeType);
                    if (mimeTypePortletModes == null) {
                        mimeTypePortletModes = new HashSet<String>();
                        portletModel.getPortletModes().put(mimeType, mimeTypePortletModes);
                    }
                    mimeTypePortletModes.add(PortletMode.VIEW.toString().toLowerCase());
                    for (Element portletMode : supports.elements("portlet-mode")) {
                        mimeTypePortletModes.add(portletMode.getTextTrim().toLowerCase());
                    }
                    HashSet<String> mimeTypeWindowStates = (HashSet<String>)portletModel.getWindowStates().get(mimeType);
                    if (mimeTypeWindowStates == null) {
                        mimeTypeWindowStates = new HashSet<String>();
                        portletModel.getWindowStates().put(mimeType, mimeTypeWindowStates);
                    }
                    mimeTypeWindowStates.add(WindowState.NORMAL.toString().toLowerCase());
                    Iterator itr3 = supports.elements("window-state").iterator();
                    if (!itr3.hasNext()) {
                        mimeTypeWindowStates.add(WindowState.MAXIMIZED.toString().toLowerCase());
                        mimeTypeWindowStates.add(WindowState.MINIMIZED.toString().toLowerCase());
                        mimeTypeWindowStates.add(LiferayWindowState.EXCLUSIVE.toString().toLowerCase());
                        mimeTypeWindowStates.add(LiferayWindowState.POP_UP.toString().toLowerCase());
                    }
                    while (itr3.hasNext()) {
                        Element windowState = (Element)itr3.next();
                        mimeTypeWindowStates.add(windowState.getTextTrim().toLowerCase());
                    }
                }
                Set supportedLocales = portletModel.getSupportedLocales();
                for (Element supportedLocaleEl : portlet.elements("supported-locale")) {
                    String supportedLocale = supportedLocaleEl.getText();
                    supportedLocales.add(supportedLocale);
                }
                portletModel.setResourceBundle(portlet.elementText("resource-bundle"));
                Element portletInfo = portlet.element("portlet-info");
                String portletInfoTitle = null;
                String portletInfoShortTitle = null;
                String portletInfoKeyWords = null;
                String portletInfoDescription = null;
                if (portletInfo != null) {
                    portletInfoTitle = portletInfo.elementText("title");
                    portletInfoShortTitle = portletInfo.elementText("short-title");
                    portletInfoKeyWords = portletInfo.elementText("keywords");
                }
                portletModel.setPortletInfo(new PortletInfo(portletInfoTitle, portletInfoShortTitle, portletInfoKeyWords, portletInfoDescription));
                Element portletPreferences = portlet.element("portlet-preferences");
                String defaultPreferences = null;
                String preferencesValidator = null;
                if (portletPreferences != null) {
                    Element preferencesValidatorEl = portletPreferences.element("preferences-validator");
                    if (preferencesValidatorEl != null) {
                        preferencesValidator = preferencesValidatorEl.getText();
                        portletPreferences.remove(preferencesValidatorEl);
                    }
                    defaultPreferences = portletPreferences.asXML();
                }
                portletModel.setDefaultPreferences(defaultPreferences);
                portletModel.setPreferencesValidator(preferencesValidator);
                if (!portletApp.isWARFile() && Validator.isNotNull((String)preferencesValidator) && PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                    try {
                        PreferencesValidator preferencesValidatorObj = PortalUtil.getPreferencesValidator((Portlet)portletModel);
                        preferencesValidatorObj.validate(PortletPreferencesSerializer.fromDefaultXML(defaultPreferences));
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block40;
                        _log.warn((Object)("Portlet with the name " + portletId + " does not have valid default preferences"));
                    }
                }
            }
            Set unlikedRoles = portletModel.getUnlinkedRoles();
            for (Element role : portlet.elements("security-role-ref")) {
                unlikedRoles.add(role.elementText("role-name"));
            }
            for (Element supportedProcessingEvent : portlet.elements("supported-processing-event")) {
                qNameEl = supportedProcessingEvent.element("qname");
                nameEl = supportedProcessingEvent.element("name");
                qName2 = PortletQNameUtil.getQName((Element)qNameEl, (Element)nameEl, (String)portletApp.getDefaultNamespace());
                portletModel.addProcessingEvent(qName2);
            }
            for (Element supportedPublishingEvent : portlet.elements("supported-publishing-event")) {
                qNameEl = supportedPublishingEvent.element("qname");
                nameEl = supportedPublishingEvent.element("name");
                qName2 = PortletQNameUtil.getQName((Element)qNameEl, (Element)nameEl, (String)portletApp.getDefaultNamespace());
                portletModel.addPublishingEvent(qName2);
            }
            for (Element supportedPublicRenderParameter : portlet.elements("supported-public-render-parameter")) {
                String identifier = supportedPublicRenderParameter.getTextTrim();
                PublicRenderParameter publicRenderParameter = portletApp.getPublicRenderParameter(identifier);
                if (publicRenderParameter == null) {
                    _log.error((Object)("Supported public render parameter references unnknown identifier " + identifier));
                    continue;
                }
                portletModel.addPublicRenderParameter(publicRenderParameter);
            }
        }
        for (Element filter : root.elements("filter")) {
            filterName = filter.elementText("filter-name");
            String filterClass = filter.elementText("filter-class");
            LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
            for (Element lifecycle : filter.elements("lifecycle")) {
                lifecycles.add(lifecycle.getText());
            }
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParam : filter.elements("init-param")) {
                initParams.put(initParam.elementText("name"), initParam.elementText("value"));
            }
            PortletFilterImpl portletFilter = new PortletFilterImpl(filterName, filterClass, lifecycles, initParams, portletApp);
            portletApp.addPortletFilter((PortletFilter)portletFilter);
        }
        for (Element filterMapping : root.elements("filter-mapping")) {
            filterName = filterMapping.elementText("filter-name");
            for (Element portletNameEl : filterMapping.elements("portlet-name")) {
                String portletName = portletNameEl.getTextTrim();
                PortletFilter portletFilter = portletApp.getPortletFilter(filterName);
                if (portletFilter == null) {
                    _log.error((Object)("Filter mapping references unnknown filter name " + filterName));
                    continue;
                }
                List<Portlet> portletModels = this._getPortletsByPortletName(portletName, servletContextName, portletsPool);
                if (portletModels.size() == 0) {
                    _log.error((Object)("Filter mapping with filter name " + filterName + " references unnknown portlet name " + portletName));
                }
                for (Portlet portletModel : portletModels) {
                    portletModel.getPortletFilters().put(filterName, portletFilter);
                }
            }
        }
        for (Element listener : root.elements("listener")) {
            String listenerClass = listener.elementText("listener-class");
            PortletURLListenerImpl portletURLListener = new PortletURLListenerImpl(listenerClass, portletApp);
            portletApp.addPortletURLListener((PortletURLListener)portletURLListener);
        }
        return portletIds;
    }

    private List<String> _readWebXML(String xml) throws Exception {
        ArrayList<String> servletURLPatterns = new ArrayList<String>();
        if (xml == null) {
            return servletURLPatterns;
        }
        Document doc = SAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        for (Element servletMapping : root.elements("servlet-mapping")) {
            String urlPattern = servletMapping.elementText("url-pattern");
            servletURLPatterns.add(urlPattern);
        }
        return servletURLPatterns;
    }

    private void _setSpriteImages(ServletContext servletContext, PortletApp portletApp, String resourcePath) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null) {
            return;
        }
        ArrayList<File> images = new ArrayList<File>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, portletApp, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            String realPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)curResourcePath);
            if (realPath != null) {
                images.add(new File(realPath));
                continue;
            }
            if (ServerDetector.isTomcat()) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)"Please configure Tomcat to unpack WARs to enable enable sprites for best performance");
                continue;
            }
            _log.error((Object)("Real path for " + curResourcePath + " is null"));
        }
        String spriteFileName = ".sprite.png";
        String spritePropertiesFileName = ".sprite.properties";
        String spritePropertiesRootPath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)"/");
        Properties spriteProperties = SpriteProcessorUtil.generate(images, (String)spriteFileName, (String)spritePropertiesFileName, (String)spritePropertiesRootPath, (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        spriteFileName = resourcePath.substring(0, resourcePath.length()) + spriteFileName;
        portletApp.setSpriteImages(spriteFileName, spriteProperties);
    }
}

